/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.util.Enumeration;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.ConnectionFactory;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerRegistry;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceEngineFactory;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    public static final String GENERIC_ENGINE = "generic";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$jdo$engine$AbstractConnectionFactory == null ? (class$org$castor$jdo$engine$AbstractConnectionFactory = AbstractConnectionFactory.class$("org.castor.jdo.engine.AbstractConnectionFactory")) : class$org$castor$jdo$engine$AbstractConnectionFactory));
    private boolean _initialized = false;
    private JdoConf _jdoConf;
    private int _index;
    private String _name;
    private org.exolab.castor.mapping.Mapping _mapping;
    private TransactionManager _txManager;
    private LockEngine _engine = null;
    static /* synthetic */ Class class$org$castor$jdo$engine$AbstractConnectionFactory;

    protected AbstractConnectionFactory(String name, String engine, org.exolab.castor.mapping.Mapping mapping, TransactionManager txManager) throws MappingException {
        this._jdoConf = null;
        this._index = -1;
        this._name = name;
        this._mapping = mapping;
        this._txManager = txManager;
        this.initializeEngine(engine);
        this._initialized = true;
    }

    protected AbstractConnectionFactory(JdoConf jdoConf, int index, org.exolab.castor.mapping.Mapping mapping) {
        this._jdoConf = jdoConf;
        this._index = index;
        this._name = jdoConf.getDatabase(index).getName();
        this._mapping = mapping;
        this._txManager = null;
    }

    public final void initialize() throws MappingException {
        if (!this._initialized) {
            this.initializeMapping();
            this._txManager = TransactionManagerRegistry.getTransactionManager(this._jdoConf);
            this.initializeEngine(this._jdoConf.getDatabase(this._index).getEngine());
            this.initializeFactory();
            this._initialized = true;
        }
    }

    private void initializeMapping() throws MappingException {
        try {
            Enumeration mappings = this._jdoConf.getDatabase(this._index).enumerateMapping();
            while (mappings.hasMoreElements()) {
                Mapping mapConf = (Mapping)mappings.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading the mapping descriptor: " + mapConf.getHref()));
                }
                if (mapConf.getHref() == null) continue;
                this._mapping.loadMapping(mapConf.getHref());
            }
        }
        catch (MappingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappingException(ex);
        }
    }

    private void initializeEngine(String engine) throws MappingException {
        PersistenceFactory factory = engine == null ? PersistenceFactoryRegistry.getPersistenceFactory(GENERIC_ENGINE) : PersistenceFactoryRegistry.getPersistenceFactory(engine);
        if (factory == null) {
            String msg = Messages.format("jdo.noSuchEngine", engine);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        this._engine = new PersistenceEngineFactory().createEngine(this, this._mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, factory), factory);
    }

    protected abstract void initializeFactory() throws MappingException;

    public final String getName() {
        return this._name;
    }

    public final Database getDatabase() {
        return this._jdoConf.getDatabase(this._index);
    }

    public final org.exolab.castor.mapping.Mapping getMapping() {
        return this._mapping;
    }

    public final TransactionManager getTransactionManager() {
        return this._txManager;
    }

    public final LockEngine getEngine() {
        return this._engine;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

