/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.keygen;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class SequenceKeyGenerator
implements KeyGenerator {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$keygen$SequenceKeyGenerator == null ? (class$org$exolab$castor$jdo$keygen$SequenceKeyGenerator = SequenceKeyGenerator.class$("org.exolab.castor.jdo.keygen.SequenceKeyGenerator")) : class$org$exolab$castor$jdo$keygen$SequenceKeyGenerator);
    protected final PersistenceFactory _factory;
    protected final String _factoryName;
    protected final String _seqName;
    private byte _style;
    private final int _sqlType;
    private int _increment;
    private boolean _triggerPresent;
    static /* synthetic */ Class class$org$exolab$castor$jdo$keygen$SequenceKeyGenerator;

    public SequenceKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        this._factoryName = factory.getFactoryName();
        boolean returning = "true".equals(params.getProperty("returning"));
        this._triggerPresent = "true".equals(params.getProperty("trigger", "false"));
        if (!(this._factoryName.equals("oracle") || this._factoryName.equals("postgresql") || this._factoryName.equals("interbase") || this._factoryName.equals("sapdb") || this._factoryName.equals("db2"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), this._factoryName));
        }
        if (!this._factoryName.equals("oracle") && returning) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "returning=\"true\"", this.getClass().getName(), this._factoryName));
        }
        this._factory = factory;
        this._seqName = params.getProperty("sequence", "{0}_seq");
        this._style = (byte)(this._factoryName.equals("postgresql") || this._factoryName.equals("interbase") || this._factoryName.equals("db2") ? -1 : (returning ? 0 : 1));
        if (this._triggerPresent && !returning) {
            this._style = 1;
        }
        if (this._triggerPresent && this._style == -1) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "trigger=\"true\"", this.getClass().getName(), this._factoryName));
        }
        this._sqlType = sqlType;
        this.supportsSqlType(sqlType);
        try {
            this._increment = Integer.parseInt(params.getProperty("increment", "1"));
        }
        catch (NumberFormatException nfe) {
            this._increment = 1;
        }
    }

    public void supportsSqlType(int sqlType) throws MappingException {
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Statement stmt;
        block20: {
            Object insStmt;
            block25: {
                int value;
                block23: {
                    block24: {
                        block21: {
                            block22: {
                                ResultSet rs;
                                stmt = null;
                                String seqName = MessageFormat.format(this._seqName, tableName, primKeyName);
                                String table = this._factory.quoteName(tableName);
                                if (this._factory.getFactoryName().equals("interbase")) {
                                    stmt = conn.prepareStatement("SELECT gen_id(" + seqName + "," + this._increment + ") FROM rdb$database");
                                    rs = stmt.executeQuery();
                                } else if (this._factory.getFactoryName().equals("db2")) {
                                    stmt = conn.prepareStatement("SELECT nextval FOR " + seqName + " FROM SYSIBM.SYSDUMMY1");
                                    rs = stmt.executeQuery();
                                } else if (this._style == -1) {
                                    stmt = conn.prepareStatement("SELECT nextval('" + seqName + "')");
                                    rs = stmt.executeQuery();
                                } else if (this._triggerPresent && this._factoryName.equals("postgresql")) {
                                    insStmt = props.get("insertStatement");
                                    Class<?> psqlStmtClass = Class.forName("org.postgresql.Statement");
                                    Method getInsertedOID = psqlStmtClass.getMethod("getInsertedOID", null);
                                    int insertedOID = (Integer)getInsertedOID.invoke(insStmt, (Object[])null);
                                    stmt = conn.prepareStatement("SELECT " + this._factory.quoteName(primKeyName) + " FROM " + table + " WHERE OID=?");
                                    stmt.setInt(1, insertedOID);
                                    rs = stmt.executeQuery();
                                } else {
                                    stmt = conn.prepareStatement("SELECT " + this._factory.quoteName(seqName + ".currval") + " FROM " + table);
                                    rs = stmt.executeQuery();
                                }
                                if (!rs.next()) break block20;
                                value = rs.getInt(1);
                                if (this._sqlType != 4) break block21;
                                insStmt = new Integer(value);
                                Object var15_15 = null;
                                if (stmt == null) break block22;
                                try {
                                    stmt.close();
                                }
                                catch (SQLException ex) {
                                    _log.warn((Object)"Problem closing JDBC Statement", (Throwable)ex);
                                }
                            }
                            return insStmt;
                        }
                        if (this._sqlType != -5) break block23;
                        insStmt = new Long(value);
                        Object var15_16 = null;
                        if (stmt == null) break block24;
                        try {
                            stmt.close();
                        }
                        catch (SQLException ex) {
                            _log.warn((Object)"Problem closing JDBC Statement", (Throwable)ex);
                        }
                    }
                    return insStmt;
                }
                insStmt = new BigDecimal((double)value);
                Object var15_17 = null;
                if (stmt == null) break block25;
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    _log.warn((Object)"Problem closing JDBC Statement", (Throwable)ex);
                }
            }
            return insStmt;
        }
        try {
            try {
                throw new PersistenceException(Messages.format("persist.keyGenFailed", this.getClass().getName()));
            }
            catch (Exception ex) {
                throw new PersistenceException(Messages.format("persist.keyGenSQL", this.getClass().getName(), ex.toString()));
            }
        }
        catch (Throwable throwable) {
            block26: {
                Object var15_18 = null;
                if (stmt == null) break block26;
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    _log.warn((Object)"Problem closing JDBC Statement", (Throwable)ex);
                }
            }
            throw throwable;
        }
    }

    public byte getStyle() {
        return this._style;
    }

    public String patchSQL(String insert, String primKeyName) throws MappingException {
        if (this._style == -1) {
            return insert;
        }
        StringTokenizer st = new StringTokenizer(insert);
        if (!st.hasMoreTokens() || !st.nextToken().equalsIgnoreCase("INSERT")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", insert));
        }
        if (!st.hasMoreTokens() || !st.nextToken().equalsIgnoreCase("INTO")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", insert));
        }
        if (!st.hasMoreTokens()) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", insert));
        }
        String tableName = st.nextToken();
        int idxQuote = tableName.indexOf(34);
        if (idxQuote >= 0) {
            StringBuffer buffer2 = new StringBuffer();
            int pos = 0;
            do {
                buffer2.append(tableName.substring(pos, idxQuote));
            } while ((idxQuote = tableName.indexOf(34, pos = idxQuote + 1)) != -1);
            buffer2.append(tableName.substring(pos));
            tableName = buffer2.toString();
        }
        String seqName = MessageFormat.format(this._seqName, tableName, primKeyName);
        String nextval = this._factory.quoteName(seqName + ".nextval");
        int lp1 = insert.indexOf(40);
        int lp2 = insert.indexOf(40, lp1 + 1);
        if (lp1 < 0) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", insert));
        }
        StringBuffer sb = new StringBuffer(insert);
        if (!this._triggerPresent) {
            if (lp2 < 0) {
                lp2 = lp1;
                lp1 = insert.indexOf(" VALUES ");
                sb.insert(lp2 + 1, nextval);
                sb.insert(lp1 + 1, "(" + this._factory.quoteName(primKeyName) + ") ");
            } else {
                sb.insert(lp2 + 1, nextval + ",");
                sb.insert(lp1 + 1, this._factory.quoteName(primKeyName) + ",");
            }
        }
        if (this._style == 0) {
            sb.append(" RETURNING ");
            sb.append(this._factory.quoteName(primKeyName));
            sb.append(" INTO ?");
        }
        return sb.toString();
    }

    public boolean isInSameConnection() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

