/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.oql.InvalidCharException;
import org.exolab.castor.jdo.oql.Lexer;
import org.exolab.castor.jdo.oql.NoMoreTokensException;
import org.exolab.castor.jdo.oql.OQLSyntaxException;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.Token;
import org.exolab.castor.jdo.oql.TokenTypes;

public class Parser
implements TokenTypes {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$oql$Parser == null ? (class$org$exolab$castor$jdo$oql$Parser = Parser.class$("org.exolab.castor.jdo.oql.Parser")) : class$org$exolab$castor$jdo$oql$Parser);
    Lexer _lexer;
    Token _curToken = null;
    Token _nextToken = null;
    ParseTreeNode _treeRoot;
    private static Hashtable tokenTypes = new Hashtable();
    static /* synthetic */ Class class$org$exolab$castor$jdo$oql$Parser;

    public Parser(Lexer lexer) throws InvalidCharException, OQLSyntaxException {
        this._lexer = lexer;
        this.primeLexer();
    }

    public ParseTreeNode getParseTree() throws InvalidCharException, OQLSyntaxException {
        this._treeRoot = this.match(1);
        if (this._curToken.getTokenType() == 41) {
            this._treeRoot.addChild(this.match(41));
        }
        this._treeRoot.addChild(this.projectionAttributes());
        this._treeRoot.addChild(this.fromClause());
        if (this._curToken.getTokenType() == 7) {
            this._treeRoot.addChild(this.whereClause());
        }
        if (this._curToken.getTokenType() == 46) {
            this._treeRoot.addChild(this.orderClause());
        }
        if (this._curToken.getTokenType() == 55) {
            this._treeRoot.addChild(this.limitClause());
            if (this._curToken.getTokenType() == 56) {
                this._treeRoot.addChild(this.offsetClause());
            }
        }
        this.match(0);
        return this._treeRoot;
    }

    private void primeLexer() throws InvalidCharException, OQLSyntaxException {
        try {
            this._curToken = this._lexer.nextToken();
            this._nextToken = this._lexer.nextToken();
        }
        catch (NoMoreTokensException e) {
            throw new OQLSyntaxException("Incomplete query passed.");
        }
    }

    private ParseTreeNode match(int tokenType) throws InvalidCharException, OQLSyntaxException {
        if (this._curToken.getTokenType() != tokenType) {
            throw new OQLSyntaxException("An incorrect token type was found near " + this._curToken.getTokenValue() + " (found " + (String)tokenTypes.get(new Integer(this._curToken.getTokenType())) + ", but expected " + (String)tokenTypes.get(new Integer(tokenType)) + ")");
        }
        ParseTreeNode retNode = new ParseTreeNode(this._curToken);
        this._curToken = this._nextToken;
        try {
            this._nextToken = this._lexer.nextToken();
        }
        catch (NoMoreTokensException noMoreTokensException) {
            // empty catch block
        }
        return retNode;
    }

    private ParseTreeNode projectionAttributes() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        ParseTreeNode queryTarget = this.expr();
        if (this._curToken.getTokenType() == 3) {
            retNode = this.match(3);
            retNode.addChild(queryTarget);
            retNode.addChild(this.match(2));
        } else if (this._curToken.getTokenType() == 4) {
            if (queryTarget.getToken().getTokenType() != 2) {
                throw new OQLSyntaxException("When using the ':' in projection attributes (select part of query) the token before the ':' must be an identifier.");
            }
            this.match(4);
            retNode = new ParseTreeNode(new Token(3, "as"));
            retNode.addChild(this.expr());
            retNode.addChild(queryTarget);
        }
        if (retNode == null) {
            return queryTarget;
        }
        return retNode;
    }

    private ParseTreeNode fromClause() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = this.match(5);
        retNode.addChild(this.iteratorDef());
        return retNode;
    }

    private ParseTreeNode iteratorDef() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        ParseTreeNode tableIdentifier = null;
        if (this._nextToken.getTokenType() == 30) {
            tableIdentifier = new ParseTreeNode(new Token(30, "."));
            tableIdentifier.addChild(this.match(2));
        } else {
            tableIdentifier = this.match(2);
        }
        while (this._curToken.getTokenType() == 30) {
            this.match(30);
            tableIdentifier.addChild(this.match(2));
        }
        if (this._curToken.getTokenType() == 3) {
            retNode = this.match(3);
            retNode.addChild(tableIdentifier);
            retNode.addChild(this.match(2));
        } else if (this._curToken.getTokenType() == 2) {
            retNode = new ParseTreeNode(new Token(3, "as"));
            retNode.addChild(tableIdentifier);
            retNode.addChild(this.match(2));
        } else if (this._curToken.getTokenType() == 6) {
            if (tableIdentifier.getChildCount() > 0) {
                throw new OQLSyntaxException("Only the class name in the from clause can contain dots.");
            }
            this.match(6);
            retNode = new ParseTreeNode(new Token(3, "as"));
            ParseTreeNode classNode = null;
            if (this._nextToken.getTokenType() == 30) {
                classNode = new ParseTreeNode(new Token(30, "."));
                classNode.addChild(this.match(2));
            } else {
                classNode = this.match(2);
            }
            while (this._curToken.getTokenType() == 30) {
                this.match(30);
                classNode.addChild(this.match(2));
            }
            retNode.addChild(classNode);
            retNode.addChild(tableIdentifier);
        }
        if (retNode == null) {
            return tableIdentifier;
        }
        return retNode;
    }

    private ParseTreeNode whereClause() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = this.match(7);
        retNode.addChild(this.expr());
        return retNode;
    }

    private ParseTreeNode expr() throws InvalidCharException, OQLSyntaxException {
        return this.orExpr();
    }

    private ParseTreeNode orExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode tmpNode = null;
        ParseTreeNode leftSide = this.andExpr();
        while (this._curToken.getTokenType() == 8) {
            tmpNode = this.match(8);
            tmpNode.addChild(leftSide);
            tmpNode.addChild(this.andExpr());
            leftSide = tmpNode;
        }
        return leftSide;
    }

    private ParseTreeNode andExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode tmpNode = null;
        ParseTreeNode leftSide = this.equalityExpr();
        while (this._curToken.getTokenType() == 9) {
            tmpNode = this.match(9);
            tmpNode.addChild(leftSide);
            tmpNode.addChild(this.equalityExpr());
            leftSide = tmpNode;
        }
        return leftSide;
    }

    private ParseTreeNode equalityExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        ParseTreeNode leftSide = this.relationalExpr();
        int tokenType = this._curToken.getTokenType();
        switch (tokenType) {
            case 10: 
            case 11: 
            case 12: {
                retNode = this.match(tokenType);
                retNode.addChild(leftSide);
                retNode.addChild(this.relationalExpr());
            }
        }
        if (retNode == null) {
            return leftSide;
        }
        return retNode;
    }

    private ParseTreeNode relationalExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        ParseTreeNode leftSide = this.additiveExpr();
        int tokenType = this._curToken.getTokenType();
        switch (tokenType) {
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                retNode = this.match(tokenType);
                retNode.addChild(leftSide);
                retNode.addChild(this.additiveExpr());
                break;
            }
            case 40: {
                retNode = this.match(40);
                retNode.addChild(leftSide);
                retNode.addChild(this.additiveExpr());
                this.match(9);
                retNode.addChild(this.additiveExpr());
            }
        }
        if (retNode == null) {
            return leftSide;
        }
        return retNode;
    }

    private ParseTreeNode additiveExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        ParseTreeNode leftSide = this.multiplicativeExpr();
        int tokenType = this._curToken.getTokenType();
        switch (tokenType) {
            case 17: 
            case 18: 
            case 19: {
                retNode = this.match(tokenType);
                retNode.addChild(leftSide);
                retNode.addChild(this.multiplicativeExpr());
            }
        }
        if (retNode == null) {
            return leftSide;
        }
        return retNode;
    }

    private ParseTreeNode multiplicativeExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        ParseTreeNode leftSide = this.inExpr();
        int tokenType = this._curToken.getTokenType();
        switch (tokenType) {
            case 20: 
            case 21: 
            case 22: {
                retNode = this.match(tokenType);
                retNode.addChild(leftSide);
                retNode.addChild(this.inExpr());
            }
        }
        if (retNode == null) {
            return leftSide;
        }
        return retNode;
    }

    private ParseTreeNode inExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        ParseTreeNode leftSide = this.unaryExpr();
        if (this._curToken.getTokenType() == 6) {
            retNode = this.match(6);
            retNode.addChild(leftSide);
            retNode.addChild(this.unaryExpr());
        }
        if (retNode == null) {
            return leftSide;
        }
        return retNode;
    }

    private ParseTreeNode unaryExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        int tokenType = this._curToken.getTokenType();
        switch (tokenType) {
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                retNode = this.match(tokenType);
                retNode.addChild(this.unaryExpr());
            }
        }
        if (retNode == null) {
            return this.postfixExpr();
        }
        return retNode;
    }

    private ParseTreeNode postfixExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        int curTokenType = this._curToken.getTokenType();
        int nextTokenType = 0;
        if (this._nextToken != null) {
            nextTokenType = this._nextToken.getTokenType();
        }
        if (curTokenType == 2 && (nextTokenType == 30 || nextTokenType == 31)) {
            retNode = new ParseTreeNode(new Token(30, "."));
            while (curTokenType == 2 && (nextTokenType == 30 || nextTokenType == 31)) {
                retNode.addChild(this.match(2));
                this.match(nextTokenType);
                curTokenType = this._curToken.getTokenType();
                if (this._nextToken != null) {
                    nextTokenType = this._nextToken.getTokenType();
                    continue;
                }
                nextTokenType = 0;
            }
            retNode.addChild(this.match(2));
        }
        if (retNode == null) {
            return this.primaryExpr();
        }
        return retNode;
    }

    private ParseTreeNode primaryExpr() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = null;
        int tokenType = this._curToken.getTokenType();
        switch (tokenType) {
            case 25: {
                retNode = this.match(25);
                retNode.addChild(this.expr());
                this.match(26);
                break;
            }
            case 42: 
            case 43: {
                retNode = this.undefinedExpr();
                break;
            }
            case 44: {
                retNode = this.collectionExpr();
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                retNode = this.aggregateExpr();
                break;
            }
            case 27: {
                retNode = this.queryParam();
                break;
            }
            case 2: {
                if (this._nextToken.getTokenType() == 25) {
                    retNode = this.functionCall();
                    break;
                }
                retNode = this.match(2);
                break;
            }
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                retNode = this.match(tokenType);
                break;
            }
            default: {
                throw new OQLSyntaxException("An inapropriate token (" + String.valueOf(tokenType) + ") was encountered in an expression.");
            }
        }
        if (retNode == null) {
            return this.primaryExpr();
        }
        return retNode;
    }

    private ParseTreeNode functionCall() throws InvalidCharException, OQLSyntaxException {
        int tokenType = this._curToken.getTokenType();
        int nextTokenType = this._nextToken.getTokenType();
        if (tokenType != 2 || nextTokenType != 25) {
            throw new OQLSyntaxException("Expected a function call and did not find one, near " + this._curToken.getTokenValue());
        }
        ParseTreeNode retNode = this.match(2);
        ParseTreeNode parNode = this.match(25);
        parNode.addChild(this.unaryExpr());
        while (this._curToken.getTokenType() == 45) {
            this.match(45);
            parNode.addChild(this.unaryExpr());
        }
        retNode.addChild(parNode);
        retNode.addChild(this.match(26));
        return retNode;
    }

    private ParseTreeNode collectionExpr() throws InvalidCharException, OQLSyntaxException {
        if (this._curToken.getTokenType() == 44) {
            ParseTreeNode retNode = this.match(44);
            this.match(25);
            retNode.addChild(this.expr());
            while (this._curToken.getTokenType() == 45) {
                this.match(45);
                retNode.addChild(this.expr());
            }
            this.match(26);
            return retNode;
        }
        throw new OQLSyntaxException("Expected collectionExpr and didn't find it at or near: " + this._curToken.getTokenValue());
    }

    private ParseTreeNode aggregateExpr() throws InvalidCharException, OQLSyntaxException {
        int tokenType = this._curToken.getTokenType();
        ParseTreeNode retNode = null;
        switch (tokenType) {
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                retNode = this.match(tokenType);
                this.match(25);
                retNode.addChild(this.expr());
                this.match(26);
                break;
            }
            case 50: {
                retNode = this.match(50);
                this.match(25);
                if (this._curToken.getTokenType() == 20) {
                    retNode.addChild(this.match(20));
                } else if (this._curToken.getTokenType() == 41) {
                    retNode.addChild(this.match(41));
                    retNode.addChild(this.expr());
                } else {
                    retNode.addChild(this.expr());
                }
                this.match(26);
                break;
            }
            default: {
                throw new OQLSyntaxException("Expected aggregateExpr and didn't find it at or near: " + this._curToken.getTokenValue());
            }
        }
        return retNode;
    }

    private ParseTreeNode undefinedExpr() throws InvalidCharException, OQLSyntaxException {
        int tokenType = this._curToken.getTokenType();
        if (tokenType == 42 || tokenType == 43) {
            ParseTreeNode retNode = this.match(tokenType);
            this.match(25);
            if (this._nextToken.getTokenType() == 30) {
                ParseTreeNode childNode = new ParseTreeNode(new Token(30, "."));
                childNode.addChild(this.match(2));
                while (this._curToken.getTokenType() == 30) {
                    this.match(30);
                    childNode.addChild(this.match(2));
                }
                retNode.addChild(childNode);
            } else {
                retNode.addChild(this.match(2));
            }
            this.match(26);
            return retNode;
        }
        throw new OQLSyntaxException("Expected undefinedExpr and didn't find it at or near: " + this._curToken.getTokenValue());
    }

    private ParseTreeNode queryParam() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = this.match(27);
        int tokenType = this._curToken.getTokenType();
        switch (tokenType) {
            case 25: {
                this.match(25);
                retNode.addChild(this.match(2));
                this.match(26);
                retNode.addChild(this.match(33));
                break;
            }
            case 33: {
                retNode.addChild(this.match(33));
                break;
            }
            default: {
                throw new OQLSyntaxException("An inapropriate token was encountered in a query parameter.");
            }
        }
        return retNode;
    }

    private ParseTreeNode orderClause() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = this.match(46);
        this.match(47);
        ParseTreeNode curExpression = null;
        ParseTreeNode curOrder = null;
        curExpression = this.expr();
        int tokenType = this._curToken.getTokenType();
        if (tokenType == 48 || tokenType == 49) {
            curOrder = this.match(tokenType);
            curOrder.addChild(curExpression);
            retNode.addChild(curOrder);
        } else {
            retNode.addChild(curExpression);
        }
        while (this._curToken.getTokenType() == 45) {
            this.match(45);
            curExpression = this.expr();
            tokenType = this._curToken.getTokenType();
            if (tokenType == 48 || tokenType == 49) {
                curOrder = this.match(tokenType);
                curOrder.addChild(curExpression);
                retNode.addChild(curOrder);
                continue;
            }
            retNode.addChild(curExpression);
        }
        return retNode;
    }

    private ParseTreeNode limitClause() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = this.match(55);
        retNode.addChild(this.queryParam());
        return retNode;
    }

    private ParseTreeNode offsetClause() throws InvalidCharException, OQLSyntaxException {
        ParseTreeNode retNode = this.match(56);
        retNode.addChild(this.queryParam());
        return retNode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tokenTypes.put(new Integer(0), "END_OF_QUERY");
        tokenTypes.put(new Integer(1), "KEYWORD_SELECT");
        tokenTypes.put(new Integer(2), "IDENTIFIER");
        tokenTypes.put(new Integer(3), "KEYWORD_AS");
        tokenTypes.put(new Integer(4), "COLON");
        tokenTypes.put(new Integer(5), "KEYWORD_FROM");
        tokenTypes.put(new Integer(6), "KEYWORD_IN");
        tokenTypes.put(new Integer(7), "KEYWORD_WHERE");
        tokenTypes.put(new Integer(8), "KEYWORD_OR");
        tokenTypes.put(new Integer(9), "KEYWORD_AND");
        tokenTypes.put(new Integer(10), "EQUAL");
        tokenTypes.put(new Integer(11), "NOT_EQUAL");
        tokenTypes.put(new Integer(12), "KEYWORD_LIKE");
        tokenTypes.put(new Integer(13), "LT");
        tokenTypes.put(new Integer(14), "LTE");
        tokenTypes.put(new Integer(15), "GT");
        tokenTypes.put(new Integer(16), "GTE");
        tokenTypes.put(new Integer(17), "PLUS");
        tokenTypes.put(new Integer(18), "MINUS");
        tokenTypes.put(new Integer(19), "CONCAT");
        tokenTypes.put(new Integer(20), "MULTIPLY");
        tokenTypes.put(new Integer(21), "DIVIDE");
        tokenTypes.put(new Integer(22), "KEYWORD_MOD");
        tokenTypes.put(new Integer(23), "KEYWORD_ABS");
        tokenTypes.put(new Integer(24), "KEYWORD_NOT");
        tokenTypes.put(new Integer(25), "LEFT_PAREN");
        tokenTypes.put(new Integer(26), "RIGHT_PAREN");
        tokenTypes.put(new Integer(27), "DOLLAR");
        tokenTypes.put(new Integer(28), "KEYWORD_NIL");
        tokenTypes.put(new Integer(29), "KEYWORD_UNDEFINED");
        tokenTypes.put(new Integer(30), "DOT");
        tokenTypes.put(new Integer(31), "ARROW");
        tokenTypes.put(new Integer(32), "BOOLEAN_LITERAL");
        tokenTypes.put(new Integer(33), "LONG_LITERAL");
        tokenTypes.put(new Integer(34), "DOUBLE_LITERAL");
        tokenTypes.put(new Integer(35), "CHAR_LITERAL");
        tokenTypes.put(new Integer(36), "STRING_LITERAL");
        tokenTypes.put(new Integer(37), "DATE_LITERAL");
        tokenTypes.put(new Integer(38), "TIME_LITERAL");
        tokenTypes.put(new Integer(39), "TIMESTAMP_LITERAL");
        tokenTypes.put(new Integer(40), "KEYWORD_BETWEEN");
        tokenTypes.put(new Integer(41), "KEYWORD_DISTINCT");
        tokenTypes.put(new Integer(42), "KEYWORD_IS_DEFINED");
        tokenTypes.put(new Integer(43), "KEYWORD_IS_UNDEFINED");
        tokenTypes.put(new Integer(44), "KEYWORD_LIST");
        tokenTypes.put(new Integer(45), "COMMA");
        tokenTypes.put(new Integer(46), "KEYWORD_ORDER");
        tokenTypes.put(new Integer(47), "KEYWORD_BY");
        tokenTypes.put(new Integer(48), "KEYWORD_ASC");
        tokenTypes.put(new Integer(49), "KEYWORD_DESC");
        tokenTypes.put(new Integer(50), "KEYWORD_COUNT");
        tokenTypes.put(new Integer(51), "KEYWORD_SUM");
        tokenTypes.put(new Integer(52), "KEYWORD_MIN");
        tokenTypes.put(new Integer(53), "KEYWORD_MAX");
        tokenTypes.put(new Integer(54), "KEYWORD_AVG");
        tokenTypes.put(new Integer(55), "KEYWORD_LIMIT");
        tokenTypes.put(new Integer(56), "KEYWORD_OFFSET");
    }
}

