/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.util;

import java.util.Enumeration;
import java.util.Properties;
import org.exolab.castor.jdo.conf.DataSource;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.DatabaseChoice;
import org.exolab.castor.jdo.conf.Driver;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.jdo.conf.TransactionDemarcation;

public final class JDOConfFactory {
    public static JdoConf createJdoConf(Database database) {
        return JDOConfFactory.createJdoConf(new Database[]{database}, JDOConfFactory.createTransactionDemarcation());
    }

    public static JdoConf createJdoConf(Database[] databases) {
        return JDOConfFactory.createJdoConf(databases, JDOConfFactory.createTransactionDemarcation());
    }

    public static JdoConf createJdoConf(Database database, TransactionDemarcation tx) {
        return JDOConfFactory.createJdoConf(new Database[]{database}, tx);
    }

    public static JdoConf createJdoConf(Database[] databases, TransactionDemarcation tx) {
        JdoConf jdoConf = new JdoConf();
        jdoConf.setDatabase(databases);
        jdoConf.setTransactionDemarcation(tx);
        return jdoConf;
    }

    public static Database createDatabase(String name, String engine, DataSource ds, Mapping mapping) {
        return JDOConfFactory.createDatabase(name, engine, ds, new Mapping[]{mapping});
    }

    public static Database createDatabase(String name, String engine, DataSource ds, Mapping[] mappings) {
        DatabaseChoice dbChoice = new DatabaseChoice();
        dbChoice.setDataSource(ds);
        Database dbConf = JDOConfFactory.createDatabase(name, engine);
        dbConf.setDatabaseChoice(dbChoice);
        dbConf.setMapping(mappings);
        return dbConf;
    }

    public static Database createDatabase(String name, String engine, Driver driver, Mapping mapping) {
        return JDOConfFactory.createDatabase(name, engine, driver, new Mapping[]{mapping});
    }

    public static Database createDatabase(String name, String engine, Driver driver, Mapping[] mappings) {
        DatabaseChoice dbChoise = new DatabaseChoice();
        dbChoise.setDriver(driver);
        Database dbConf = JDOConfFactory.createDatabase(name, engine);
        dbConf.setDatabaseChoice(dbChoise);
        dbConf.setMapping(mappings);
        return dbConf;
    }

    private static Database createDatabase(String name, String engine) {
        Database dbConf = new Database();
        dbConf.setName(name);
        dbConf.setEngine(engine);
        return dbConf;
    }

    public static Driver createDriver(String driver, String connect, String user, String password) {
        Driver driverConf = new Driver();
        driverConf.setClassName(driver);
        driverConf.setUrl(connect);
        driverConf.addParam(JDOConfFactory.createParam("user", user));
        driverConf.addParam(JDOConfFactory.createParam("password", password));
        return driverConf;
    }

    public static DataSource createDataSource(String datasource, Properties props) {
        DataSource dsConf = new DataSource();
        dsConf.setClassName(datasource);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = props.get(key);
            dsConf.addParam(JDOConfFactory.createParam(key.toString(), value.toString()));
        }
        return dsConf;
    }

    private static Param createParam(String name, String value) {
        Param param = new Param();
        param.setName(name);
        param.setValue(value);
        return param;
    }

    public static Mapping createMapping(String mapping) {
        Mapping mapConf = new Mapping();
        mapConf.setHref(mapping);
        return mapConf;
    }

    public static TransactionDemarcation createTransactionDemarcation() {
        TransactionDemarcation trans = new TransactionDemarcation();
        trans.setMode("local");
        return trans;
    }

    private JDOConfFactory() {
    }
}

