/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.Cache;

public abstract class AbstractBaseCache
implements Cache {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$persist$cache$AbstractBaseCache == null ? (class$org$exolab$castor$persist$cache$AbstractBaseCache = AbstractBaseCache.class$("org.exolab.castor.persist.cache.AbstractBaseCache")) : class$org$exolab$castor$persist$cache$AbstractBaseCache));
    private String _cacheType;
    private int _capacity = 0;
    private String _className;
    static /* synthetic */ Class class$org$exolab$castor$persist$cache$AbstractBaseCache;

    public abstract Object put(Object var1, Object var2);

    public abstract Object get(Object var1);

    public abstract Object remove(Object var1);

    public abstract Enumeration elements();

    public void expire(Object key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Expiring cache entry for key " + key));
        }
        if (this.remove(key) == null) {
            LOG.debug((Object)("LRU expire: " + key + " not found"));
        } else {
            LOG.debug((Object)("LRU expire: " + key + " removed from cache"));
        }
        this.dispose(key);
    }

    protected void dispose(Object obj) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Disposing object " + obj));
        }
    }

    public abstract boolean contains(Object var1);

    public String getCacheType() {
        return this._cacheType;
    }

    public void setCacheType(String cacheType) {
        this._cacheType = cacheType;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public void setCapacity(int capacity) {
        this._capacity = capacity;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    protected Object invokeStaticMethodWithExceptions(Class target, String name, Class[] argumentTypes, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = target.getMethod(name, argumentTypes);
        return method.invoke(null, arguments);
    }

    protected Object invokeMethodWithExceptions(Object target, String name, Class[] argumentTypes, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = target.getClass().getMethod(name, argumentTypes);
        return method.invoke(target, arguments);
    }

    protected Object invokeMethod(Object target, String name, Class[] argumentTypes, Object[] arguments) {
        try {
            Method method = target.getClass().getMethod(name, argumentTypes);
            return method.invoke(target, arguments);
        }
        catch (SecurityException e) {
            LOG.error((Object)"SecurityException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"NoSuchMethodException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"IllegalArgumentException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"IllegalAccessException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"InvocationTargetException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    protected boolean invokeMethodReturnBoolean(Object target, String name, Class[] argumentTypes, Object[] arguments) {
        Boolean booleanValue = (Boolean)this.invokeMethod(target, name, argumentTypes, arguments);
        return booleanValue;
    }

    protected int invokeMethodReturnInt(Object target, String name, Class[] argumentTypes, Object[] arguments) {
        Integer integerValue = (Integer)this.invokeMethod(target, name, argumentTypes, arguments);
        return integerValue;
    }

    public abstract void close();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

