/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.AbstractBaseCache;
import org.exolab.castor.persist.cache.Cache;

public class CountLimited
extends AbstractBaseCache
implements Cache {
    private static final int LRU_OLD = 0;
    private static final int LRU_NEW = 1;
    private Hashtable mapKeyPos = null;
    private Object[] keys = null;
    private Object[] values = null;
    private int[] status = null;
    private int cur;
    public static int DEFAULT_SIZE = 30;
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$persist$cache$CountLimited == null ? (class$org$exolab$castor$persist$cache$CountLimited = CountLimited.class$("org.exolab.castor.persist.cache.CountLimited")) : class$org$exolab$castor$persist$cache$CountLimited);
    static /* synthetic */ Class class$org$exolab$castor$persist$cache$CountLimited;

    public CountLimited() {
        this.setCapacity(DEFAULT_SIZE);
    }

    public CountLimited(int capacity) {
        this.setCapacity(capacity);
    }

    public synchronized Object put(Object key, Object value) {
        Object oldPos;
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Putting entry into cache for key " + key + " to " + value));
        }
        if ((oldPos = this.mapKeyPos.get(key)) != null) {
            int pos = (Integer)oldPos;
            Object oldObject = this.values[pos];
            this.values[pos] = value;
            this.status[pos] = 1;
            this.dispose(oldObject);
            return oldObject;
        }
        while (this.walkStatus() != 0) {
        }
        Integer intvalue = this.keys[this.cur] != null ? this.mapKeyPos.remove(this.keys[this.cur]) : new Integer(this.cur);
        Object oldObject = this.values[this.cur];
        this.keys[this.cur] = key;
        this.values[this.cur] = value;
        this.status[this.cur] = 1;
        this.mapKeyPos.put(key, intvalue);
        ++this.cur;
        if (this.cur >= this.getCapacity()) {
            this.cur = 0;
        }
        if (oldObject != null) {
            this.dispose(oldObject);
        }
        return oldObject;
    }

    public synchronized Object get(Object key) {
        Object intvalue = this.mapKeyPos.get(key);
        Object cachedObject = null;
        if (intvalue != null) {
            int pos = (Integer)intvalue;
            this.status[pos] = 1;
            cachedObject = this.values[pos];
        }
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Returning cache entry for key " + key + ": " + cachedObject));
        }
        return cachedObject;
    }

    public synchronized Object remove(Object key) {
        Object intvalue = this.mapKeyPos.remove(key);
        Object removedObject = null;
        if (intvalue != null) {
            int pos = (Integer)intvalue;
            removedObject = this.values[pos];
            this.keys[pos] = null;
            this.values[pos] = null;
            this.status[pos] = 0;
        }
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Removing cache entry for key " + key + ": " + removedObject));
        }
        return removedObject;
    }

    public Enumeration elements() {
        return new ValuesEnumeration(this.values);
    }

    public void expire(Object key) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Expiring cache entry for key " + key));
        }
        if (this.remove(key) == null) {
            // empty if block
        }
        this.dispose(key);
    }

    protected void dispose(Object o) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Disposing object " + o));
        }
    }

    private int walkStatus() {
        int s = this.status[this.cur];
        if (s == 1) {
            this.status[this.cur] = 0;
            ++this.cur;
            if (this.cur >= this.getCapacity()) {
                this.cur = 0;
            }
            return 1;
        }
        return 0;
    }

    public boolean contains(Object key) {
        return this.get(key) != null;
    }

    public void setCapacity(int capacity) {
        if (this.getCapacity() == 0) {
            this.keys = new Object[capacity];
            this.values = new Object[capacity];
            this.status = new int[capacity];
            this.mapKeyPos = new Hashtable(capacity);
            super.setCapacity(capacity);
        } else if (this.getCapacity() <= capacity && this.getCapacity() < capacity) {
            Object[] nkeys = new Object[capacity];
            System.arraycopy(this.keys, 0, nkeys, 0, this.getCapacity());
            this.keys = nkeys;
            Object[] nvalues = new Object[capacity];
            System.arraycopy(this.values, 0, nvalues, 0, this.getCapacity());
            this.values = nvalues;
            int[] nstatus = new int[capacity];
            System.arraycopy(this.status, 0, nstatus, 0, this.getCapacity());
            this.status = nstatus;
            super.setCapacity(capacity);
        }
    }

    public int size() {
        return this.mapKeyPos.size();
    }

    public void clear() {
        this.mapKeyPos.clear();
    }

    public boolean isEmpty() {
        return this.mapKeyPos.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.mapKeyPos.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.mapKeyPos.containsValue(value);
    }

    public Collection values() {
        return this.mapKeyPos.values();
    }

    public void putAll(Map aMap) {
        this.mapKeyPos.putAll(aMap);
    }

    public Set entrySet() {
        return this.mapKeyPos.entrySet();
    }

    public Set keySet() {
        return this.mapKeyPos.keySet();
    }

    public void initialize() {
    }

    public void close() {
        _log.debug((Object)("Closing " + this.getCacheType() + "instance for " + this.getClassName()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ValuesEnumeration
    implements Enumeration {
        private int cur;
        private Object[] values;

        private ValuesEnumeration(Object[] v) {
            Vector<Object> t = new Vector<Object>(v.length);
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == null) continue;
                t.add(v[i]);
            }
            this.values = t.toArray();
        }

        public boolean hasMoreElements() {
            return this.values != null && this.values.length > this.cur;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.values == null || this.values.length <= this.cur) {
                throw new NoSuchElementException();
            }
            return this.values[this.cur++];
        }
    }
}

