/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Text;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.w3c.css.sac.Selector;

@JsxClass
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final int PIXELS_PER_CHAR = 10;
    private static final Set<String> INHERITABLE_ATTRIBUTES = new HashSet<String>(Arrays.asList("azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-size", "font-style", "font-variant", "font-weight", "font", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "orphans", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speech-rate", "stress", "text-align", "text-indent", "text-transform", "visibility", "voice-fFamily", "volume", "white-space", "widows", "word-spacing"));
    private final SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private Integer width_;
    private Integer height_;
    private Integer height2_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;
    private Integer top_;

    public ComputedCSSStyleDeclaration() {
    }

    public ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getElement());
        this.getElement().setDefaults(this);
    }

    @Override
    protected String getStyleAttribute(String name) {
        Element parent;
        String s = super.getStyleAttribute(name);
        if (s.isEmpty() && this.isInheritable(name) && (parent = this.getElement().getParentElement()) != null) {
            s = this.getWindow().getComputedStyle(parent, null).getStyleAttribute(name);
        }
        return s;
    }

    private boolean isInheritable(String name) {
        return INHERITABLE_ATTRIBUTES.contains(name);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    public void applyStyleFromSelector(org.w3c.dom.css.CSSStyleDeclaration declaration, Selector selector) {
        SelectorSpecificity specificity = new SelectorSpecificity(selector);
        for (int k = 0; k < declaration.getLength(); ++k) {
            String name = declaration.item(k);
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        CSSStyleDeclaration.StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (CSSStyleDeclaration.StyleElement)this.localModifications_.get(name)) != null) {
            if ("important".equals(existingElement.getPriority())) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, priority, specificity, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected CSSStyleDeclaration.StyleElement getStyleElement(String name) {
        CSSStyleDeclaration.StyleElement existent = super.getStyleElement(name);
        if (this.localModifications_ != null) {
            CSSStyleDeclaration.StyleElement localStyleMod = (CSSStyleDeclaration.StyleElement)this.localModifications_.get(name);
            if (localStyleMod == null) {
                return existent;
            }
            if (existent == null) {
                return localStyleMod;
            }
            if ("important".equals(localStyleMod.getPriority())) {
                if ("important".equals(existent.getPriority())) {
                    if (existent.getSpecificity().compareTo(localStyleMod.getSpecificity()) < 0) {
                        return localStyleMod;
                    }
                } else {
                    return localStyleMod;
                }
            }
        }
        return existent;
    }

    @Override
    public String getBackgroundAttachment() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBackgroundAttachment(), (CharSequence)"scroll");
    }

    @Override
    public String getBackgroundColor() {
        String value = super.getBackgroundColor();
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = "transparent";
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_BACKGROUND_COLOR_FOR_COMPUTED_STYLE_AS_RGB)) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String getBackgroundImage() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBackgroundImage(), (CharSequence)"none");
    }

    @Override
    public String getBackgroundPosition() {
        String bg = super.getBackgroundPosition();
        if (StringUtils.isNotBlank((CharSequence)bg)) {
            bg = StringUtils.replace((String)bg, (String)"left", (String)"0%");
            bg = StringUtils.replace((String)bg, (String)"right", (String)"100%");
            bg = StringUtils.replace((String)bg, (String)"center", (String)"50%");
            bg = StringUtils.replace((String)bg, (String)"top", (String)"0%");
            bg = StringUtils.replace((String)bg, (String)"bottom", (String)"100%");
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)bg, (CharSequence)"0% 0%");
    }

    @Override
    public String getBackgroundRepeat() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBackgroundRepeat(), (CharSequence)"repeat");
    }

    @Override
    public String getBorderBottomColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderBottomColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String getBorderBottomStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderBottomStyle(), (CharSequence)"none");
    }

    @Override
    public String getBorderBottomWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderBottomWidth(), (CharSequence)"0px"));
    }

    @Override
    public String getBorderCollapse() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderCollapse(), (CharSequence)"separate");
    }

    @Override
    public String getBorderLeftColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderLeftColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String getBorderLeftStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderLeftStyle(), (CharSequence)"none");
    }

    @Override
    public String getBorderLeftWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderLeftWidth(), (CharSequence)"0px"));
    }

    @Override
    public String getBorderRightColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderRightColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String getBorderRightStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderRightStyle(), (CharSequence)"none");
    }

    @Override
    public String getBorderRightWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderRightWidth(), (CharSequence)"0px"));
    }

    @Override
    public String getBorderSpacing() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderSpacing(), (CharSequence)"0px 0px");
    }

    @Override
    public String getBorderTopColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderTopColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String getBorderTopStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderTopStyle(), (CharSequence)"none");
    }

    @Override
    public String getBorderTopWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getBorderTopWidth(), (CharSequence)"0px"));
    }

    @Override
    public String getBottom() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getBottom(), (CharSequence)"auto");
    }

    @Override
    public String getCaptionSide() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getCaptionSide(), (CharSequence)"top");
    }

    @Override
    public String getClear() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getClear(), (CharSequence)"none");
    }

    @Override
    public String getClip() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getClip(), (CharSequence)"auto");
    }

    @Override
    public String getContent() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getContent(), (CharSequence)"none");
    }

    @Override
    public String getColor() {
        String value = (String)StringUtils.defaultIfEmpty((CharSequence)super.getColor(), (CharSequence)"rgb(0, 0, 0)");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_BACKGROUND_COLOR_FOR_COMPUTED_STYLE_AS_RGB)) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String getCounterIncrement() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getCounterIncrement(), (CharSequence)"none");
    }

    @Override
    public String getCounterReset() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getCounterReset(), (CharSequence)"none");
    }

    @Override
    public String getCssFloat() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getCssFloat(), (CharSequence)"none");
    }

    @Override
    public String getCursor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getCursor(), (CharSequence)"auto");
    }

    @Override
    public String getDirection() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getDirection(), (CharSequence)"ltr");
    }

    @Override
    public String getDisplay() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getDisplay(), (CharSequence)this.getElement().getDefaultStyleDisplay());
    }

    @Override
    public String getEmptyCells() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getEmptyCells(), (CharSequence)"-moz-show-background");
    }

    @Override
    public String getFontFamily() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getFontFamily(), (CharSequence)"serif");
    }

    @Override
    public String getFontSize() {
        Element parent;
        String value = super.getFontSize();
        if (value.isEmpty() && (parent = this.getElement().getParentElement()) != null) {
            value = parent.getCurrentStyle().getFontSize();
        }
        if (value.isEmpty()) {
            value = "16px";
        }
        return value;
    }

    @Override
    public String getFontSizeAdjust() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getFontSizeAdjust(), (CharSequence)"none");
    }

    @Override
    public String getFontStretch() {
        String defaultStretch = "";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_FONT_STRECH_DEFAULT_NORMAL)) {
            defaultStretch = "normal";
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getFontStretch(), (CharSequence)defaultStretch);
    }

    @Override
    public String getFontStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getFontStyle(), (CharSequence)"normal");
    }

    @Override
    public String getFontVariant() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getFontVariant(), (CharSequence)"normal");
    }

    @Override
    public String getFontWeight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getFontWeight(), (CharSequence)"400");
    }

    @Override
    public String getHeight() {
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(this.getElement().getWindow().getWebWindow().getInnerHeight()){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                return (String)StringUtils.defaultIfEmpty((CharSequence)style.getStyleAttribute("height"), (CharSequence)"362px");
            }
        });
    }

    @Override
    public String getImeMode() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getImeMode(), (CharSequence)"auto");
    }

    @Override
    public String getLeft() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getLeft(), (CharSequence)"auto");
    }

    @Override
    public String getLetterSpacing() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getLetterSpacing(), (CharSequence)"normal");
    }

    @Override
    public String getListStyleImage() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getListStyleImage(), (CharSequence)"none");
    }

    @Override
    public String getListStylePosition() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getListStylePosition(), (CharSequence)"outside");
    }

    @Override
    public String getListStyleType() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getListStyleType(), (CharSequence)"disc");
    }

    @Override
    public String getMarginBottom() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getMarginBottom(), (CharSequence)"0px"));
    }

    @Override
    public String getMarginLeft() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getMarginLeft(), (CharSequence)"0px"));
    }

    @Override
    public String getMarginRight() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getMarginRight(), (CharSequence)"0px"));
    }

    @Override
    public String getMarginTop() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getMarginTop(), (CharSequence)"0px"));
    }

    @Override
    public String getMarkerOffset() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getMarkerOffset(), (CharSequence)"auto");
    }

    @Override
    public String getMaxHeight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getMaxHeight(), (CharSequence)"none");
    }

    @Override
    public String getMaxWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getMaxWidth(), (CharSequence)"none");
    }

    @Override
    public String getMinHeight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getMinHeight(), (CharSequence)"0px");
    }

    @Override
    public String getMinWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getMinWidth(), (CharSequence)"0px");
    }

    @Override
    protected String getStyleAttributeValue(StyleAttributes.Definition style) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getStyleAttributeValue(style), (CharSequence)style.getDefaultComputedValue(this.getBrowserVersion()));
    }

    @Override
    public String getOpacity() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOpacity(), (CharSequence)"1");
    }

    @Override
    public String getOutlineColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOutlineColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String getOutlineOffset() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOutlineOffset(), (CharSequence)"0px");
    }

    @Override
    public String getOutlineStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOutlineStyle(), (CharSequence)"none");
    }

    @Override
    public String getOutlineWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOutlineWidth(), (CharSequence)"0px");
    }

    @Override
    public String getOverflow() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOverflow(), (CharSequence)"visible");
    }

    @Override
    public String getOverflowX() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOverflowX(), (CharSequence)"visible");
    }

    @Override
    public String getOverflowY() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getOverflowY(), (CharSequence)"visible");
    }

    @Override
    public String getPageBreakAfter() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getPageBreakAfter(), (CharSequence)"auto");
    }

    @Override
    public String getPageBreakBefore() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getPageBreakBefore(), (CharSequence)"auto");
    }

    @Override
    public String getPaddingBottom() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getPaddingBottom(), (CharSequence)"0px"));
    }

    @Override
    public String getPaddingLeft() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getPaddingLeft(), (CharSequence)"0px"));
    }

    @Override
    public String getPaddingRight() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getPaddingRight(), (CharSequence)"0px"));
    }

    @Override
    public String getPaddingTop() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.getPaddingTop(), (CharSequence)"0px"));
    }

    @Override
    public String getPointerEvents() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getPointerEvents(), (CharSequence)"auto");
    }

    @Override
    public String getPosition() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getPosition(), (CharSequence)"static");
    }

    @Override
    public String getRight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getRight(), (CharSequence)"auto");
    }

    @Override
    public String getTableLayout() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getTableLayout(), (CharSequence)"auto");
    }

    @Override
    public String getTextAlign() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getTextAlign(), (CharSequence)"start");
    }

    @Override
    public String getTextDecoration() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getTextDecoration(), (CharSequence)"none");
    }

    @Override
    public String getTextIndent() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getTextIndent(), (CharSequence)"0px");
    }

    @Override
    public String getTextShadow() {
        String shadow = "";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_TEXT_SHADOW_DEFAULT_NONE)) {
            shadow = "none";
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getTextShadow(), (CharSequence)shadow);
    }

    @Override
    public String getTextTransform() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getTextTransform(), (CharSequence)"none");
    }

    @Override
    public String getTop() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getTop(), (CharSequence)"auto");
    }

    @Override
    public String getVerticalAlign() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getVerticalAlign(), (CharSequence)"baseline");
    }

    @Override
    public String getVisibility() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getVisibility(), (CharSequence)"visible");
    }

    @Override
    public String getWhiteSpace() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getWhiteSpace(), (CharSequence)"normal");
    }

    @Override
    public String getWidth() {
        if ("none".equals(this.getDisplay())) {
            return "auto";
        }
        int windowWidth = this.getElement().getWindow().getWebWindow().getInnerWidth();
        final String defaultWidth = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) ? "auto" : windowWidth + "px";
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(windowWidth){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                String value = style.getStyleAttribute("width");
                if (StringUtils.isEmpty((CharSequence)value)) {
                    Object domNode;
                    String content;
                    if (!ComputedCSSStyleDeclaration.this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) && "absolute".equals(ComputedCSSStyleDeclaration.this.getStyleAttribute("position")) && null != (content = ((DomNode)(domNode = ComputedCSSStyleDeclaration.this.getDomNodeOrDie())).getTextContent()) && content.length() < 13) {
                        return content.length() * 7 + "px";
                    }
                    return defaultWidth;
                }
                return value;
            }
        });
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width = this.getCalculatedWidth();
        if (includeBorder) {
            width += this.getBorderHorizontal();
        }
        if (includePadding) {
            width += this.getPaddingHorizontal();
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        if (this.width_ != null) {
            return this.width_;
        }
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.width_ = 0;
            return 0;
        }
        String display = this.getDisplay();
        if ("none".equals(display)) {
            this.width_ = 0;
            return 0;
        }
        int windowWidth = this.getElement().getWindow().getWebWindow().getInnerWidth();
        String styleWidth = super.getWidth();
        DomNode parent = node.getParentNode();
        if (StringUtils.isEmpty((CharSequence)styleWidth) && parent instanceof HtmlElement) {
            if (this.getElement() instanceof HTMLCanvasElement) {
                return 300;
            }
            String cssFloat = this.getCssFloat();
            if ("right".equals(cssFloat) || "left".equals(cssFloat)) {
                width = node.getTextContent().length() * 10;
            } else if ("block".equals(display)) {
                HTMLElement parentJS = (HTMLElement)parent.getScriptObject();
                String parentWidth = this.getWindow().getComputedStyle(parentJS, null).getWidth();
                width = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) && "auto".equals(parentWidth) ? windowWidth : ComputedCSSStyleDeclaration.pixelValue(parentJS, new CSSStyleDeclaration.CssValue(windowWidth){

                    @Override
                    public String get(ComputedCSSStyleDeclaration style) {
                        return style.getWidth();
                    }
                });
                width -= this.getBorderHorizontal() + this.getPaddingHorizontal();
            } else if (node instanceof HtmlSubmitInput || node instanceof HtmlResetInput || node instanceof HtmlButtonInput || node instanceof HtmlButton) {
                String text = node.asText();
                width = 10 + text.length() * 10;
            } else {
                width = node instanceof HtmlTextInput || node instanceof HtmlPasswordInput ? 50 : (node instanceof HtmlRadioButtonInput || node instanceof HtmlCheckBoxInput ? 20 : (node instanceof HtmlTextInput || node instanceof HtmlPasswordInput ? 50 : (node instanceof HtmlTextArea ? 100 : this.getContentWidth())));
            }
        } else {
            width = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(windowWidth){

                @Override
                public String get(ComputedCSSStyleDeclaration style) {
                    return style.getStyleAttribute("width");
                }
            });
        }
        this.width_ = width;
        return width;
    }

    public int getContentWidth() {
        Page enclosedPage;
        int width = 0;
        Object domNode = this.getDomNodeOrDie();
        Iterable<DomNode> childs = ((DomNode)domNode).getChildren();
        if (domNode instanceof BaseFrameElement && (enclosedPage = ((BaseFrameElement)domNode).getEnclosedPage()) != null && enclosedPage.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            childs = htmlPage.getChildren();
        }
        for (DomNode child : childs) {
            if (child.getScriptObject() instanceof HTMLElement) {
                HTMLElement e = (HTMLElement)child.getScriptObject();
                int w = e.getCurrentStyle().getCalculatedWidth(true, true);
                width += w;
                continue;
            }
            if (!(child.getScriptObject() instanceof Text)) continue;
            width += child.getTextContent().length() * 10;
        }
        return width;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = this.getCalculatedHeight();
        if (includeBorder) {
            height += this.getBorderVertical();
        }
        if (includePadding) {
            height += this.getPaddingVertical();
        }
        return height;
    }

    private int getCalculatedHeight() {
        if (this.height_ != null) {
            return this.height_;
        }
        int elementHeight = this.getEmptyHeight();
        if (elementHeight == 0) {
            this.height_ = elementHeight;
            return elementHeight;
        }
        int contentHeight = this.getContentHeight();
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELEMENT_HEIGHT_MARKS_MIN);
        boolean explicitHeightSpecified = super.getHeight().length() > 0;
        int height = contentHeight > 0 && (useDefaultHeight && contentHeight > elementHeight || !useDefaultHeight && !explicitHeightSpecified) ? contentHeight : elementHeight;
        this.height_ = height;
        return height;
    }

    private int getEmptyHeight() {
        boolean explicitHeightSpecified;
        if (this.height2_ != null) {
            return this.height2_;
        }
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.height2_ = 0;
            return 0;
        }
        if ("none".equals(this.getDisplay())) {
            this.height2_ = 0;
            return 0;
        }
        int windowHeight = this.getElement().getWindow().getWebWindow().getInnerHeight();
        if (this.getElement() instanceof HTMLBodyElement) {
            this.height2_ = windowHeight;
            return windowHeight;
        }
        boolean bl = explicitHeightSpecified = super.getHeight().length() > 0;
        int defaultHeight = this.getElement().getFirstChild() == null ? (node instanceof HtmlButton || node instanceof HtmlInput && !(node instanceof HtmlHiddenInput) ? 20 : (node instanceof HtmlSelect ? 20 : (node instanceof HtmlTextArea ? 49 : (node instanceof HtmlInlineFrame ? 154 : 0)))) : (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELEMENT_HEIGHT_15) ? 15 : 20);
        int defaultValue = this.getElement() instanceof HTMLCanvasElement ? 150 : windowHeight;
        int height = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(defaultValue){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                return style.getStyleAttribute("height");
            }
        });
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELEMENT_HEIGHT_MARKS_MIN);
        if (height == 0 && !explicitHeightSpecified || useDefaultHeight && height < defaultHeight) {
            height = defaultHeight;
        }
        this.height2_ = height;
        return height;
    }

    public int getContentHeight() {
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            return 0;
        }
        ComputedCSSStyleDeclaration lastFlowing = null;
        HashSet<ComputedCSSStyleDeclaration> styles = new HashSet<ComputedCSSStyleDeclaration>();
        for (DomNode child : node.getChildren()) {
            ScriptableObject scriptObj;
            if (!child.mayBeDisplayed() || !((scriptObj = child.getScriptObject()) instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)scriptObj;
            ComputedCSSStyleDeclaration style = e.getCurrentStyle();
            String pos = style.getPositionWithInheritance();
            if ("static".equals(pos) || "relative".equals(pos)) {
                lastFlowing = style;
                continue;
            }
            if (!"absolute".equals(pos)) continue;
            styles.add(style);
        }
        if (lastFlowing != null) {
            styles.add(lastFlowing);
        }
        int max = 0;
        for (ComputedCSSStyleDeclaration style : styles) {
            int h = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
            if (h <= max) continue;
            max = h;
        }
        return max;
    }

    public boolean isScrollable(boolean horizontal) {
        Element node = this.getElement();
        String overflow = this.getOverflow();
        boolean scrollable = horizontal ? (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentWidth() > this.getCalculatedWidth() : (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentHeight() > this.getEmptyHeight();
        return scrollable;
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top = 0;
        if (null == this.top_) {
            String p = this.getPositionWithInheritance();
            if ("absolute".equals(p)) {
                String t = this.getTopWithInheritance();
                if (!"auto".equals(t)) {
                    top = ComputedCSSStyleDeclaration.pixelValue(t);
                } else {
                    String b = this.getBottomWithInheritance();
                    if (!"auto".equals(b)) {
                        top = 0;
                        for (DomNode child = this.getElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (!(child instanceof HtmlElement) || !child.mayBeDisplayed()) continue;
                            top += 20;
                        }
                        top -= ComputedCSSStyleDeclaration.pixelValue(b);
                    }
                }
            } else {
                DomNode prev;
                for (prev = this.getElement().getDomNodeOrDie().getPreviousSibling(); prev != null && !(prev instanceof HtmlElement); prev = prev.getPreviousSibling()) {
                }
                if (prev != null) {
                    HTMLElement e = (HTMLElement)((HtmlElement)prev).getScriptObject();
                    ComputedCSSStyleDeclaration style = e.getCurrentStyle();
                    top = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
                }
                if ("relative".equals(p)) {
                    String t = this.getTopWithInheritance();
                    top += ComputedCSSStyleDeclaration.pixelValue(t);
                }
            }
            this.top_ = top;
        } else {
            top = this.top_;
        }
        if (includeMargin) {
            int margin = ComputedCSSStyleDeclaration.pixelValue(this.getMarginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.getBorderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTopValue();
            top += padding;
        }
        return top;
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        HTMLElement parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if ("fixed".equals(p) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TREATS_POSITION_FIXED_LIKE_POSITION_STATIC)) {
            p = "static";
        }
        if ("absolute".equals(p) && !"auto".equals(l)) {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        } else if ("absolute".equals(p) && !"auto".equals(r)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            int parentWidth = parent.getCurrentStyle().getCalculatedWidth(false, false);
            left = parentWidth - ComputedCSSStyleDeclaration.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            left = ComputedCSSStyleDeclaration.pixelValue(parent.getCurrentStyle().getLeftWithInheritance());
        } else if ("static".equals(p)) {
            left = 0;
            for (Object n = this.getDomNodeOrDie(); n != null; n = ((DomNode)n).getPreviousSibling()) {
                if (((DomNode)n).getScriptObject() instanceof HTMLElement) {
                    HTMLElement e = (HTMLElement)((DomNode)n).getScriptObject();
                    ComputedCSSStyleDeclaration style = e.getCurrentStyle();
                    String d = style.getDisplay();
                    if ("block".equals(d)) break;
                    if (!"none".equals(d)) {
                        left += style.getCalculatedWidth(true, true);
                    }
                } else if (((DomNode)n).getScriptObject() instanceof Text) {
                    left += ((DomNode)n).getTextContent().length() * 10;
                }
                if (!(n instanceof HtmlTableRow)) {
                    continue;
                }
                break;
            }
        } else {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeftValue();
            left += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.getBorderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeftValue();
            left += padding;
        }
        return left;
    }

    public String getPositionWithInheritance() {
        String p = this.getPosition();
        if ("inherit".equals(p)) {
            HTMLElement parent;
            p = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = (HTMLElement)this.getElement().getParentElement()) != null ? parent.getCurrentStyle().getPositionWithInheritance() : "static") : "static";
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.getLeft();
        if ("inherit".equals(left)) {
            HTMLElement parent;
            left = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = (HTMLElement)this.getElement().getParentElement()) != null ? parent.getCurrentStyle().getLeftWithInheritance() : "auto") : "auto";
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.getRight();
        if ("inherit".equals(right)) {
            HTMLElement parent;
            right = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = (HTMLElement)this.getElement().getParentElement()) != null ? parent.getCurrentStyle().getRightWithInheritance() : "auto") : "auto";
        }
        return right;
    }

    public String getTopWithInheritance() {
        String top = this.getTop();
        if ("inherit".equals(top)) {
            HTMLElement parent;
            top = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = (HTMLElement)this.getElement().getParentElement()) != null ? parent.getCurrentStyle().getTopWithInheritance() : "auto") : "auto";
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.getBottom();
        if ("inherit".equals(bottom)) {
            HTMLElement parent;
            bottom = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = (HTMLElement)this.getElement().getParentElement()) != null ? parent.getCurrentStyle().getBottomWithInheritance() : "auto") : "auto";
        }
        return bottom;
    }

    public int getMarginLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginLeft());
    }

    public int getMarginRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginRight());
    }

    public int getMarginTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginTop());
    }

    public int getMarginBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginBottom());
    }

    public int getPaddingLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingLeft());
    }

    public int getPaddingRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingRight());
    }

    public int getPaddingTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingTop());
    }

    public int getPaddingBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingBottom());
    }

    private int getPaddingHorizontal() {
        if (this.paddingHorizontal_ == null) {
            this.paddingHorizontal_ = "none".equals(this.getDisplay()) ? 0 : this.getPaddingLeftValue() + this.getPaddingRightValue();
        }
        return this.paddingHorizontal_;
    }

    private int getPaddingVertical() {
        if (this.paddingVertical_ == null) {
            this.paddingVertical_ = "none".equals(this.getDisplay()) ? 0 : this.getPaddingTopValue() + this.getPaddingBottomValue();
        }
        return this.paddingVertical_;
    }

    public int getBorderLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderLeftWidth());
    }

    public int getBorderRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderRightWidth());
    }

    public int getBorderTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderTopWidth());
    }

    public int getBorderBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderBottomWidth());
    }

    private int getBorderHorizontal() {
        if (this.borderHorizontal_ == null) {
            this.borderHorizontal_ = "none".equals(this.getDisplay()) ? 0 : this.getBorderLeftValue() + this.getBorderRightValue();
        }
        return this.borderHorizontal_;
    }

    private int getBorderVertical() {
        if (this.borderVertical_ == null) {
            this.borderVertical_ = "none".equals(this.getDisplay()) ? 0 : this.getBorderTopValue() + this.getBorderBottomValue();
        }
        return this.borderVertical_;
    }

    @Override
    public String getWordSpacing() {
        String wordSpacing = "0px";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_WORD_SPACING_DEFAULT_NORMAL)) {
            wordSpacing = "normal";
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getWordSpacing(), (CharSequence)wordSpacing);
    }

    @Override
    public String getWordWrap() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.getWordWrap(), (CharSequence)"normal");
    }

    @Override
    public Object getZIndex() {
        Object response = super.getZIndex();
        if (response.toString().isEmpty()) {
            return "auto";
        }
        return response;
    }

    @Override
    public String getPropertyValue(String name) {
        Object property = ComputedCSSStyleDeclaration.getProperty((Scriptable)this, ComputedCSSStyleDeclaration.camelize(name));
        if (property == NOT_FOUND) {
            return super.getPropertyValue(name);
        }
        return Context.toString(property);
    }

    protected String pixelString(String value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return value;
        }
        if (value.endsWith("px")) {
            return value;
        }
        return ComputedCSSStyleDeclaration.pixelValue(value) + "px";
    }

    protected String pixelString(Element element, CSSStyleDeclaration.CssValue value) {
        String s = value.get(element);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return s;
        }
        if (s.endsWith("px")) {
            return s;
        }
        return ComputedCSSStyleDeclaration.pixelValue(element, value) + "px";
    }
}

