/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.host.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLStyleElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class StyleSheetList
extends SimpleScriptable {
    private HTMLCollection nodes_;

    public static boolean isStyleSheetLink(DomNode domNode) {
        return domNode instanceof HtmlLink && "stylesheet".equalsIgnoreCase(((HtmlLink)domNode).getRelAttribute());
    }

    public StyleSheetList() {
    }

    public StyleSheetList(HTMLDocument document) {
        this.setParentScope(document);
        this.setPrototype(this.getPrototype(this.getClass()));
        boolean cssEnabled = this.getWindow().getWebWindow().getWebClient().getOptions().isCssEnabled();
        this.nodes_ = cssEnabled ? new HTMLCollection((DomNode)document.getDomNodeOrDie(), true, "stylesheets"){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlStyle || StyleSheetList.isStyleSheetLink(node);
            }

            @Override
            protected NodeList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                HtmlElement node = event.getHtmlElement();
                if (node instanceof HtmlLink && "rel".equalsIgnoreCase(event.getName())) {
                    return NodeList.EffectOnCache.RESET;
                }
                return NodeList.EffectOnCache.NONE;
            }
        } : HTMLCollection.emptyCollection(this.getWindow());
    }

    @JsxGetter
    public int getLength() {
        return this.nodes_.getLength();
    }

    @JsxFunction
    public Object item(int index) {
        if (index < 0) {
            throw Context.reportRuntimeError("Invalid negative index: " + index);
        }
        if (index >= this.nodes_.getLength()) {
            if (this.getWindow().getWebWindow().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLESHEET_LIST_EXEPTION_FOR_ALL_INVALID_INDEXES)) {
                throw Context.reportRuntimeError("Invalid index: " + index);
            }
            return Context.getUndefinedValue();
        }
        HTMLElement element = (HTMLElement)this.nodes_.item((Object)index);
        CSSStyleSheet sheet = element instanceof HTMLStyleElement ? ((HTMLStyleElement)element).getSheet() : ((HTMLLinkElement)element).getSheet();
        return sheet;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.item(index);
        }
        return super.get(index, start);
    }
}

