/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import javax.annotation.Nullable;

public class CssBooleanExpressionNode
extends CssValueNode {
    private final Type type;
    private final CssBooleanExpressionNode left;
    private final CssBooleanExpressionNode right;

    public CssBooleanExpressionNode(Type type, String value, @Nullable CssBooleanExpressionNode left, @Nullable CssBooleanExpressionNode right, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(value, sourceCodeLocation);
        this.type = type;
        this.left = left;
        this.right = right;
        this.becomeParentForNode(this.left);
        this.becomeParentForNode(this.right);
        Preconditions.checkArgument((boolean)this.isValidExpressionTree());
    }

    public CssBooleanExpressionNode(Type type, String value, @Nullable CssBooleanExpressionNode left, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(type, value, left, null, sourceCodeLocation);
    }

    public CssBooleanExpressionNode(Type type, String value, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(type, value, null, null, sourceCodeLocation);
    }

    public CssBooleanExpressionNode(Type type, String value) {
        this(type, value, null, null, null);
    }

    public CssBooleanExpressionNode(CssBooleanExpressionNode node) {
        super(node);
        this.type = node.getType();
        if (node.getLeft() != null) {
            this.left = new CssBooleanExpressionNode(node.getLeft());
            this.becomeParentForNode(this.left);
        } else {
            this.left = null;
        }
        if (node.getRight() != null) {
            this.right = new CssBooleanExpressionNode(node.getRight());
            this.becomeParentForNode(this.right);
        } else {
            this.right = null;
        }
    }

    @Override
    public CssBooleanExpressionNode deepCopy() {
        return new CssBooleanExpressionNode(this);
    }

    public Type getType() {
        return this.type;
    }

    public CssBooleanExpressionNode getLeft() {
        return this.left;
    }

    public CssBooleanExpressionNode getRight() {
        return this.right;
    }

    public boolean isValidExpressionTree() {
        if (this.getType().isConstant()) {
            return true;
        }
        if (!this.getType().isOperator()) {
            return this.getLeft() == null && this.getRight() == null;
        }
        if (this.getType().isBinaryOperator()) {
            return this.getLeft() != null && this.getRight() != null;
        }
        if (this.getType().isUnaryOperator()) {
            return this.getLeft() != null && this.getRight() == null;
        }
        return false;
    }

    private void appendChildExpression(StringBuilder sb, CssBooleanExpressionNode child) {
        if (child.getType().getPriority() >= this.getType().getPriority()) {
            sb.append(child.toString());
        } else {
            sb.append("(" + child.toString() + ")");
        }
    }

    @Override
    public String toString() {
        if (!this.getType().isOperator()) {
            return this.getValue();
        }
        if (this.getType().isBinaryOperator()) {
            StringBuilder sb = new StringBuilder();
            this.appendChildExpression(sb, this.getLeft());
            sb.append(" " + this.getType().getOperatorString() + " ");
            this.appendChildExpression(sb, this.getRight());
            return sb.toString();
        }
        if (this.getType().isUnaryOperator()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getType().getOperatorString());
            this.appendChildExpression(sb, this.getLeft());
            return sb.toString();
        }
        return null;
    }

    public static enum Type {
        CONSTANT(null),
        NOT("!"),
        AND("&&"),
        OR("||");

        public static final String TRUE_CONSTANT = "TRUE";
        public static final String FALSE_CONSTANT = "FALSE";
        private final String operatorString;

        private Type(String operatorString) {
            this.operatorString = operatorString;
        }

        public String getOperatorString() {
            return this.operatorString;
        }

        public boolean isConstant() {
            return this == CONSTANT;
        }

        public boolean isOperator() {
            return !this.isConstant();
        }

        public boolean isBinaryOperator() {
            Preconditions.checkArgument((boolean)this.isOperator());
            return this != NOT;
        }

        public boolean isUnaryOperator() {
            Preconditions.checkArgument((boolean)this.isOperator());
            return this == NOT;
        }

        public int getPriority() {
            return -this.ordinal();
        }

        public String toString() {
            return this.getOperatorString();
        }
    }
}

