/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCommentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCustomFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssHexColorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssImportRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMediaRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssParserEventHandler;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPriorityNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.ParserToken;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class CssTreeBuilder
implements CssParserEventHandler,
CssParserEventHandler.ImportHandler,
CssParserEventHandler.MediaHandler,
CssParserEventHandler.ExpressionHandler,
CssParserEventHandler.BooleanExpressionHandler {
    private CssTree tree = null;
    private boolean treeIsConstructed = false;
    private List<CssBlockNode> openBlocks = null;
    private List<CssConditionalBlockNode> openConditionalBlocks = null;
    private CssDeclarationBlockNode declarationBlock = null;
    private CssDeclarationNode declaration = null;
    private CssDefinitionNode definition = null;
    private List<CssCommentNode> comments = null;
    private CssRulesetNode ruleset = null;
    private CssImportRuleNode importRule = null;
    private CssMediaRuleNode mediaRule = null;
    private StateStack stateStack = new StateStack(State.BEFORE_DOCUMENT_START);

    private void startMainBody() {
        if (this.stateStack.isIn(State.BEFORE_MAIN_BODY)) {
            this.stateStack.transitionTo(State.INSIDE_MAIN_BODY);
        }
    }

    private CssBlockNode getEnclosingBlock() {
        return this.openBlocks.get(this.openBlocks.size() - 1);
    }

    private void pushEnclosingBlock(CssBlockNode block) {
        this.openBlocks.add(block);
    }

    private void popEnclosingBlock() {
        this.openBlocks.remove(this.openBlocks.size() - 1);
    }

    private void endConditionalRuleChain() {
        if (!this.stateStack.isIn(State.INSIDE_CONDITIONAL_BLOCK)) {
            return;
        }
        Preconditions.checkState((!this.openConditionalBlocks.isEmpty() ? 1 : 0) != 0);
        CssConditionalBlockNode conditionalBlock = this.openConditionalBlocks.remove(this.openConditionalBlocks.size() - 1);
        this.stateStack.pop();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_BLOCK, State.INSIDE_MAIN_BODY, State.INSIDE_MEDIA_RULE, State.INSIDE_CONDITIONAL_BLOCK));
        this.getEnclosingBlock().addChildToBack(conditionalBlock);
    }

    private CssConditionalBlockNode getEnclosingConditonalBlock() {
        return this.openConditionalBlocks.get(this.openConditionalBlocks.size() - 1);
    }

    private void appendToCurrentExpression(CssValueNode node) {
        if (this.stateStack.isIn(State.INSIDE_DEFINITION)) {
            Preconditions.checkState((this.definition != null ? 1 : 0) != 0);
            this.definition.addChildToBack(node);
        } else if (this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION)) {
            Preconditions.checkState((this.declaration != null ? 1 : 0) != 0);
            this.declaration.getPropertyValue().addChildToBack(node);
        } else if (this.stateStack.isIn(State.INSIDE_EXPRESSION_AFTER_OPERATOR)) {
            this.stateStack.pop();
            if (this.stateStack.isIn(State.INSIDE_DEFINITION)) {
                Preconditions.checkState((this.definition != null ? 1 : 0) != 0);
                CssCompositeValueNode compositeNode = (CssCompositeValueNode)this.definition.getLastChild();
                compositeNode.addValue(node);
            } else if (this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION)) {
                Preconditions.checkState((this.declaration != null ? 1 : 0) != 0);
                CssCompositeValueNode compositeNode = (CssCompositeValueNode)this.declaration.getPropertyValue().getLastChild();
                compositeNode.addValue(node);
            }
        }
    }

    private CssFunctionNode getFunctionFromCurrentExpression() {
        if (this.stateStack.isIn(State.INSIDE_DEFINITION)) {
            Preconditions.checkState((this.definition != null ? 1 : 0) != 0);
            return (CssFunctionNode)this.definition.getLastChild();
        }
        if (this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION)) {
            Preconditions.checkState((this.declaration != null ? 1 : 0) != 0);
            int size = this.declaration.getPropertyValue().numChildren();
            return (CssFunctionNode)this.declaration.getPropertyValue().getChildAt(size - 1);
        }
        return null;
    }

    @Override
    public void onDocumentStart(SourceCode sourceCode) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.BEFORE_DOCUMENT_START));
        Preconditions.checkNotNull((Object)sourceCode);
        Preconditions.checkState((this.tree == null ? 1 : 0) != 0);
        this.tree = new CssTree(sourceCode);
        Preconditions.checkState((this.openBlocks == null ? 1 : 0) != 0);
        this.openBlocks = Lists.newArrayList();
        this.openBlocks.add(this.tree.getRoot().getBody());
        Preconditions.checkState((this.openConditionalBlocks == null ? 1 : 0) != 0);
        this.openConditionalBlocks = Lists.newArrayList();
        Preconditions.checkState((this.comments == null ? 1 : 0) != 0);
        this.comments = Lists.newArrayList();
        this.stateStack.transitionTo(State.BEFORE_MAIN_BODY);
    }

    @Override
    public void onDocumentEnd() {
        this.startMainBody();
        this.endConditionalRuleChain();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MAIN_BODY));
        Preconditions.checkState((this.openBlocks.size() == 1 ? 1 : 0) != 0);
        Preconditions.checkState((this.openBlocks.get(0) == this.tree.getRoot().getBody() ? 1 : 0) != 0);
        this.openBlocks = null;
        Preconditions.checkState((this.openConditionalBlocks.size() == 0 ? 1 : 0) != 0);
        this.openConditionalBlocks = null;
        this.treeIsConstructed = true;
        this.stateStack.transitionTo(State.DONE_BUILDING);
        Preconditions.checkState((this.stateStack.size() == 1 ? 1 : 0) != 0);
    }

    @VisibleForTesting
    public CssTree getTree() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.DONE_BUILDING));
        Preconditions.checkState((boolean)this.treeIsConstructed);
        return this.tree;
    }

    @Override
    public CssParserEventHandler.ImportHandler onImportRuleStart() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.BEFORE_MAIN_BODY));
        Preconditions.checkState((this.importRule == null ? 1 : 0) != 0);
        this.stateStack.push(State.INSIDE_IMPORT_RULE);
        this.importRule = new CssImportRuleNode(this.comments);
        this.comments.clear();
        return this;
    }

    @Override
    public void appendImportParameter(ParserToken parameter) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_IMPORT_RULE));
        CssLiteralNode importParameter = new CssLiteralNode(parameter.getToken(), parameter.getSourceCodeLocation());
        this.importRule.addChildToBack(importParameter);
    }

    @Override
    public void onImportRuleEnd() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_IMPORT_RULE));
        this.stateStack.pop();
        this.tree.getRoot().getImportRules().addChildToBack(this.importRule);
        Preconditions.checkState((this.importRule != null ? 1 : 0) != 0);
        this.importRule = null;
    }

    @Override
    public CssParserEventHandler.MediaHandler onMediaRuleStart() {
        this.startMainBody();
        this.endConditionalRuleChain();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MAIN_BODY));
        Preconditions.checkState((this.mediaRule == null ? 1 : 0) != 0);
        this.stateStack.push(State.INSIDE_MEDIA_RULE);
        this.mediaRule = new CssMediaRuleNode(this.comments);
        this.comments.clear();
        this.pushEnclosingBlock(this.mediaRule.getBlock());
        return this;
    }

    @Override
    public void appendMediaParameter(ParserToken parameter) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MEDIA_RULE));
        CssLiteralNode mediaParameter = new CssLiteralNode(parameter.getToken(), parameter.getSourceCodeLocation());
        this.mediaRule.addChildToBack(mediaParameter);
    }

    @Override
    public void onMediaRuleEnd() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MEDIA_RULE));
        this.stateStack.pop();
        this.mediaRule.setBlock(this.getEnclosingBlock());
        this.popEnclosingBlock();
        this.getEnclosingBlock().addChildToBack(this.mediaRule);
        Preconditions.checkState((this.mediaRule != null ? 1 : 0) != 0);
        this.mediaRule = null;
    }

    @Override
    public CssParserEventHandler.ExpressionHandler onDefinitionStart(ParserToken definitionName) {
        this.startMainBody();
        this.endConditionalRuleChain();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MAIN_BODY, State.INSIDE_MEDIA_RULE, State.INSIDE_BLOCK));
        Preconditions.checkState((this.definition == null ? 1 : 0) != 0);
        this.stateStack.push(State.INSIDE_DEFINITION);
        CssLiteralNode name = new CssLiteralNode(definitionName.getToken(), definitionName.getSourceCodeLocation());
        this.definition = new CssDefinitionNode(name, this.comments);
        this.comments.clear();
        return this;
    }

    @Override
    public void onDefinitionEnd() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_DEFINITION));
        this.stateStack.pop();
        Preconditions.checkState((this.definition != null ? 1 : 0) != 0);
        this.getEnclosingBlock().addChildToBack(this.definition);
        this.definition = null;
    }

    @Override
    public void onCommentStart(ParserToken commentToken) {
        this.stateStack.push(State.INSIDE_COMMENT);
        this.comments.add(new CssCommentNode(commentToken.getToken(), commentToken.getSourceCodeLocation()));
    }

    @Override
    public void onCommentEnd() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_COMMENT));
        this.stateStack.pop();
    }

    @Override
    public void onRulesetStart(CssSelectorListNode selectorList) {
        this.startMainBody();
        this.endConditionalRuleChain();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MAIN_BODY, State.INSIDE_BLOCK, State.INSIDE_MEDIA_RULE));
        Preconditions.checkState((this.ruleset == null ? 1 : 0) != 0);
        this.ruleset = new CssRulesetNode(this.comments);
        this.ruleset.setSelectors(selectorList);
        this.comments.clear();
        Preconditions.checkState((this.declarationBlock == null ? 1 : 0) != 0);
        this.declarationBlock = this.ruleset.getDeclarations();
        this.stateStack.push(State.INSIDE_DECLARATION_BLOCK);
    }

    @Override
    public void onRulesetEnd() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_DECLARATION_BLOCK));
        Preconditions.checkState((this.declarationBlock != null ? 1 : 0) != 0);
        Preconditions.checkState((this.ruleset != null ? 1 : 0) != 0);
        Preconditions.checkState((this.declarationBlock == this.ruleset.getDeclarations() ? 1 : 0) != 0);
        this.declarationBlock = null;
        this.stateStack.pop();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_DECLARATION_BLOCK, State.INSIDE_MAIN_BODY, State.INSIDE_BLOCK, State.INSIDE_MEDIA_RULE));
        this.getEnclosingBlock().addChildToBack(this.ruleset);
        this.ruleset = null;
    }

    @Override
    public CssParserEventHandler.ExpressionHandler onDeclarationStart(ParserToken propertyName, boolean hasStarHack) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_DECLARATION_BLOCK));
        CssPropertyNode name = new CssPropertyNode(propertyName.getToken(), propertyName.getSourceCodeLocation());
        Preconditions.checkState((this.declaration == null ? 1 : 0) != 0);
        this.declaration = new CssDeclarationNode(name, this.comments);
        this.declaration.setStarHack(hasStarHack);
        this.comments.clear();
        this.stateStack.push(State.INSIDE_PROPERTY_EXPRESSION);
        return this;
    }

    @Override
    public void onDeclarationEnd() {
        this.stateStack.pop();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_DECLARATION_BLOCK));
        Preconditions.checkState((this.declaration != null ? 1 : 0) != 0);
        this.declarationBlock.addChildToBack(this.declaration);
        this.declaration = null;
    }

    @Override
    public void onLiteral(ParserToken expressionToken) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssLiteralNode expression = new CssLiteralNode(expressionToken.getToken(), expressionToken.getSourceCodeLocation());
        this.appendToCurrentExpression(expression);
    }

    @Override
    public void onOperator(ParserToken expressionToken) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        Preconditions.checkArgument((expressionToken.getToken().length() == 1 ? 1 : 0) != 0);
        if (expressionToken.getToken() != " ") {
            CssValueNode lastChild = null;
            if (this.stateStack.isIn(State.INSIDE_DEFINITION)) {
                Preconditions.checkState((this.definition != null ? 1 : 0) != 0);
                lastChild = (CssValueNode)this.definition.removeLastChild();
            } else if (this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION)) {
                Preconditions.checkState((this.declaration != null ? 1 : 0) != 0);
                lastChild = (CssValueNode)this.declaration.getPropertyValue().removeLastChild();
            }
            if (!(lastChild instanceof CssCompositeValueNode) || ((CssCompositeValueNode)lastChild).getOperator().toString() == expressionToken.getToken()) {
                CssCompositeValueNode node = new CssCompositeValueNode(Lists.newArrayList((Object[])new CssValueNode[]{lastChild}), CssCompositeValueNode.Operator.valueOf(expressionToken.getToken().charAt(0)), null);
                this.appendToCurrentExpression(node);
            } else if (lastChild != null) {
                this.appendToCurrentExpression(lastChild);
            }
            this.stateStack.push(State.INSIDE_EXPRESSION_AFTER_OPERATOR);
        }
    }

    @Override
    public void onPriority(ParserToken priority) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssPriorityNode expressionPriority = new CssPriorityNode(CssPriorityNode.PriorityType.IMPORTANT, priority.getSourceCodeLocation());
        this.appendToCurrentExpression(expressionPriority);
    }

    @Override
    public void onColor(ParserToken color) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssHexColorNode expression = new CssHexColorNode(color.getToken(), color.getSourceCodeLocation());
        this.appendToCurrentExpression(expression);
    }

    @Override
    public void onNumericValue(ParserToken numericValue, ParserToken unit) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssNumericNode expression = new CssNumericNode(numericValue.getToken(), unit != null ? unit.getToken() : CssNumericNode.NO_UNITS, numericValue.getSourceCodeLocation());
        this.appendToCurrentExpression(expression);
    }

    @Override
    public void onReference(ParserToken reference) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssConstantReferenceNode expression = new CssConstantReferenceNode(reference.getToken(), reference.getSourceCodeLocation());
        this.appendToCurrentExpression(expression);
    }

    @Override
    public void onFunction(ParserToken constant) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssFunctionNode.Function f = CssFunctionNode.Function.byName(constant.getToken());
        CssFunctionNode expression = f != null ? new CssFunctionNode(f, constant.getSourceCodeLocation()) : new CssCustomFunctionNode(constant.getToken(), constant.getSourceCodeLocation());
        this.appendToCurrentExpression(expression);
    }

    @Override
    public void onFunctionArgument(ParserToken term) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssLiteralNode expression = new CssLiteralNode(term.getToken(), term.getSourceCodeLocation());
        this.getFunctionFromCurrentExpression().getArguments().addChildToBack(expression);
    }

    @Override
    public void onReferenceFunctionArgument(ParserToken term) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_PROPERTY_EXPRESSION, State.INSIDE_DEFINITION, State.INSIDE_EXPRESSION_AFTER_OPERATOR));
        CssConstantReferenceNode expression = new CssConstantReferenceNode(term.getToken(), term.getSourceCodeLocation());
        this.getFunctionFromCurrentExpression().getArguments().addChildToBack(expression);
    }

    @Override
    public CssParserEventHandler.BooleanExpressionHandler onConditionalRuleStart(CssAtRuleNode.Type type, ParserToken ruleName) {
        this.startMainBody();
        if (type == CssAtRuleNode.Type.IF) {
            this.endConditionalRuleChain();
            Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MEDIA_RULE, State.INSIDE_MAIN_BODY, State.INSIDE_BLOCK));
        } else {
            Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_MEDIA_RULE, State.INSIDE_MAIN_BODY, State.INSIDE_BLOCK, State.INSIDE_CONDITIONAL_BLOCK));
        }
        if (this.stateStack.isIn(State.INSIDE_CONDITIONAL_BLOCK)) {
            Preconditions.checkState((!this.openConditionalBlocks.isEmpty() ? 1 : 0) != 0);
        } else {
            CssConditionalBlockNode conditionalBlock = new CssConditionalBlockNode(this.comments);
            this.comments.clear();
            this.openConditionalBlocks.add(conditionalBlock);
            this.stateStack.push(State.INSIDE_CONDITIONAL_BLOCK);
        }
        CssLiteralNode name = new CssLiteralNode(ruleName.getToken(), ruleName.getSourceCodeLocation());
        CssConditionalRuleNode conditionalRule = new CssConditionalRuleNode(type, name);
        this.pushEnclosingBlock(conditionalRule.getBlock());
        if (type != CssAtRuleNode.Type.ELSE) {
            this.stateStack.push(State.BEFORE_BOOLEAN_EXPRESSION);
            return this;
        }
        this.stateStack.push(State.INSIDE_BLOCK);
        return null;
    }

    @Override
    public void onConditionalRuleEnd() {
        this.endConditionalRuleChain();
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_BLOCK));
        CssConditionalRuleNode conditionalRule = (CssConditionalRuleNode)this.getEnclosingBlock().getParent();
        this.getEnclosingConditonalBlock().addChildToBack(conditionalRule);
        CssAtRuleNode.Type type = conditionalRule.getType();
        this.popEnclosingBlock();
        this.stateStack.pop();
        if (type == CssAtRuleNode.Type.ELSE) {
            this.endConditionalRuleChain();
        }
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_BLOCK, State.INSIDE_MAIN_BODY, State.INSIDE_MEDIA_RULE, State.INSIDE_CONDITIONAL_BLOCK));
    }

    @Override
    public void onBooleanExpressionStart() {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.BEFORE_BOOLEAN_EXPRESSION));
        this.stateStack.transitionTo(State.INSIDE_BOOLEAN_EXPRESSION);
    }

    @Override
    public Object onConstant(ParserToken constantName) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_BOOLEAN_EXPRESSION));
        return new CssBooleanExpressionNode(CssBooleanExpressionNode.Type.CONSTANT, constantName.getToken(), constantName.getSourceCodeLocation());
    }

    @Override
    public Object onUnaryOperator(CssBooleanExpressionNode.Type operator, ParserToken operatorToken, Object operand) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_BOOLEAN_EXPRESSION));
        return new CssBooleanExpressionNode(operator, operatorToken.getToken(), (CssBooleanExpressionNode)operand, operatorToken.getSourceCodeLocation());
    }

    @Override
    public Object onBinaryOperator(CssBooleanExpressionNode.Type operator, ParserToken operatorToken, Object leftOperand, Object rightOperand) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_BOOLEAN_EXPRESSION));
        return new CssBooleanExpressionNode(operator, operatorToken.getToken(), (CssBooleanExpressionNode)leftOperand, (CssBooleanExpressionNode)rightOperand, operatorToken.getSourceCodeLocation());
    }

    @Override
    public void onBooleanExpressionEnd(Object topOperand) {
        Preconditions.checkState((boolean)this.stateStack.isIn(State.INSIDE_BOOLEAN_EXPRESSION));
        CssConditionalRuleNode conditionalRule = (CssConditionalRuleNode)this.getEnclosingBlock().getParent();
        conditionalRule.setCondition((CssBooleanExpressionNode)topOperand);
        this.stateStack.transitionTo(State.INSIDE_BLOCK);
    }

    @VisibleForTesting
    static class StateStack {
        private List<State> stack;

        StateStack(State initialState) {
            this.stack = Lists.newArrayList((Object[])new State[]{initialState});
        }

        void push(State state) {
            this.stack.add(state);
        }

        void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        void transitionTo(State newState) {
            this.pop();
            this.push(newState);
        }

        boolean isIn(State ... states) {
            return Arrays.asList(states).contains((Object)this.stack.get(this.stack.size() - 1));
        }

        int size() {
            return this.stack.size();
        }
    }

    static enum State {
        BEFORE_DOCUMENT_START,
        BEFORE_MAIN_BODY,
        INSIDE_IMPORT_RULE,
        INSIDE_MAIN_BODY,
        INSIDE_MEDIA_RULE,
        INSIDE_BLOCK,
        INSIDE_DECLARATION_BLOCK,
        INSIDE_PROPERTY_EXPRESSION,
        INSIDE_EXPRESSION_AFTER_OPERATOR,
        INSIDE_CONDITIONAL_BLOCK,
        BEFORE_BOOLEAN_EXPRESSION,
        INSIDE_BOOLEAN_EXPRESSION,
        INSIDE_DEFINITION,
        INSIDE_COMMENT,
        DONE_BUILDING;

    }
}

