/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CssValueNode
extends CssNode {
    private String value;
    private boolean isDefault;

    public CssValueNode(@Nullable String value, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(sourceCodeLocation);
        this.value = value;
        this.isDefault = false;
    }

    public CssValueNode(String value) {
        this(value, null);
    }

    public CssValueNode(CssValueNode node) {
        this(node.getValue(), node.getSourceCodeLocation());
        this.isDefault = node.getIsDefault();
    }

    @Override
    public abstract CssValueNode deepCopy();

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    public static Iterable<CssValueNode> leaves(final Collection<CssValueNode> roots) {
        return new Iterable<CssValueNode>(){

            @Override
            public Iterator<CssValueNode> iterator() {
                return new UnmodifiableIterator<CssValueNode>(){
                    LinkedList<CssValueNode> q = Lists.newLinkedList();
                    {
                        this.q.addAll(roots);
                    }

                    List<CssValueNode> expand(CssValueNode n) {
                        if (n instanceof CssBooleanExpressionNode) {
                            CssBooleanExpressionNode b = (CssBooleanExpressionNode)n;
                            return ImmutableList.of((Object)b.getLeft(), (Object)b.getRight());
                        }
                        if (n instanceof CssCompositeValueNode) {
                            CssCompositeValueNode c = (CssCompositeValueNode)n;
                            return c.getValues();
                        }
                        return ImmutableList.of((Object)n);
                    }

                    void advance() {
                        CssValueNode unexpanded;
                        List<CssValueNode> expanded;
                        do {
                            unexpanded = this.q.remove();
                            expanded = this.expand(unexpanded);
                            this.q.addAll(0, expanded);
                        } while (expanded.size() != 1 || !expanded.get(0).equals(unexpanded));
                    }

                    public boolean hasNext() {
                        return !this.q.isEmpty();
                    }

                    public CssValueNode next() {
                        this.advance();
                        return this.q.remove();
                    }
                };
            }
        };
    }

    @Override
    public String toString() {
        return this.getValue();
    }
}

