/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;
import com.google.gwt.thirdparty.common.css.compiler.passes.MarkRemovableRulesetNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.PassUtil;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Set;

public class DisallowDuplicateDeclarations
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String ERROR_STR = "Detected multiple identical, non-alternate declarations in the same ruleset. If this is intentional please use the /* @alternate */ annotation. ";
    private final VisitController visitController;
    private final ErrorManager errorManager;
    private final Set<String> propertyNames = Sets.newHashSet();

    public DisallowDuplicateDeclarations(VisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterRuleset(CssRulesetNode node) {
        for (CssNode child : node.getDeclarations().childIterable()) {
            this.processDeclaration((CssDeclarationNode)child, node.getSourceCodeLocation());
        }
        this.propertyNames.clear();
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    @VisibleForTesting
    void processDeclaration(CssDeclarationNode declaration, SourceCodeLocation location) {
        String propertyName = declaration.getPropertyName().getPropertyName();
        if (MarkRemovableRulesetNodes.PROPERTIES_NOT_TO_BE_CHECKED.contains(propertyName)) {
            return;
        }
        if (declaration.hasStarHack()) {
            propertyName = "*" + propertyName;
        }
        if (PassUtil.hasAlternateAnnotation(declaration)) {
            return;
        }
        if (this.propertyNames.contains(propertyName)) {
            this.errorManager.report(new GssError(ERROR_STR + declaration, location));
        } else {
            this.propertyNames.add(propertyName);
        }
    }
}

