/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCustomFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunction;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunctionException;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.passes.ConstantDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.ResolveCustomFunctionNodes;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolveCustomFunctionNodesForChunks<T>
extends ResolveCustomFunctionNodes {
    public static final String DEF_PREFIX = "__F";
    private final Function<T, String> nextUniqueSuffix;
    private final Map<T, ConstantDefinitions> constantDefinitions = Maps.newHashMap();

    public ResolveCustomFunctionNodesForChunks(MutatingVisitController visitController, ErrorManager errorManager, Map<String, GssFunction> functionMap, boolean allowUnknownFunctions, Set<String> allowedNonStandardFunctions, Function<T, String> nextUniqueSuffix) {
        super(visitController, errorManager, functionMap, allowUnknownFunctions, allowedNonStandardFunctions);
        this.nextUniqueSuffix = nextUniqueSuffix;
    }

    @Override
    protected List<CssValueNode> evaluateFunction(CssCustomFunctionNode node, GssFunction function, List<CssValueNode> arguments, ErrorManager errorManager) throws GssFunctionException {
        List<CssValueNode> functionResult = Iterables.any(arguments, (Predicate)Predicates.instanceOf(CssConstantReferenceNode.class)) ? this.replaceCallWithReference(node) : super.evaluateFunction(node, function, arguments, errorManager);
        return functionResult;
    }

    public Map<T, ConstantDefinitions> getConstantDefinitions() {
        return this.constantDefinitions;
    }

    private List<CssValueNode> replaceCallWithReference(CssCustomFunctionNode node) {
        Object chunk = node.getChunk();
        String defName = DEF_PREFIX + (String)this.nextUniqueSuffix.apply(chunk);
        CssLiteralNode defLiteral = new CssLiteralNode(defName, node.getSourceCodeLocation());
        CssDefinitionNode def = new CssDefinitionNode((List<CssValueNode>)ImmutableList.of((Object)node.deepCopy()), defLiteral);
        CssConstantReferenceNode defRef = new CssConstantReferenceNode(defName, node.getSourceCodeLocation());
        this.addNewDefinition(chunk, def);
        return ImmutableList.of((Object)defRef);
    }

    private void addNewDefinition(T chunk, CssDefinitionNode def) {
        Preconditions.checkNotNull(chunk);
        def.setChunk(chunk);
        ConstantDefinitions chunkDefinitions = this.constantDefinitions.get(chunk);
        if (chunkDefinitions == null) {
            chunkDefinitions = new ConstantDefinitions();
            this.constantDefinitions.put(chunk, chunkDefinitions);
        }
        chunkDefinitions.addConstantDefinition(def);
    }
}

