/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.HotSwapCompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.rhino.JSDocInfo;
import com.google.gwt.thirdparty.javascript.rhino.Node;

class ControlStructureCheck
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    static final DiagnosticType USE_OF_WITH = DiagnosticType.warning("JSC_USE_OF_WITH", "The use of the 'with' structure should be avoided.");

    ControlStructureCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.check(root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.check(scriptRoot);
    }

    private void check(Node node) {
        switch (node.getType()) {
            case 119: {
                boolean allowWith;
                JSDocInfo info = node.getJSDocInfo();
                boolean bl = allowWith = info != null && info.getSuppressions().contains("with");
                if (allowWith) break;
                this.report(node, USE_OF_WITH);
            }
        }
        Node bChild = node.getFirstChild();
        while (bChild != null) {
            Node next = bChild.getNext();
            this.check(bChild);
            bChild = next;
        }
    }

    private void report(Node n, DiagnosticType error) {
        this.compiler.report(JSError.make(n.getSourceFileName(), n, error, new String[0]));
    }
}

