/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.jscomp.ScopeCreator;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.StaticSymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

class MemoizedScopeCreator
implements ScopeCreator,
StaticSymbolTable<Scope.Var, Scope.Var> {
    private final Map<Node, Scope> scopes = Maps.newHashMap();
    private final ScopeCreator delegate;

    MemoizedScopeCreator(ScopeCreator delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterable<Scope.Var> getReferences(Scope.Var var) {
        return ImmutableList.of((Object)var);
    }

    public Scope getScope(Scope.Var var) {
        return var.scope;
    }

    @Override
    public Iterable<Scope.Var> getAllSymbols() {
        ArrayList vars = Lists.newArrayList();
        for (Scope s : this.scopes.values()) {
            Iterables.addAll((Collection)vars, s.getAllSymbols());
        }
        return vars;
    }

    @Override
    public Scope createScope(Node n, Scope parent) {
        Scope scope = this.scopes.get(n);
        if (scope == null) {
            scope = this.delegate.createScope(n, parent);
            this.scopes.put(n, scope);
        } else {
            Preconditions.checkState((parent == scope.getParent() ? 1 : 0) != 0);
        }
        return scope;
    }

    Collection<Scope> getAllMemoizedScopes() {
        return Collections.unmodifiableCollection(this.scopes.values());
    }

    Scope getScopeIfMemoized(Node n) {
        return this.scopes.get(n);
    }

    void removeScopesForScript(String scriptName) {
        for (Node scopeRoot : ImmutableSet.copyOf(this.scopes.keySet())) {
            if (!scriptName.equals(scopeRoot.getSourceFileName())) continue;
            this.scopes.remove(scopeRoot);
        }
    }
}

