/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.Compiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.FunctionInformationMap;
import com.google.gwt.thirdparty.javascript.jscomp.FunctionNames;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.JSModuleGraph;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

class RecordFunctionInformation
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final Compiler compiler;
    private final FunctionNames functionNames;
    private final JSModuleGraph moduleGraph;
    private final FunctionInformationMap.Builder mapBuilder;

    RecordFunctionInformation(Compiler compiler, FunctionNames functionNames) {
        this.compiler = compiler;
        this.moduleGraph = compiler.getModuleGraph();
        this.functionNames = functionNames;
        this.mapBuilder = FunctionInformationMap.newBuilder();
    }

    FunctionInformationMap getMap() {
        return this.mapBuilder.build();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        if (this.moduleGraph == null) {
            this.addModuleInformation(null);
        } else {
            TreeSet modules = Sets.newTreeSet((Comparator)new Comparator<JSModule>(){

                @Override
                public int compare(JSModule o1, JSModule o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Iterables.addAll((Collection)modules, this.moduleGraph.getAllModules());
            for (JSModule m : modules) {
                this.addModuleInformation(m);
            }
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isFunction()) {
            return;
        }
        int id = this.functionNames.getFunctionId(n);
        if (id < 0) {
            return;
        }
        String compiledSource = this.compiler.toSource(n);
        JSModule module = t.getModule();
        this.mapBuilder.addEntry(FunctionInformationMap.Entry.newBuilder().setId(id).setSourceName(NodeUtil.getSourceName(n)).setLineNumber(n.getLineno()).setModuleName(this.moduleGraph == null ? "" : module.getName()).setSize(compiledSource.length()).setName(this.functionNames.getFunctionName(n)).setCompiledSource(compiledSource).build());
    }

    private void addModuleInformation(JSModule module) {
        String source;
        String name;
        if (module != null) {
            name = module.getName();
            source = this.compiler.toSource(module);
        } else {
            name = "";
            source = this.compiler.toSource();
        }
        this.mapBuilder.addModule(FunctionInformationMap.Module.newBuilder().setName(name).setCompiledSource(source).build());
    }
}

