/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.ConcreteType;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.JSDocInfo;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ObjectType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.StaticReference;
import com.google.gwt.thirdparty.javascript.rhino.jstype.StaticScope;
import com.google.gwt.thirdparty.javascript.rhino.jstype.StaticSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TightenTypes
implements CompilerPass,
ConcreteType.Factory {
    public static final String NON_HALTING_ERROR_MSG = "TightenTypes pass appears to be stuck in an infinite loop.";
    private final AbstractCompiler compiler;
    private final Map<Node, ConcreteType.ConcreteFunctionType> functionFromDeclaration = Maps.newHashMap();
    private final Map<FunctionType, ConcreteType.ConcreteFunctionType> functionFromJSType = Maps.newIdentityHashMap();
    private final Map<ObjectType, ConcreteType.ConcreteInstanceType> instanceFromJSType = Maps.newHashMap();
    private final Map<ConcreteJSTypePair, ConcreteType> typeIntersectionMemos = Maps.newHashMap();
    private ConcreteScope topScope;
    private Set<ConcreteType> allInstantiatedTypes = Sets.newHashSet();

    TightenTypes(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    ConcreteScope getTopScope() {
        return this.topScope;
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        return this.compiler.getTypeRegistry();
    }

    @Override
    public void process(Node externRoot, Node jsRoot) {
        boolean changed;
        this.topScope = new ConcreteScope(null);
        this.topScope.initForExternRoot(externRoot);
        this.topScope.initForScopeRoot(jsRoot);
        long maxIterations = 1000L;
        long iterations = 0L;
        HashSet workSet = Sets.newHashSet((Object[])new ConcreteScope[]{this.topScope});
        ArrayList workList = Lists.newArrayList((Object[])new ConcreteScope[]{this.topScope});
        do {
            changed = false;
            for (int i = 0; i < workList.size(); ++i) {
                ConcreteScope scope = (ConcreteScope)workList.get(i);
                for (Action action : scope.getActions()) {
                    for (Assignment assign : action.getAssignments(scope)) {
                        if (!assign.slot.addConcreteType(assign.type)) continue;
                        changed = true;
                        ConcreteScope varScope = assign.slot.getScope();
                        if (varScope == scope || workSet.contains(varScope)) continue;
                        workSet.add(varScope);
                        workList.add(varScope);
                    }
                }
            }
            Preconditions.checkState((++iterations != maxIterations ? 1 : 0) != 0, (Object)NON_HALTING_ERROR_MSG);
        } while (changed);
    }

    private List<Assignment> getFunctionCallAssignments(ConcreteType recvType, ConcreteType thisType, List<ConcreteType> argTypes) {
        ArrayList assigns = Lists.newArrayList();
        for (ConcreteType.ConcreteFunctionType fType : recvType.getFunctions()) {
            assigns.add(new Assignment((ConcreteSlot)fType.getCallSlot(), fType));
            assigns.add(new Assignment((ConcreteSlot)fType.getThisSlot(), thisType));
            for (int i = 0; i < argTypes.size(); ++i) {
                ConcreteSlot variable = (ConcreteSlot)fType.getParameterSlot(i);
                if (variable == null) continue;
                assigns.add(new Assignment(variable, argTypes.get(i)));
            }
        }
        return assigns;
    }

    private ConcreteType createType(Node name, ConcreteScope scope) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)name.isName());
        if (name.getJSType() == null) {
            return ConcreteType.ALL;
        }
        if (name.getFirstChild() != null && name.getFirstChild().isFunction()) {
            return this.createConcreteFunction(name.getFirstChild(), scope);
        }
        return this.createType(name.getJSType());
    }

    private ConcreteType createType(JSType jsType) {
        if (jsType.isUnknownType() || jsType.isEmptyType()) {
            return ConcreteType.ALL;
        }
        if (jsType.isUnionType()) {
            ConcreteType type = ConcreteType.NONE;
            for (JSType alt : jsType.toMaybeUnionType().getAlternates()) {
                type = type.unionWith(this.createType(alt));
            }
            return type;
        }
        if (jsType.isFunctionType()) {
            if (this.getConcreteFunction(jsType.toMaybeFunctionType()) != null) {
                return this.getConcreteFunction(jsType.toMaybeFunctionType());
            }
            return ConcreteType.ALL;
        }
        if (jsType.isObject()) {
            return this.createConcreteInstance(jsType.toObjectType());
        }
        return ConcreteType.NONE;
    }

    private ConcreteType createTypeWithSubTypes(JSType jsType) {
        ConcreteType ret = ConcreteType.NONE;
        if (jsType.isUnionType()) {
            for (JSType alt : jsType.toMaybeUnionType().getAlternates()) {
                ret = ret.unionWith(this.createTypeWithSubTypes(alt));
            }
        } else {
            ObjectType instType = ObjectType.cast(jsType);
            if (instType != null && instType.getConstructor() != null && instType.getConstructor().isInterface()) {
                Collection<FunctionType> implementors = this.getTypeRegistry().getDirectImplementors(instType);
                for (FunctionType implementor : implementors) {
                    ret = ret.unionWith(this.createTypeWithSubTypes(implementor.getInstanceType()));
                }
            } else {
                ret = ret.unionWith(this.createUnionWithSubTypes(this.createType(jsType)));
            }
        }
        return ret;
    }

    ConcreteType inferConcreteType(ConcreteScope scope, Node expr) {
        ConcreteType ret;
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkNotNull((Object)expr);
        switch (expr.getType()) {
            case 38: {
                StaticSlot<ConcreteType> slot = scope.getSlot(expr.getString());
                if (slot != null) {
                    ret = slot.getType();
                    break;
                }
                ret = ConcreteType.ALL;
                break;
            }
            case 42: {
                ret = scope.getTypeOfThis();
                break;
            }
            case 86: {
                ret = this.inferConcreteType(scope, expr.getLastChild());
                break;
            }
            case 85: {
                ret = this.inferConcreteType(scope, expr.getLastChild());
                break;
            }
            case 101: {
                ret = this.inferConcreteType(scope, expr.getLastChild());
                break;
            }
            case 100: {
                ret = this.inferConcreteType(scope, expr.getFirstChild()).unionWith(this.inferConcreteType(scope, expr.getLastChild()));
                break;
            }
            case 98: {
                ret = this.inferConcreteType(scope, expr.getFirstChild().getNext()).unionWith(this.inferConcreteType(scope, expr.getLastChild()));
                break;
            }
            case 33: {
                ConcreteType recvType = this.inferConcreteType(scope, expr.getFirstChild());
                if (recvType.isAll()) {
                    ret = recvType;
                    break;
                }
                Node prop = expr.getLastChild();
                String propName = prop.getString();
                ConcreteType type = recvType.getPropertyType(propName);
                if ("prototype".equals(propName)) {
                    for (ConcreteType.ConcreteFunctionType funType : recvType.getFunctions()) {
                        type = type.unionWith(funType.getPrototypeType());
                    }
                } else if (this.compiler.getCodingConvention().isSuperClassReference(propName)) {
                    for (ConcreteType.ConcreteFunctionType superType : recvType.getSuperclassTypes()) {
                        type = type.unionWith(superType.getPrototypeType());
                    }
                } else if ("call".equals(propName)) {
                    type = recvType;
                }
                ret = type;
                break;
            }
            case 35: {
                ret = ConcreteType.ALL;
                break;
            }
            case 37: {
                ConcreteType targetType = this.inferConcreteType(scope, expr.getFirstChild());
                if (targetType.isAll()) {
                    ret = targetType;
                    break;
                }
                ret = ConcreteType.NONE;
                for (ConcreteType.ConcreteFunctionType funType : targetType.getFunctions()) {
                    ret = ret.unionWith(funType.getReturnSlot().getType());
                }
                break;
            }
            case 30: {
                ConcreteType constructorType = this.inferConcreteType(scope, expr.getFirstChild());
                if (constructorType.isAll()) {
                    throw new AssertionError((Object)"Attempted new call on all type!");
                }
                ret = ConcreteType.NONE;
                for (ConcreteType.ConcreteInstanceType instType : constructorType.getFunctionInstanceTypes()) {
                    ret = ret.unionWith(instType);
                }
                this.allInstantiatedTypes.add(ret);
                break;
            }
            case 105: {
                ret = this.createConcreteFunction(expr, scope);
                break;
            }
            case 64: {
                if (expr.getJSType() != null && !expr.getJSType().isUnknownType()) {
                    JSType exprType = expr.getJSType().restrictByNotNullOrUndefined();
                    ConcreteType.ConcreteInstanceType inst = this.createConcreteInstance(exprType.toObjectType());
                    this.allInstantiatedTypes.add(inst);
                    ret = inst;
                    break;
                }
                ret = ConcreteType.ALL;
                break;
            }
            case 63: {
                ObjectType arrayType = (ObjectType)this.getTypeRegistry().getNativeType(JSTypeNative.ARRAY_TYPE);
                ConcreteType.ConcreteInstanceType inst = this.createConcreteInstance(arrayType);
                this.allInstantiatedTypes.add(inst);
                ret = inst;
                break;
            }
            default: {
                ret = ConcreteType.NONE;
            }
        }
        return this.createTypeIntersection(ret, expr.getJSType());
    }

    private ConcreteType createTypeIntersection(ConcreteType concreteType, JSType jsType) {
        ConcreteJSTypePair key = new ConcreteJSTypePair(concreteType, jsType);
        ConcreteType ret = this.typeIntersectionMemos.get(key);
        if (ret != null) {
            return ret;
        }
        if (jsType == null || jsType.isUnknownType() || concreteType.isNone()) {
            ret = concreteType;
        } else if (concreteType.isUnion() || concreteType.isSingleton()) {
            ret = concreteType.intersectWith(this.createTypeWithSubTypes(jsType));
        } else {
            Preconditions.checkState((boolean)concreteType.isAll());
            ret = this.createTypeWithSubTypes(jsType);
        }
        ret = ret.intersectWith(ConcreteType.createForTypes(this.allInstantiatedTypes));
        for (ConcreteType.ConcreteFunctionType functionType : concreteType.getFunctions()) {
            ret = ret.unionWith(functionType);
        }
        for (ConcreteType.ConcreteInstanceType prototype : concreteType.getPrototypeTypes()) {
            ret = ret.unionWith(prototype);
        }
        for (ConcreteType.ConcreteInstanceType instance : concreteType.getInstances()) {
            if (instance.instanceType.isInstanceType() || instance.isFunctionPrototype()) continue;
            ret = ret.unionWith(instance);
        }
        this.typeIntersectionMemos.put(key, ret);
        return ret;
    }

    @Override
    public ConcreteType.ConcreteFunctionType createConcreteFunction(Node decl, StaticScope<ConcreteType> parent) {
        ConcreteType.ConcreteFunctionType funType = this.functionFromDeclaration.get(decl);
        if (funType == null) {
            funType = new ConcreteType.ConcreteFunctionType(this, decl, parent);
            this.functionFromDeclaration.put(decl, funType);
            if (decl.getJSType() != null) {
                this.functionFromJSType.put(decl.getJSType().toMaybeFunctionType(), funType);
            }
        }
        return funType;
    }

    @Override
    public ConcreteType.ConcreteInstanceType createConcreteInstance(ObjectType instanceType) {
        Preconditions.checkArgument((!instanceType.isFunctionType() || instanceType == this.getTypeRegistry().getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE) ? 1 : 0) != 0);
        ConcreteType.ConcreteInstanceType instType = this.instanceFromJSType.get(instanceType);
        if (instType == null) {
            instType = new ConcreteType.ConcreteInstanceType(this, instanceType);
            this.instanceFromJSType.put(instanceType, instType);
        }
        return instType;
    }

    ConcreteType.ConcreteFunctionType getConcreteFunction(Node decl) {
        return this.functionFromDeclaration.get(decl);
    }

    @Override
    public ConcreteType.ConcreteFunctionType getConcreteFunction(FunctionType functionType) {
        return this.functionFromJSType.get(functionType);
    }

    @Override
    public ConcreteType.ConcreteInstanceType getConcreteInstance(ObjectType instanceType) {
        return this.instanceFromJSType.get(instanceType);
    }

    @Override
    public StaticScope<ConcreteType> createFunctionScope(Node decl, StaticScope<ConcreteType> parent) {
        ConcreteScope scope = new ConcreteScope((ConcreteScope)parent);
        scope.declareSlot(":call", decl);
        scope.declareSlot(":this", decl);
        scope.declareSlot(":return", decl);
        for (Node n = decl.getFirstChild().getNext().getFirstChild(); n != null; n = n.getNext()) {
            scope.declareSlot(n.getString(), n);
        }
        scope.initForScopeRoot(decl.getLastChild());
        return scope;
    }

    @Override
    public StaticScope<ConcreteType> createInstanceScope(ObjectType instanceType) {
        ConcreteScope parentScope = null;
        ObjectType implicitProto = instanceType.getImplicitPrototype();
        if (implicitProto != null && !implicitProto.isUnknownType()) {
            ConcreteType.ConcreteInstanceType prototype = this.createConcreteInstance(implicitProto);
            parentScope = (ConcreteScope)prototype.getScope();
        }
        ConcreteScope scope = new ConcreteScope(parentScope);
        for (String propName : instanceType.getOwnPropertyNames()) {
            scope.declareSlot(propName, null);
        }
        return scope;
    }

    ConcreteType createUnionWithSubTypes(ConcreteType type) {
        Set<ConcreteType> set = null;
        if (type.isInstance()) {
            set = this.getSubTypes(type.toInstance());
        }
        return ConcreteType.createForTypes(set).unionWith(type);
    }

    private Set<ConcreteType> getSubTypes(ConcreteType.ConcreteInstanceType type) {
        if (type.getConstructorType() == null) {
            return null;
        }
        HashSet set = Sets.newHashSet();
        this.getSubTypes(type.getConstructorType().getJSType(), set);
        return set;
    }

    private boolean getSubTypes(FunctionType type, Set<ConcreteType> set) {
        if (type.getSubTypes() != null) {
            for (FunctionType sub : type.getSubTypes()) {
                ConcreteType concrete = this.createType(sub);
                if (concrete.isFunction() && concrete.toFunction().getInstanceType() != null) {
                    if (set.contains(concrete = concrete.toFunction().getInstanceType())) continue;
                    set.add(concrete);
                    if (this.getSubTypes(sub, set)) continue;
                    return false;
                }
                set.clear();
                set.add(ConcreteType.ALL);
                return false;
            }
        }
        return true;
    }

    static class ConcreteJSTypePair {
        final ConcreteType concrete;
        final JSType jstype;
        final int hashcode;

        ConcreteJSTypePair(ConcreteType concrete, JSType jstype) {
            this.concrete = concrete;
            this.jstype = jstype;
            this.hashcode = concrete.hashCode() + this.getJSTypeHashCode();
        }

        private int getJSTypeHashCode() {
            return this.jstype != null ? this.jstype.hashCode() : 0;
        }

        private boolean equalsJSType(JSType jsType) {
            if (jsType == null || this.jstype == null) {
                return this.jstype == jsType;
            }
            return jsType.equals(this.jstype);
        }

        public boolean equals(Object o) {
            if (o instanceof ConcreteJSTypePair) {
                ConcreteJSTypePair pair = (ConcreteJSTypePair)o;
                if (pair.concrete.equals(this.concrete) && this.equalsJSType(pair.jstype)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    private class CreateScope
    extends NodeTraversal.AbstractShallowCallback {
        private final ConcreteScope scope;
        private final boolean inExterns;

        CreateScope(ConcreteScope scope, boolean inExterns) {
            this.scope = scope;
            this.inExterns = inExterns;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 118: {
                    for (Node name = n.getFirstChild(); name != null; name = name.getNext()) {
                        if (this.inExterns) {
                            this.scope.declareSlot(name.getString(), n, TightenTypes.this.createType(name, this.scope));
                            continue;
                        }
                        this.scope.declareSlot(name.getString(), n);
                        if (name.getFirstChild() == null) continue;
                        this.addActions(this.createAssignmentActions(name, name.getFirstChild(), n));
                    }
                    break;
                }
                case 33: {
                    ConcreteScope scope;
                    ConcreteType type;
                    if (!this.inExterns || !(type = TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), n)).isNone() || (scope = (ConcreteScope)TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), n.getFirstChild()).getScope()) == null || (type = TightenTypes.this.createType(n.getJSType())).isNone() || type.isAll()) break;
                    type = TightenTypes.this.createUnionWithSubTypes(type);
                    Node nameNode = n.getLastChild();
                    scope.declareSlot(nameNode.getString(), n, type);
                    break;
                }
                case 105: {
                    if (!NodeUtil.isFunctionDeclaration(n) || n.getJSType().isNoObjectType()) break;
                    ConcreteType type = TightenTypes.this.createConcreteFunction(n, this.scope);
                    this.scope.declareSlot(n.getFirstChild().getString(), n, type);
                    if (!this.inExterns || ((ConcreteType.ConcreteFunctionType)type).getInstanceType() == null) break;
                    TightenTypes.this.allInstantiatedTypes.add(((ConcreteType.ConcreteFunctionType)type).getInstanceType());
                    break;
                }
                case 86: {
                    ConcreteScope scope;
                    Node lhs = n.getFirstChild();
                    if (this.inExterns) {
                        ConcreteType type;
                        if (lhs.isGetProp()) {
                            type = TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), lhs.getFirstChild());
                            scope = (ConcreteScope)type.getScope();
                        } else {
                            scope = TightenTypes.this.getTopScope();
                        }
                        if (scope == null || (type = TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), n)).isNone() || type.isAll()) break;
                        if (type.isFunction()) {
                            FunctionType funType;
                            JSType lhsType = lhs.getJSType();
                            if (lhsType == null || (funType = lhsType.restrictByNotNullOrUndefined().toMaybeFunctionType()) == null) break;
                            ConcreteType retType = TightenTypes.this.createType(funType.getReturnType());
                            retType = TightenTypes.this.createUnionWithSubTypes(retType);
                            ConcreteType newret = type.toFunction().getReturnSlot().getType().unionWith(retType);
                            ((ConcreteScope)type.getScope()).declareSlot(":return", n, newret);
                        }
                        scope.declareSlot(lhs.getLastChild().getString(), n, type);
                        break;
                    }
                    this.addActions(this.createAssignmentActions(lhs, n.getLastChild(), n));
                    break;
                }
                case 30: 
                case 37: {
                    Node receiver = n.getFirstChild();
                    if (receiver.isGetProp()) {
                        Node first = receiver.getFirstChild();
                        if ("call".equals(first.getNext().getString())) {
                            if (first.isGetProp()) {
                                this.addAction(new FunctionCallBuilder(first, receiver.getNext()).setPropName(first.getFirstChild().getNext().getString()).setIsCallFunction().build());
                                break;
                            }
                            this.addAction(new FunctionCallBuilder(first, receiver.getNext()).setIsCallFunction().build());
                            break;
                        }
                        this.addAction(new FunctionCallBuilder(first, receiver.getNext()).setPropName(first.getNext().getString()).build());
                        break;
                    }
                    this.addAction(new FunctionCallBuilder(receiver, receiver.getNext()).setIsNewCall(n.isNew()).build());
                    break;
                }
                case 38: {
                    if (!parent.isCatch() || parent.getFirstChild() != n) break;
                    this.scope.declareSlot(n.getString(), n, TightenTypes.this.createUnionWithSubTypes(TightenTypes.this.createType(TightenTypes.this.getTypeRegistry().getType("Error")).toInstance()));
                    break;
                }
                case 4: {
                    if (n.getFirstChild() == null) break;
                    this.addAction(new VariableAssignAction((ConcreteSlot)this.scope.getOwnSlot(":return"), n.getFirstChild()));
                }
            }
            Collection<Action> actions2 = this.getImplicitActions(n);
            if (actions2 != null) {
                for (Action action : actions2) {
                    this.addAction(action);
                }
            }
        }

        private void addAction(Action action) {
            Preconditions.checkState((!this.inExterns ? 1 : 0) != 0, (Object)"Unexpected action in externs.");
            this.scope.addAction(action);
        }

        private void addActions(List<Action> actions2) {
            Preconditions.checkState((!this.inExterns ? 1 : 0) != 0, (Object)"Unexpected action in externs.");
            for (Action action : actions2) {
                this.scope.addAction(action);
            }
        }

        private List<Action> createAssignmentActions(Node lhs, Node rhs, Node parent) {
            switch (lhs.getType()) {
                case 38: {
                    ConcreteSlot var = (ConcreteSlot)this.scope.getSlot(lhs.getString());
                    Preconditions.checkState((var != null ? 1 : 0) != 0, (String)"Type tightener could not find variable with name %s", (Object[])new Object[]{lhs.getString()});
                    return Lists.newArrayList((Object[])new Action[]{new VariableAssignAction(var, rhs)});
                }
                case 33: {
                    Node receiver = lhs.getFirstChild();
                    return Lists.newArrayList((Object[])new Action[]{new PropertyAssignAction(receiver, rhs)});
                }
                case 35: {
                    return Lists.newArrayList();
                }
            }
            throw new AssertionError((Object)("Bad LHS for assignment: " + parent.toStringTree()));
        }

        private ExternFunctionCall createExternFunctionCall(Node receiver, JSType jsThisType, FunctionType fun) {
            ConcreteType thisType;
            ArrayList argTypes = Lists.newArrayList();
            if (fun != null) {
                thisType = TightenTypes.this.createType(jsThisType);
                for (Node arg : fun.getParameters()) {
                    argTypes.add(TightenTypes.this.createType(arg, this.scope));
                }
            } else {
                thisType = ConcreteType.NONE;
            }
            return new ExternFunctionCall(receiver, thisType, argTypes);
        }

        private JSType getJSType(Node n) {
            if (n.getJSType() != null) {
                return n.getJSType();
            }
            return TightenTypes.this.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        private Collection<Action> getImplicitActions(Node n) {
            switch (n.getType()) {
                case 37: {
                    Node receiver = n.getFirstChild();
                    if (this.inExterns || !receiver.isGetProp()) break;
                    return this.getImplicitActionsFromCall(n, receiver.getJSType());
                }
                case 86: {
                    Node lhs = n.getFirstChild();
                    if (this.inExterns || !lhs.isGetProp()) break;
                    return this.getImplicitActionsFromProp(lhs.getFirstChild().getJSType(), lhs.getLastChild().getString(), n.getLastChild());
                }
            }
            return null;
        }

        private Collection<Action> getImplicitActionsFromCall(Node n, JSType recvType) {
            Node receiver = n.getFirstChild();
            if (recvType.isUnionType()) {
                ArrayList actions2 = Lists.newArrayList();
                for (JSType alt : recvType.toMaybeUnionType().getAlternates()) {
                    actions2.addAll(this.getImplicitActionsFromCall(n, alt));
                }
                return actions2;
            }
            if (!recvType.isFunctionType()) {
                return Lists.newArrayList();
            }
            ObjectType objType = ObjectType.cast(this.getJSType(receiver.getFirstChild()).restrictByNotNullOrUndefined());
            String prop = receiver.getLastChild().getString();
            if (objType != null && objType.isPropertyInExterns(prop) && recvType.toMaybeFunctionType().getParameters() != null) {
                ArrayList actions3 = Lists.newArrayList();
                Iterator<Node> paramIter = recvType.toMaybeFunctionType().getParameters().iterator();
                Iterator<Node> argumentIter = n.children().iterator();
                argumentIter.next();
                while (paramIter.hasNext() && argumentIter.hasNext()) {
                    Node arg = argumentIter.next();
                    Node param = paramIter.next();
                    if (arg.getJSType() == null || !arg.getJSType().isFunctionType()) continue;
                    actions3.addAll(this.getImplicitActionsFromArgument(arg, arg.getJSType().toMaybeFunctionType().getTypeOfThis().toObjectType(), param.getJSType()));
                }
                return actions3;
            }
            return Lists.newArrayList();
        }

        private Collection<Action> getImplicitActionsFromArgument(Node arg, ObjectType thisType, JSType paramType) {
            if (paramType.isUnionType()) {
                ArrayList actions2 = Lists.newArrayList();
                for (JSType paramAlt : paramType.toMaybeUnionType().getAlternates()) {
                    actions2.addAll(this.getImplicitActionsFromArgument(arg, thisType, paramAlt));
                }
                return actions2;
            }
            if (paramType.isFunctionType()) {
                return Lists.newArrayList((Object[])new Action[]{this.createExternFunctionCall(arg, thisType, paramType.toMaybeFunctionType())});
            }
            return Lists.newArrayList((Object[])new Action[]{this.createExternFunctionCall(arg, thisType, null)});
        }

        private Collection<Action> getImplicitActionsFromProp(JSType jsType, String prop, Node fnNode) {
            ArrayList actions2 = Lists.newArrayList();
            if (jsType.isUnionType()) {
                boolean found = false;
                for (JSType alt : jsType.toMaybeUnionType().getAlternates()) {
                    ObjectType altObj = ObjectType.cast(alt);
                    if (altObj == null) continue;
                    actions2.addAll(this.getImplicitActionsFromPropNonUnion(altObj, prop, fnNode));
                    if (!altObj.hasProperty(prop)) continue;
                    found = true;
                }
                if (found) {
                    return actions2;
                }
            } else {
                ObjectType objType = ObjectType.cast(jsType);
                if (objType != null && !objType.isUnknownType() && objType.hasProperty(prop)) {
                    return this.getImplicitActionsFromPropNonUnion(objType, prop, fnNode);
                }
            }
            for (ObjectType type : TightenTypes.this.getTypeRegistry().getEachReferenceTypeWithProperty(prop)) {
                actions2.addAll(this.getImplicitActionsFromPropNonUnion(type, prop, fnNode));
            }
            return actions2;
        }

        private Collection<Action> getImplicitActionsFromPropNonUnion(ObjectType jsType, String prop, Node fnNode) {
            JSType propType = jsType.getPropertyType(prop).restrictByNotNullOrUndefined();
            if (jsType.isPropertyInExterns(prop) && propType.isFunctionType()) {
                ObjectType thisType = jsType;
                if (jsType.isFunctionPrototypeType()) {
                    thisType = thisType.getOwnerFunction().getInstanceType();
                }
                FunctionType callType = propType.toMaybeFunctionType();
                ExternFunctionCall action = this.createExternFunctionCall(fnNode, thisType, callType);
                return Lists.newArrayList((Object[])new Action[]{action});
            }
            return Lists.newArrayList();
        }
    }

    private class NativeCallFunctionCall
    implements Action {
        private final Node receiver;
        private final String propName;
        private final Node firstArgument;

        NativeCallFunctionCall(Node receiver, String propName, Node firstArgument) {
            this.receiver = receiver;
            this.propName = propName;
            this.firstArgument = firstArgument;
            Preconditions.checkNotNull((Object)receiver);
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope scope) {
            ConcreteType thisType = this.firstArgument != null ? TightenTypes.this.inferConcreteType(scope, this.firstArgument) : TightenTypes.this.getTopScope().getTypeOfThis();
            ConcreteType recvType = TightenTypes.this.inferConcreteType(scope, this.receiver);
            if (recvType instanceof ConcreteType.ConcreteInstanceType && ((ConcreteType.ConcreteInstanceType)recvType).isFunctionPrototype()) {
                recvType = thisType.getPropertyType(this.propName);
            }
            ArrayList argTypes = Lists.newArrayList();
            for (Node arg = this.firstArgument.getNext(); arg != null; arg = arg.getNext()) {
                argTypes.add(TightenTypes.this.inferConcreteType(scope, arg));
            }
            return TightenTypes.this.getFunctionCallAssignments(recvType, thisType, argTypes);
        }
    }

    private class FunctionCall
    implements Action {
        private final boolean isNewCall;
        private final Node receiver;
        private final String propName;
        private final Node firstArgument;

        FunctionCall(boolean isNewCall, Node receiver, String propName, Node firstArgument) {
            this.isNewCall = isNewCall;
            this.receiver = receiver;
            this.propName = propName;
            this.firstArgument = firstArgument;
            Preconditions.checkNotNull((Object)receiver);
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope scope) {
            ConcreteType thisType = ConcreteType.NONE;
            ConcreteType recvType = TightenTypes.this.inferConcreteType(scope, this.receiver);
            if (this.propName != null) {
                thisType = recvType;
                recvType = thisType.getPropertyType(this.propName);
            }
            if (recvType.isAll()) {
                throw new AssertionError((Object)"Found call on all type, which makes tighten types useless.");
            }
            if (this.isNewCall) {
                thisType = ConcreteType.NONE;
                for (ConcreteType.ConcreteInstanceType instType : recvType.getFunctionInstanceTypes()) {
                    thisType = thisType.unionWith(instType);
                }
                boolean added = TightenTypes.this.allInstantiatedTypes.add(thisType);
                if (added) {
                    TightenTypes.this.typeIntersectionMemos.clear();
                }
            }
            ArrayList argTypes = Lists.newArrayList();
            for (Node arg = this.firstArgument; arg != null; arg = arg.getNext()) {
                argTypes.add(TightenTypes.this.inferConcreteType(scope, arg));
            }
            return TightenTypes.this.getFunctionCallAssignments(recvType, thisType, argTypes);
        }
    }

    private class ExternFunctionCall
    implements Action {
        private Node receiver;
        private ConcreteType thisType;
        private List<ConcreteType> argTypes;

        ExternFunctionCall(Node receiver, ConcreteType thisType, List<ConcreteType> argTypes) {
            this.receiver = receiver;
            this.thisType = thisType;
            this.argTypes = argTypes;
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope scope) {
            return TightenTypes.this.getFunctionCallAssignments(TightenTypes.this.inferConcreteType(scope, this.receiver), this.thisType, this.argTypes);
        }
    }

    private class FunctionCallBuilder {
        private boolean isNewCall = false;
        private boolean isCallFunction = false;
        private final Node receiver;
        private final Node firstArgument;
        private String propName = null;

        FunctionCallBuilder(Node receiver, Node firstArgument) {
            this.receiver = receiver;
            this.firstArgument = firstArgument;
        }

        FunctionCallBuilder setPropName(String propName) {
            this.propName = propName;
            return this;
        }

        FunctionCallBuilder setIsNewCall(boolean isNew) {
            Preconditions.checkState((!this.isCallFunction || !isNew ? 1 : 0) != 0, (Object)"A function call cannot be of the form: new Object.call()");
            this.isNewCall = isNew;
            return this;
        }

        FunctionCallBuilder setIsCallFunction() {
            Preconditions.checkState((!this.isNewCall ? 1 : 0) != 0, (Object)"A function call cannot be of the form: new Object.call()");
            this.isCallFunction = true;
            return this;
        }

        Action build() {
            if (this.isCallFunction) {
                return new NativeCallFunctionCall(this.receiver, this.propName, this.firstArgument);
            }
            return new FunctionCall(this.isNewCall, this.receiver, this.propName, this.firstArgument);
        }
    }

    private class PropertyAssignAction
    implements Action {
        private final Node receiver;
        private final String propName;
        private final Node expression;

        PropertyAssignAction(Node receiver, Node expr) {
            this.receiver = receiver;
            this.propName = receiver.getNext().getString();
            this.expression = expr;
            Preconditions.checkNotNull((Object)receiver);
            Preconditions.checkNotNull((Object)this.propName);
            Preconditions.checkNotNull((Object)expr);
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope scope) {
            ConcreteType recvType = TightenTypes.this.inferConcreteType(scope, this.receiver);
            ConcreteType exprType = TightenTypes.this.inferConcreteType(scope, this.expression);
            ArrayList assigns = Lists.newArrayList();
            for (StaticSlot<ConcreteType> prop : recvType.getPropertySlots(this.propName)) {
                assigns.add(new Assignment((ConcreteSlot)prop, exprType));
            }
            return assigns;
        }
    }

    private class VariableAssignAction
    implements Action {
        private final ConcreteSlot slot;
        private final Node expression;

        VariableAssignAction(ConcreteSlot slot, Node expr) {
            this.slot = slot;
            this.expression = expr;
            Preconditions.checkNotNull((Object)slot);
            Preconditions.checkNotNull((Object)expr);
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope scope) {
            return Lists.newArrayList((Object[])new Assignment[]{new Assignment(this.slot, TightenTypes.this.inferConcreteType(scope, this.expression))});
        }
    }

    private static class Assignment {
        private final ConcreteSlot slot;
        private final ConcreteType type;

        Assignment(ConcreteSlot slot, ConcreteType type) {
            this.slot = slot;
            this.type = type;
            Preconditions.checkNotNull((Object)slot);
            Preconditions.checkNotNull((Object)type);
        }
    }

    private static interface Action {
        public Collection<Assignment> getAssignments(ConcreteScope var1);
    }

    static class ConcreteSlot
    implements StaticSlot<ConcreteType> {
        private final ConcreteScope scope;
        private final String name;
        private ConcreteType type;

        ConcreteSlot(ConcreteScope scope, String name) {
            this.scope = scope;
            this.name = name;
            this.type = ConcreteType.NONE;
        }

        ConcreteScope getScope() {
            return this.scope;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ConcreteType getType() {
            return this.type;
        }

        @Override
        public boolean isTypeInferred() {
            return true;
        }

        @Override
        public StaticReference<ConcreteType> getDeclaration() {
            return null;
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return null;
        }

        boolean addConcreteType(ConcreteType type) {
            ConcreteType origType = this.type;
            this.type = origType.unionWith(type);
            return !this.type.equals(origType);
        }

        public String toString() {
            return this.getName() + ": " + this.getType();
        }
    }

    class ConcreteScope
    implements StaticScope<ConcreteType> {
        private final ConcreteScope parent;
        private final Map<String, ConcreteSlot> slots;
        private final List<Action> actions;

        ConcreteScope(ConcreteScope parent) {
            this.parent = parent;
            this.slots = Maps.newHashMap();
            this.actions = Lists.newArrayList();
        }

        @Override
        public Node getRootNode() {
            return null;
        }

        @Override
        public StaticScope<ConcreteType> getParentScope() {
            return this.parent;
        }

        @Override
        public StaticSlot<ConcreteType> getOwnSlot(String name) {
            return this.slots.get(name);
        }

        @Override
        public StaticSlot<ConcreteType> getSlot(String name) {
            StaticSlot<ConcreteType> var = this.getOwnSlot(name);
            if (var != null) {
                return var;
            }
            if (this.parent != null) {
                return this.parent.getSlot(name);
            }
            return null;
        }

        Collection<ConcreteSlot> getSlots() {
            return this.slots.values();
        }

        @Override
        public ConcreteType getTypeOfThis() {
            ConcreteSlot thisVar = this.slots.get(":this");
            return thisVar != null ? thisVar.getType() : ConcreteType.NONE;
        }

        void declareSlot(String name, Node declaration) {
            this.slots.put(name, new ConcreteSlot(this, name));
        }

        void declareSlot(String name, Node declaration, ConcreteType type) {
            ConcreteSlot var = new ConcreteSlot(this, name);
            var.addConcreteType(type);
            this.slots.put(name, var);
        }

        List<Action> getActions() {
            return this.actions;
        }

        void initForScopeRoot(Node decl) {
            Preconditions.checkNotNull((Object)decl);
            if (decl.isFunction()) {
                decl = decl.getLastChild();
            }
            Preconditions.checkArgument((boolean)decl.isBlock());
            NodeTraversal.traverse(TightenTypes.this.compiler, decl, new CreateScope(this, false));
        }

        void initForExternRoot(Node decl) {
            Preconditions.checkNotNull((Object)decl);
            Preconditions.checkArgument((boolean)decl.isBlock());
            NodeTraversal.traverse(TightenTypes.this.compiler, decl, new CreateScope(this, true));
        }

        void addAction(Action action) {
            this.actions.add(action);
        }

        public String toString() {
            return this.getTypeOfThis().toString() + " " + this.getSlots();
        }
    }
}

