/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.graph;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.graph.Annotation;
import com.google.gwt.thirdparty.javascript.jscomp.graph.Graph;
import com.google.gwt.thirdparty.javascript.jscomp.graph.GraphNode;
import com.google.gwt.thirdparty.javascript.jscomp.graph.GraphvizGraph;
import com.google.gwt.thirdparty.javascript.jscomp.graph.SubGraph;
import com.google.gwt.thirdparty.javascript.jscomp.graph.UndiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LinkedUndirectedGraph<N, E>
extends UndiGraph<N, E>
implements GraphvizGraph {
    protected final Map<N, LinkedUndirectedGraphNode<N, E>> nodes = Maps.newHashMap();
    private final boolean useNodeAnnotations;
    private final boolean useEdgeAnnotations;

    @Override
    public SubGraph<N, E> newSubGraph() {
        return new Graph.SimpleSubGraph(this);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> createWithoutAnnotations() {
        return new LinkedUndirectedGraph<N, E>(false, false);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> createWithNodeAnnotations() {
        return new LinkedUndirectedGraph<N, E>(true, false);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> createWithEdgeAnnotations() {
        return new LinkedUndirectedGraph<N, E>(false, true);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> create() {
        return new LinkedUndirectedGraph<N, E>(true, true);
    }

    protected LinkedUndirectedGraph(boolean useNodeAnnotations, boolean useEdgeAnnotations) {
        this.useNodeAnnotations = useNodeAnnotations;
        this.useEdgeAnnotations = useEdgeAnnotations;
    }

    @Override
    public void connect(N srcValue, E edgeValue, N destValue) {
        LinkedUndirectedGraphNode src = (LinkedUndirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedUndirectedGraphNode dest = (LinkedUndirectedGraphNode)this.getNodeOrFail(destValue);
        LinkedUndirectedGraphEdge edge = this.useEdgeAnnotations ? new AnnotatedLinkedUndirectedGraphEdge(src, edgeValue, dest) : new LinkedUndirectedGraphEdge(src, edgeValue, dest);
        src.getNeighborEdges().add(edge);
        dest.getNeighborEdges().add(edge);
    }

    @Override
    public void disconnect(N srcValue, N destValue) {
        LinkedUndirectedGraphNode src = (LinkedUndirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedUndirectedGraphNode dest = (LinkedUndirectedGraphNode)this.getNodeOrFail(destValue);
        for (UndiGraph.UndiGraphEdge<N, E> edge : this.getUndirectedGraphEdges(srcValue, destValue)) {
            src.getNeighborEdges().remove(edge);
            dest.getNeighborEdges().remove(edge);
        }
    }

    @Override
    public UndiGraph.UndiGraphNode<N, E> createUndirectedGraphNode(N nodeValue) {
        LinkedUndirectedGraphNode<N, E> node = this.nodes.get(nodeValue);
        if (node == null) {
            node = this.useNodeAnnotations ? new AnnotatedLinkedUndirectedGraphNode(nodeValue) : new LinkedUndirectedGraphNode(nodeValue);
            this.nodes.put(nodeValue, node);
        }
        return node;
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(N value) {
        ArrayList nodeList = Lists.newArrayList();
        Iterator<GraphNode<N, E>> i = this.getNeighborNodesIterator(value);
        while (i.hasNext()) {
            nodeList.add(i.next());
        }
        return nodeList;
    }

    @Override
    public Iterator<GraphNode<N, E>> getNeighborNodesIterator(N value) {
        UndiGraph.UndiGraphNode<N, E> uNode = this.getUndirectedGraphNode(value);
        Preconditions.checkNotNull(uNode, (String)"%s should be in the graph.", (Object[])new Object[]{value});
        return ((LinkedUndirectedGraphNode)uNode).neighborIterator();
    }

    @Override
    public List<UndiGraph.UndiGraphEdge<N, E>> getUndirectedGraphEdges(N n1, N n2) {
        UndiGraph.UndiGraphNode dNode1 = this.nodes.get(n1);
        if (dNode1 == null) {
            return null;
        }
        UndiGraph.UndiGraphNode dNode2 = this.nodes.get(n2);
        if (dNode2 == null) {
            return null;
        }
        ArrayList edges = Lists.newArrayList();
        for (UndiGraph.UndiGraphEdge outEdge : dNode1.getNeighborEdges()) {
            if (outEdge.getNodeA() != dNode2 && outEdge.getNodeB() != dNode2) continue;
            edges.add(outEdge);
        }
        return edges;
    }

    @Override
    public UndiGraph.UndiGraphNode<N, E> getUndirectedGraphNode(N nodeValue) {
        return this.nodes.get(nodeValue);
    }

    @Override
    public Collection<UndiGraph.UndiGraphNode<N, E>> getUndirectedGraphNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public GraphNode<N, E> createNode(N value) {
        return this.createUndirectedGraphNode(value);
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges(N n1, N n2) {
        return Collections.unmodifiableList(this.getUndirectedGraphEdges(n1, n2));
    }

    @Override
    public Graph.GraphEdge<N, E> getFirstEdge(N n1, N n2) {
        UndiGraph.UndiGraphNode dNode1 = (UndiGraph.UndiGraphNode)this.getNodeOrFail(n1);
        UndiGraph.UndiGraphNode dNode2 = (UndiGraph.UndiGraphNode)this.getNodeOrFail(n2);
        for (UndiGraph.UndiGraphEdge outEdge : dNode1.getNeighborEdges()) {
            if (outEdge.getNodeA() != dNode2 && outEdge.getNodeB() != dNode2) continue;
            return outEdge;
        }
        return null;
    }

    @Override
    public GraphNode<N, E> getNode(N value) {
        return this.getUndirectedGraphNode(value);
    }

    @Override
    public boolean isConnected(N n1, N n2) {
        return this.isConnected(n1, Predicates.alwaysTrue(), n2);
    }

    @Override
    public boolean isConnected(N n1, E e, N n2) {
        return this.isConnected(n1, Predicates.equalTo(e), n2);
    }

    @Override
    private boolean isConnected(N n1, Predicate<E> edgePredicate, N n2) {
        UndiGraph.UndiGraphNode dNode1 = this.nodes.get(n1);
        if (dNode1 == null) {
            return false;
        }
        UndiGraph.UndiGraphNode dNode2 = this.nodes.get(n2);
        if (dNode2 == null) {
            return false;
        }
        for (UndiGraph.UndiGraphEdge outEdge : dNode1.getNeighborEdges()) {
            if ((outEdge.getNodeA() != dNode1 || outEdge.getNodeB() != dNode2) && (outEdge.getNodeA() != dNode2 || outEdge.getNodeB() != dNode1) || !edgePredicate.apply(outEdge.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GraphvizGraph.GraphvizEdge> getGraphvizEdges() {
        ArrayList edgeList = Lists.newArrayList();
        for (LinkedUndirectedGraphNode<N, E> node : this.nodes.values()) {
            for (UndiGraph.UndiGraphEdge<N, E> edge : node.getNeighborEdges()) {
                if (edge.getNodeA() != node) continue;
                edgeList.add((GraphvizGraph.GraphvizEdge)((Object)edge));
            }
        }
        return edgeList;
    }

    @Override
    public String getName() {
        return "LinkedUndirectedGraph";
    }

    @Override
    public List<GraphvizGraph.GraphvizNode> getGraphvizNodes() {
        ArrayList nodeList = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (LinkedUndirectedGraphNode<N, E> node : this.nodes.values()) {
            nodeList.add(node);
        }
        return nodeList;
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public Collection<GraphNode<N, E>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges() {
        ArrayList result = Lists.newArrayList();
        for (LinkedUndirectedGraphNode<N, E> node : this.nodes.values()) {
            for (UndiGraph.UndiGraphEdge<N, E> edge : node.getNeighborEdges()) {
                if (edge.getNodeA() != node) continue;
                result.add(edge);
            }
        }
        return result;
    }

    @Override
    public int getNodeDegree(N value) {
        UndiGraph.UndiGraphNode<N, E> uNode = this.getUndirectedGraphNode(value);
        if (uNode == null) {
            throw new IllegalArgumentException(value + " not found in graph");
        }
        return uNode.getNeighborEdges().size();
    }

    static class AnnotatedLinkedUndirectedGraphEdge<N, E>
    extends LinkedUndirectedGraphEdge<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedUndirectedGraphEdge(UndiGraph.UndiGraphNode<N, E> nodeA, E edgeValue, UndiGraph.UndiGraphNode<N, E> nodeB) {
            super(nodeA, edgeValue, nodeB);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    static class LinkedUndirectedGraphEdge<N, E>
    implements UndiGraph.UndiGraphEdge<N, E>,
    GraphvizGraph.GraphvizEdge {
        private UndiGraph.UndiGraphNode<N, E> nodeA;
        private UndiGraph.UndiGraphNode<N, E> nodeB;
        protected final E value;

        LinkedUndirectedGraphEdge(UndiGraph.UndiGraphNode<N, E> nodeA, E edgeValue, UndiGraph.UndiGraphNode<N, E> nodeB) {
            this.value = edgeValue;
            this.nodeA = nodeA;
            this.nodeB = nodeB;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public GraphNode<N, E> getNodeA() {
            return this.nodeA;
        }

        @Override
        public GraphNode<N, E> getNodeB() {
            return this.nodeB;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public String getColor() {
            return "black";
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        @Override
        public String getNode1Id() {
            return ((LinkedUndirectedGraphNode)this.nodeA).getId();
        }

        @Override
        public String getNode2Id() {
            return ((LinkedUndirectedGraphNode)this.nodeB).getId();
        }

        public String toString() {
            return this.nodeA.toString() + " -- " + this.nodeB.toString();
        }
    }

    static class AnnotatedLinkedUndirectedGraphNode<N, E>
    extends LinkedUndirectedGraphNode<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedUndirectedGraphNode(N nodeValue) {
            super(nodeValue);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    static class LinkedUndirectedGraphNode<N, E>
    implements UndiGraph.UndiGraphNode<N, E>,
    GraphvizGraph.GraphvizNode {
        private List<UndiGraph.UndiGraphEdge<N, E>> neighborList = Lists.newArrayList();
        private final N value;

        LinkedUndirectedGraphNode(N nodeValue) {
            this.value = nodeValue;
        }

        @Override
        public List<UndiGraph.UndiGraphEdge<N, E>> getNeighborEdges() {
            return this.neighborList;
        }

        @Override
        public Iterator<UndiGraph.UndiGraphEdge<N, E>> getNeighborEdgesIterator() {
            return this.neighborList.iterator();
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public String getColor() {
            return "white";
        }

        @Override
        public String getId() {
            return "LDN" + this.hashCode();
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        public Iterator<GraphNode<N, E>> neighborIterator() {
            return new NeighborIterator();
        }

        private class NeighborIterator
        implements Iterator<GraphNode<N, E>> {
            private final Iterator<UndiGraph.UndiGraphEdge<N, E>> edgeIterator;

            private NeighborIterator() {
                this.edgeIterator = LinkedUndirectedGraphNode.this.neighborList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.edgeIterator.hasNext();
            }

            @Override
            public GraphNode<N, E> next() {
                UndiGraph.UndiGraphEdge edge = this.edgeIterator.next();
                if (edge.getNodeA() == LinkedUndirectedGraphNode.this) {
                    return edge.getNodeB();
                }
                return edge.getNodeA();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        }
    }
}

