/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.server;

import java.io.Serializable;
import java.util.function.Consumer;

/**
 * A {@link Consumer} that is also {@link Serializable}.
 *
 * @see Consumer
 * @param <T>
 *            the type of the first argument to the operation
 *
 * @since 8.0
 * @author Vaadin Ltd
 *
 */
@FunctionalInterface
public interface SerializableConsumer<T> extends Consumer<T>, Serializable {
    // Only method inherited from Consumer
}
