/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiFunction;

import com.vaadin.data.BinderValidationStatus;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;

/**
 * Generator for creating editor validation and conversion error messages.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @param <T>
 *            the bean type
 */
@FunctionalInterface
public interface EditorErrorGenerator<T> extends Serializable,
        BiFunction<Map<Component, Grid.Column<T, ?>>, BinderValidationStatus<T>, String> {

    /**
     * Generates an error message from given validation status object.
     *
     * @param fieldToColumn
     *            the map of failed fields and corresponding columns
     * @param status
     *            the binder status object with all failures
     *
     * @return error message string
     */
    @Override
    public String apply(Map<Component, Grid.Column<T, ?>> fieldToColumn,
            BinderValidationStatus<T> status);
}
