/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.optiongroup;

import com.vaadin.shared.annotations.DelegateToWidget;
import com.vaadin.shared.ui.abstractmultiselect.AbstractMultiSelectState;

/**
 * Shared state for the CheckBoxGroup component.
 *
 * @author Vaadin Ltd.
 * @since 8.0
 */
public class CheckBoxGroupState extends AbstractMultiSelectState {

    {
        primaryStyleName = "v-select-optiongroup";
    }

    @DelegateToWidget
    public boolean htmlContentAllowed = false;
}
