/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jportmap;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.apps.jportmap.jportmap;

public class OncRpcEmbeddedPortmap {
    protected embeddedjportmap embeddedPortmap;
    protected Thread embeddedPortmapThread;

    public OncRpcEmbeddedPortmap() throws OncRpcException, IOException {
        this(3000);
    }

    public OncRpcEmbeddedPortmap(int checkTimeout) throws OncRpcException, IOException {
        if (!OncRpcEmbeddedPortmap.isPortmapRunning(checkTimeout)) {
            this.embeddedPortmap = new embeddedjportmap();
            this.embeddedPortmap.serviceThread = this.embeddedPortmapThread = new OncRpcEmbeddedPortmapThread(this.embeddedPortmap);
            this.embeddedPortmapThread.start();
        }
    }

    public static boolean isPortmapRunning() {
        return OncRpcEmbeddedPortmap.isPortmapRunning(3000);
    }

    public static boolean isPortmapRunning(int checkTimeout) {
        boolean available = false;
        try {
            OncRpcPortmapClient portmap = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
            portmap.getOncRpcClient().setTimeout(checkTimeout);
            portmap.ping();
            available = true;
        }
        catch (OncRpcException oncRpcException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return available;
    }

    public boolean embeddedPortmapInUse() {
        return this.embeddedPortmapThread != null;
    }

    public Thread getEmbeddedPortmapServiceThread() {
        return this.embeddedPortmapThread;
    }

    public jportmap getEmbeddedPortmap() {
        return this.embeddedPortmap;
    }

    public void shutdown() {
        embeddedjportmap portmap = this.embeddedPortmap;
        if (portmap != null) {
            portmap.stopRpcProcessing();
        }
    }

    class OncRpcEmbeddedPortmapThread
    extends Thread {
        private embeddedjportmap portmap;

        public OncRpcEmbeddedPortmapThread(embeddedjportmap portmap) {
            super("embedded portmap service thread");
            this.portmap = portmap;
        }

        public void run() {
            try {
                this.portmap.run(this.portmap.transports);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.portmap.close(this.portmap.transports);
            this.portmap.serviceThread = null;
        }
    }

    class embeddedjportmap
    extends jportmap {
        protected Thread serviceThread;

        XdrBoolean unsetPort(OncRpcServerIdent params) {
            XdrBoolean ok = super.unsetPort(params);
            if (ok.booleanValue()) {
                boolean onlyPmap = true;
                int size = this.servers.size();
                for (int idx = 0; idx < size; ++idx) {
                    if (((OncRpcServerIdent)this.servers.elementAt((int)idx)).program == 100000) continue;
                    onlyPmap = false;
                    break;
                }
                if (onlyPmap && this.serviceThread != null) {
                    this.stopRpcProcessing();
                }
            }
            return ok;
        }
    }
}

