/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.checkout;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.checkout.ClearCaseCheckOutConsumer;
import org.apache.maven.scm.provider.clearcase.repository.ClearCaseScmProviderRepository;
import org.apache.maven.scm.providers.clearcase.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseCheckOutCommand
extends AbstractCheckOutCommand
implements ClearCaseCommand {
    private Settings settings = null;

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        int exitCode;
        Commandline cl;
        this.getLogger().debug("executing checkout command...");
        ClearCaseScmProviderRepository repo = (ClearCaseScmProviderRepository)repository;
        File workingDirectory = fileSet.getBasedir();
        this.getLogger().debug(version.getType() + ": " + version.getName());
        this.getLogger().debug("Running with CLEARCASE " + this.settings.getClearcaseType());
        ClearCaseCheckOutConsumer consumer = new ClearCaseCheckOutConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        String projectDirectory = "";
        try {
            FileUtils.deleteDirectory((File)workingDirectory);
            String viewName = this.getUniqueViewName(repo, workingDirectory.getAbsolutePath());
            String streamIdentifier = this.getStreamIdentifier(repo.getStreamName(), repo.getVobName());
            cl = this.createCreateViewCommandLine(workingDirectory, viewName, streamIdentifier);
            this.getLogger().info("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr);
            if (exitCode == 0) {
                File configSpecLocation;
                if (!repo.isAutoConfigSpec()) {
                    configSpecLocation = repo.getConfigSpec();
                    if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
                        throw new UnsupportedOperationException("Building on a label not supported with user-specified config specs");
                    }
                } else {
                    String configSpec = this.createConfigSpec(repo.getLoadDirectory(), version);
                    this.getLogger().info("Created config spec for view '" + viewName + "':\n" + configSpec);
                    configSpecLocation = this.writeTemporaryConfigSpecFile(configSpec, viewName);
                    projectDirectory = repo.getLoadDirectory();
                    if (projectDirectory.startsWith("/")) {
                        projectDirectory = projectDirectory.substring(1);
                    }
                }
                cl = this.createUpdateConfigSpecCommandLine(workingDirectory, configSpecLocation, viewName);
                this.getLogger().info("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
                exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
            }
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ScmException("Error while deleting working directory.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), consumer.getCheckedOutFiles(), projectDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeTemporaryConfigSpecFile(String configSpecContents, String viewName) throws IOException {
        File configSpecLocation = File.createTempFile("configspec-" + viewName, ".txt");
        FileWriter fw = new FileWriter(configSpecLocation);
        try {
            fw.write(configSpecContents);
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException e) {}
        }
        configSpecLocation.deleteOnExit();
        return configSpecLocation;
    }

    protected String createConfigSpec(String loadDirectory, ScmVersion version) {
        StringBuffer configSpec = new StringBuffer();
        configSpec.append("element * CHECKEDOUT\n");
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            configSpec.append("element * " + version.getName() + "\n");
            configSpec.append("element -directory * /main/LATEST\n");
        } else {
            configSpec.append("element * /main/LATEST\n");
        }
        configSpec.append("load " + loadDirectory + "\n");
        return configSpec.toString();
    }

    protected Commandline createCreateViewCommandLine(File workingDirectory, String viewName, String streamIdentifier) throws IOException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(workingDirectory.getParentFile().getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("mkview");
        command.createArgument().setValue("-snapshot");
        command.createArgument().setValue("-tag");
        command.createArgument().setValue(viewName);
        if (this.isClearCaseUCM()) {
            command.createArgument().setValue("-stream");
            command.createArgument().setValue(streamIdentifier);
        }
        if (!this.isClearCaseLT() && this.useVWS()) {
            command.createArgument().setValue("-vws");
            command.createArgument().setValue(this.getViewStore() + viewName + ".vws");
        }
        command.createArgument().setValue(workingDirectory.getCanonicalPath());
        return command;
    }

    protected String getStreamIdentifier(String streamName, String vobName) {
        if (streamName == null || vobName == null) {
            return null;
        }
        return "stream:" + streamName + "@" + vobName;
    }

    protected Commandline createUpdateConfigSpecCommandLine(File workingDirectory, File configSpecLocation, String viewName) {
        Commandline command = new Commandline();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("setcs");
        command.createArgument().setValue("-tag");
        command.createArgument().setValue(viewName);
        command.createArgument().setValue(configSpecLocation.getAbsolutePath());
        return command;
    }

    private String getUniqueViewName(ClearCaseScmProviderRepository repository, String absolutePath) {
        int lastIndexBack = absolutePath.lastIndexOf(92);
        int lastIndexForward = absolutePath.lastIndexOf(47);
        String uniqueId = lastIndexBack != -1 ? absolutePath.substring(lastIndexBack + 1) : absolutePath.substring(lastIndexForward + 1);
        return repository.getViewName(uniqueId);
    }

    protected String getViewStore() {
        String result = null;
        if (this.settings.getViewstore() != null) {
            result = this.settings.getViewstore();
        }
        if (result == null) {
            result = "\\\\" + this.getHostName() + "\\viewstore\\";
        } else if (this.isClearCaseLT()) {
            result = result + this.getUserName() + "\\";
        }
        return result;
    }

    protected boolean isClearCaseLT() {
        return "LT".equals(this.settings.getClearcaseType());
    }

    protected boolean isClearCaseUCM() {
        return "UCM".equals(this.settings.getClearcaseType());
    }

    protected boolean useVWS() {
        return this.settings.isUseVWSParameter();
    }

    private String getHostName() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return hostname;
    }

    private String getUserName() {
        String username = System.getProperty("user.name");
        return username;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

