/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;

public class HgConsumer
extends AbstractConsumer {
    private static final Map identifiers = new HashMap();
    private static final Map messages = new HashMap();
    private static final int MAX_STDERR_SIZE = 10;
    private final List stderr = new ArrayList();

    public HgConsumer(ScmLogger logger) {
        super(logger);
    }

    public void doConsume(ScmFileStatus status, String trimmedLine) {
    }

    public void consumeLine(String line) {
        this.getLogger().debug(line);
        String trimmedLine = line.trim();
        String statusStr = HgConsumer.processInputForKnownIdentifiers(trimmedLine);
        if (statusStr == null) {
            boolean isMessage = this.processInputForKnownMessages(trimmedLine);
            if (isMessage) {
                return;
            }
        } else {
            trimmedLine = trimmedLine.substring(statusStr.length());
            trimmedLine = trimmedLine.trim();
        }
        ScmFileStatus status = statusStr != null ? (ScmFileStatus)identifiers.get(statusStr.intern()) : null;
        this.doConsume(status, trimmedLine);
    }

    public String getStdErr() {
        String str = "";
        Iterator it = this.stderr.iterator();
        while (it.hasNext()) {
            str = str + it.next();
        }
        return str;
    }

    private static String processInputForKnownIdentifiers(String line) {
        Iterator it = identifiers.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            if (!line.startsWith(id)) continue;
            return id;
        }
        return null;
    }

    private boolean processInputForKnownMessages(String line) {
        Iterator it = messages.keySet().iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            if (!line.startsWith(prefix)) continue;
            this.stderr.add(line);
            if (this.stderr.size() > 10) {
                this.stderr.remove(0);
            }
            String message = line.substring(prefix.length());
            if (messages.get(prefix).equals("WARNING")) {
                this.getLogger().warn(message);
            } else {
                this.getLogger().error(message);
            }
            return true;
        }
        return false;
    }

    static {
        identifiers.put("adding", ScmFileStatus.ADDED);
        identifiers.put("unknown", ScmFileStatus.UNKNOWN);
        identifiers.put("modified", ScmFileStatus.MODIFIED);
        identifiers.put("removed", ScmFileStatus.DELETED);
        identifiers.put("renamed", ScmFileStatus.MODIFIED);
        identifiers.put("A", ScmFileStatus.ADDED);
        identifiers.put("?", ScmFileStatus.UNKNOWN);
        identifiers.put("M", ScmFileStatus.MODIFIED);
        identifiers.put("R", ScmFileStatus.DELETED);
        identifiers.put("I", ScmFileStatus.UNKNOWN);
        messages.put("hg: WARNING:", "WARNING");
        messages.put("hg: ERROR:", "ERROR");
        messages.put("'hg' ", "ERROR");
    }
}

