/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceInfoCommand
extends AbstractCommand
implements PerforceCommand {
    private static PerforceInfoCommand singleton = null;
    private Map entries = null;

    public static PerforceInfoCommand getInfo(AbstractCommand cmd, PerforceScmProviderRepository repo) {
        return PerforceInfoCommand.getSingleton(cmd, repo);
    }

    public String getEntry(String key) {
        return (String)this.entries.get(key);
    }

    private static synchronized PerforceInfoCommand getSingleton(AbstractCommand cmd, PerforceScmProviderRepository repo) {
        if (singleton == null) {
            PerforceInfoCommand pic = new PerforceInfoCommand();
            if (cmd != null) {
                pic.setLogger(cmd.getLogger());
            }
            try {
                pic.executeCommand((ScmProviderRepository)repo, null, null);
                singleton = pic;
            }
            catch (ScmException e) {
                pic.getLogger().error((Throwable)e);
            }
        }
        return singleton;
    }

    protected ScmResult executeCommand(ScmProviderRepository repo, ScmFileSet scmFileSet, CommandParameters commandParameters) throws ScmException {
        if (!PerforceScmProvider.isLive()) {
            return null;
        }
        boolean log = this.getLogger() != null;
        try {
            String line;
            Commandline command = PerforceScmProvider.createP4Command((PerforceScmProviderRepository)repo, null);
            command.createArgument().setValue("info");
            if (log) {
                this.getLogger().debug(PerforceScmProvider.clean("Executing: " + command.toString()));
            }
            Process proc = command.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            this.entries = new HashMap();
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(58);
                if (idx == -1) {
                    throw new IllegalStateException("Unexpected results from 'p4 info' command: " + line);
                }
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1).trim();
                this.entries.put(key, value);
            }
        }
        catch (CommandLineException e) {
            throw new ScmException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ScmException(e.getLocalizedMessage());
        }
        return null;
    }
}

