/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.changelog;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.changelog.PerforceChangeLogConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceChangeLogCommand
extends AbstractChangeLogCommand
implements PerforceCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        if (branch != null || StringUtils.isNotEmpty((String)branch.getName())) {
            throw new ScmException("This SCM doesn't support branches.");
        }
        PerforceScmProviderRepository p4repo = (PerforceScmProviderRepository)repo;
        String clientspec = PerforceScmProvider.getClientspecName(p4repo, fileSet.getBasedir());
        Commandline cl = PerforceChangeLogCommand.createCommandLine(p4repo, fileSet.getBasedir(), clientspec);
        String location = PerforceScmProvider.getRepoPath(this.getLogger(), p4repo, fileSet.getBasedir());
        PerforceChangeLogConsumer consumer = new PerforceChangeLogConsumer(location, startDate, endDate, datePattern, this.getLogger());
        try {
            String line;
            this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return new ChangeLogScmResult(cl.toString(), new ChangeLogSet(consumer.getModifications(), startDate, endDate));
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String clientspec) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        if (clientspec != null) {
            command.createArgument().setValue("-c");
            command.createArgument().setValue(clientspec);
        }
        command.createArgument().setValue("filelog");
        command.createArgument().setValue("-t");
        command.createArgument().setValue("-l");
        command.createArgument().setValue("...");
        return command;
    }
}

