/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class PerforceChangeLogConsumer
extends AbstractConsumer {
    private static final String PERFORCE_TIMESTAMP_PATTERN = "yyyy/MM/dd HH:mm:ss";
    private List entries = new ArrayList();
    private static final int GET_REVISION = 1;
    private static final int GET_COMMENT_BEGIN = 2;
    private static final int GET_COMMENT = 3;
    private static final String COMMENT_DELIMITER = "";
    private static final String FILE_BEGIN_TOKEN = "//";
    private int status = 1;
    private ChangeSet currentChange;
    private String currentFile;
    private String repoPath;
    private RE revisionRegexp;
    private Date startDate;
    private Date endDate;
    private String userDatePattern;
    private static final String pattern = "^\\.\\.\\. #(\\d+) change (\\d+) .* on (.*) by (.*)@";

    public PerforceChangeLogConsumer(String path, Date startDate, Date endDate, String userDatePattern, ScmLogger logger) {
        super(logger);
        this.startDate = startDate;
        this.endDate = endDate;
        this.userDatePattern = userDatePattern;
        this.repoPath = path;
        try {
            this.revisionRegexp = new RE(pattern);
        }
        catch (RESyntaxException ignored) {
            this.getLogger().error("Could not create regexp to parse perforce log file", (Throwable)ignored);
        }
    }

    public List getModifications() {
        return this.entries;
    }

    public void consumeLine(String line) {
        switch (this.status) {
            case 1: {
                this.processGetRevision(line);
                break;
            }
            case 2: {
                this.status = 3;
                break;
            }
            case 3: {
                this.processGetComment(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void addEntry(ChangeSet entry, ChangeFile file) {
        if (this.startDate != null && entry.getDate().before(this.startDate)) {
            return;
        }
        if (this.endDate != null && entry.getDate().after(this.endDate)) {
            return;
        }
        entry.addFile(file);
        this.entries.add(entry);
    }

    private void processGetRevision(String line) {
        if (line.startsWith(FILE_BEGIN_TOKEN)) {
            this.currentFile = line.substring(this.repoPath.length() + 1);
            return;
        }
        if (!this.revisionRegexp.match(line)) {
            return;
        }
        this.currentChange = new ChangeSet();
        this.currentChange.setDate(this.parseDate(this.revisionRegexp.getParen(3), this.userDatePattern, PERFORCE_TIMESTAMP_PATTERN));
        this.currentChange.setAuthor(this.revisionRegexp.getParen(4));
        this.status = 2;
    }

    private void processGetComment(String line) {
        if (line.equals(COMMENT_DELIMITER)) {
            this.addEntry(this.currentChange, new ChangeFile(this.currentFile, this.revisionRegexp.getParen(1)));
            this.status = 1;
        } else {
            this.currentChange.setComment(this.currentChange.getComment() + line + "\n");
        }
    }
}

