/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.branch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnBranchCommand
extends AbstractBranchCommand
implements SvnCommand {
    public ScmResult executeBranchCommand(ScmProviderRepository repo, ScmFileSet fileSet, String branch, String message) throws ScmException {
        int exitCode;
        if (branch == null || StringUtils.isEmpty((String)branch.trim())) {
            throw new ScmException("branch name must be specified");
        }
        if (fileSet.getFiles().length != 0) {
            throw new ScmException("This provider doesn't support branching subsets of a directory");
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            return new BranchScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        Commandline cl = SvnBranchCommand.createCommandLine(repository, fileSet.getBasedir(), branch, messageFile);
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = SvnCommandLineUtils.execute(cl, stdout, stderr, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new BranchScmResult(cl.toString(), "The svn branch command failed.", stderr.getOutput(), false);
        }
        ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
        List files = null;
        try {
            files = FileUtils.getFiles((File)fileSet.getBasedir(), (String)"**", (String)"**/.svn/**", (boolean)false);
        }
        catch (IOException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
        }
        return new BranchScmResult(cl.toString(), fileList);
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String branch, File messageFile) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArgument().setValue("copy");
        cl.createArgument().setValue("--file");
        cl.createArgument().setValue(messageFile.getAbsolutePath());
        cl.createArgument().setValue(".");
        String branchUrl = SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)repository, (ScmBranch)new ScmBranch(branch));
        cl.createArgument().setValue(SvnCommandUtils.fixUrl((String)branchUrl, (String)repository.getUser()));
        return cl;
    }
}

