/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.util.bcel.classfile.Annotations;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.bcel.classfile.Utility;

public final class ClassParser {
    private static final int MAGIC = -889275714;
    private final DataInput file;
    private String class_name;
    private String superclass_name;
    private int access_flags;
    private String[] interface_names;
    private ConstantPool constant_pool;
    private Annotations runtimeVisibleAnnotations;
    private static final int BUFSIZE = 8192;
    private static final String[] INTERFACES_EMPTY_ARRAY = new String[0];

    public ClassParser(InputStream file) {
        this.file = new DataInputStream(new BufferedInputStream(file, 8192));
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        this.readID();
        this.readVersion();
        this.readConstantPool();
        this.readClassInfo();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        this.readAttributes();
        return new JavaClass(this.class_name, this.superclass_name, this.access_flags, this.constant_pool, this.interface_names, this.runtimeVisibleAnnotations);
    }

    private void readAttributes() throws IOException, ClassFormatException {
        int attributes_count = this.file.readUnsignedShort();
        for (int i = 0; i < attributes_count; ++i) {
            int name_index = this.file.readUnsignedShort();
            ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(name_index, (byte)1);
            String name = c.getBytes();
            int length = this.file.readInt();
            if (name.equals("RuntimeVisibleAnnotations")) {
                if (this.runtimeVisibleAnnotations != null) {
                    throw new ClassFormatException("RuntimeVisibleAnnotations attribute is not allowed more than once in a class file");
                }
                this.runtimeVisibleAnnotations = new Annotations(this.file, this.constant_pool);
                continue;
            }
            Utility.skipFully(this.file, length);
        }
    }

    private void readClassInfo() throws IOException, ClassFormatException {
        this.access_flags = this.file.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatException("Class can't be both final and abstract");
        }
        int class_name_index = this.file.readUnsignedShort();
        this.class_name = Utility.getClassName(this.constant_pool, class_name_index);
        int superclass_name_index = this.file.readUnsignedShort();
        this.superclass_name = superclass_name_index > 0 ? Utility.getClassName(this.constant_pool, superclass_name_index) : "java.lang.Object";
    }

    private void readConstantPool() throws IOException, ClassFormatException {
        this.constant_pool = new ConstantPool(this.file);
    }

    private void readFields() throws IOException, ClassFormatException {
        int fields_count = this.file.readUnsignedShort();
        for (int i = 0; i < fields_count; ++i) {
            Utility.swallowFieldOrMethod(this.file);
        }
    }

    private void readID() throws IOException, ClassFormatException {
        if (this.file.readInt() != -889275714) {
            throw new ClassFormatException("It is not a Java .class file");
        }
    }

    private void readInterfaces() throws IOException, ClassFormatException {
        int interfaces_count = this.file.readUnsignedShort();
        if (interfaces_count > 0) {
            this.interface_names = new String[interfaces_count];
            for (int i = 0; i < interfaces_count; ++i) {
                int index = this.file.readUnsignedShort();
                this.interface_names[i] = Utility.getClassName(this.constant_pool, index);
            }
        } else {
            this.interface_names = INTERFACES_EMPTY_ARRAY;
        }
    }

    private void readMethods() throws IOException, ClassFormatException {
        int methods_count = this.file.readUnsignedShort();
        for (int i = 0; i < methods_count; ++i) {
            Utility.swallowFieldOrMethod(this.file);
        }
    }

    private void readVersion() throws IOException, ClassFormatException {
        Utility.skipFully(this.file, 4);
    }
}

