/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.codehaus.mojo.keytool.CommandLineConfigurationException;
import org.codehaus.mojo.keytool.DefaultKeyToolResult;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolCommandLineBuilder;
import org.codehaus.mojo.keytool.KeyToolException;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.KeyToolResult;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DefaultKeyTool
extends AbstractLogEnabled
implements KeyTool {
    protected String keyToolFile;
    protected KeyToolCommandLineBuilder builder;

    public KeyToolResult execute(KeyToolRequest request) throws KeyToolException {
        if (this.keyToolFile == null) {
            try {
                this.keyToolFile = this.findKeyToolExecutable();
            }
            catch (IOException e) {
                throw new KeyToolException("Error finding key tool executable. Reason: " + e.getMessage(), e);
            }
        }
        Commandline cli = this.createCommandLine(request);
        return this.executeCommandLine(cli, request);
    }

    protected Commandline createCommandLine(KeyToolRequest request) throws KeyToolException {
        Commandline cli;
        this.builder.setLogger(this.getLogger());
        this.builder.setKeyToolFile(this.keyToolFile);
        try {
            cli = this.builder.build(request);
        }
        catch (CommandLineConfigurationException e) {
            throw new KeyToolException("Error configuring command-line. Reason: " + e.getMessage(), e);
        }
        return cli;
    }

    protected KeyToolResult executeCommandLine(Commandline cli, KeyToolRequest request) {
        StreamConsumer systemErr;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cli);
        }
        final boolean verbose = request.isVerbose();
        InputStream systemIn = new InputStream(){

            public int read() {
                return -1;
            }
        };
        StreamConsumer systemOut = request.getSystemOutStreamConsumer();
        if (systemOut == null) {
            systemOut = new StreamConsumer(){

                public void consumeLine(String line) {
                    if (verbose) {
                        DefaultKeyTool.this.getLogger().info(line);
                    } else {
                        DefaultKeyTool.this.getLogger().debug(line);
                    }
                }
            };
        }
        if ((systemErr = request.getSystemErrorStreamConsumer()) == null) {
            systemErr = new StreamConsumer(){

                public void consumeLine(String line) {
                    DefaultKeyTool.this.getLogger().warn(line);
                }
            };
        }
        DefaultKeyToolResult result = new DefaultKeyToolResult();
        result.setCommandline(cli);
        try {
            int resultCode = CommandLineUtils.executeCommandLine((Commandline)cli, (InputStream)systemIn, (StreamConsumer)systemOut, (StreamConsumer)systemErr);
            result.setExitCode(resultCode);
        }
        catch (CommandLineException e) {
            result.setExecutionException(e);
        }
        return result;
    }

    protected String findKeyToolExecutable() throws IOException {
        String command = "keytool" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String executable = this.findExecutable(command, System.getProperty("java.home"), new String[]{"../bin", "bin", "../sh"});
        if (executable == null) {
            try {
                Properties env = CommandLineUtils.getSystemEnvVars();
                String[] variables = new String[]{"JDK_HOME", "JAVA_HOME"};
                for (int i = 0; i < variables.length && executable == null; ++i) {
                    executable = this.findExecutable(command, env.getProperty(variables[i]), new String[]{"bin", "sh"});
                }
            }
            catch (IOException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().warn("Failed to retrieve environment variables, cannot search for " + command, (Throwable)e);
                }
                this.getLogger().warn("Failed to retrieve environment variables, cannot search for " + command);
            }
        }
        if (executable == null) {
            executable = command;
        }
        return executable;
    }

    protected String findExecutable(String command, String homeDir, String[] subDirs) {
        if (StringUtils.isNotEmpty((String)homeDir)) {
            for (String subDir : subDirs) {
                File file = new File(new File(homeDir, subDir), command);
                if (!file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }
}

