/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.hibernate.SharedSessionContract;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.MapSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicCollectionJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class CollectionJavaType<C>
extends AbstractClassJavaType<C> {
    private final CollectionSemantics<C, ?> semantics;

    public CollectionJavaType(Class<? extends C> type, CollectionSemantics<C, ?> semantics) {
        super(type);
        this.semantics = semantics;
    }

    public CollectionSemantics<C, ?> getSemantics() {
        return this.semantics;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return null;
    }

    @Override
    public JavaType<C> createJavaType(ParameterizedType parameterizedType, TypeConfiguration typeConfiguration) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType valueDescriptor = javaTypeRegistry.resolveDescriptor(actualTypeArguments[actualTypeArguments.length - 1]);
        switch (this.semantics.getCollectionClassification()) {
            case ARRAY: 
            case BAG: 
            case ID_BAG: 
            case LIST: 
            case SET: 
            case SORTED_SET: 
            case ORDERED_SET: {
                return new BasicCollectionJavaType(parameterizedType, valueDescriptor, this.semantics);
            }
        }
        return new UnknownBasicJavaType(parameterizedType, new MapMutabilityPlan((MapSemantics)this.semantics, javaTypeRegistry.resolveDescriptor(actualTypeArguments[0]), valueDescriptor));
    }

    @Override
    public C fromString(CharSequence string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> X unwrap(C value, Class<X> type, WrapperOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> C wrap(X value, WrapperOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean areEqual(C one, C another) {
        if (one == another) {
            return true;
        }
        if (one instanceof PersistentCollection) {
            PersistentCollection pc = (PersistentCollection)one;
            return pc.wasInitialized() && (pc.isWrapper(another) || pc.isDirectlyProvidedCollection(another));
        }
        if (another instanceof PersistentCollection) {
            PersistentCollection pc = (PersistentCollection)another;
            return pc.wasInitialized() && (pc.isWrapper(one) || pc.isDirectlyProvidedCollection(one));
        }
        return Objects.equals(one, another);
    }

    @Override
    public int extractHashCode(C x) {
        throw new UnsupportedOperationException();
    }

    private static class MapMutabilityPlan<C extends Map<K, V>, K, V>
    implements MutabilityPlan<C> {
        private final MapSemantics<C, K, V> semantics;
        private final MutabilityPlan<K> keyPlan;
        private final MutabilityPlan<V> valuePlan;

        public MapMutabilityPlan(MapSemantics<C, K, V> semantics, JavaType<K> keyType, JavaType<V> valueType) {
            this.semantics = semantics;
            this.keyPlan = keyType.getMutabilityPlan();
            this.valuePlan = valueType.getMutabilityPlan();
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public C deepCopy(C value) {
            if (value == null) {
                return null;
            }
            Map copy = (Map)this.semantics.instantiateRaw(value.size(), null);
            for (Map.Entry entry : value.entrySet()) {
                copy.put(this.keyPlan.deepCopy(entry.getKey()), this.valuePlan.deepCopy(entry.getValue()));
            }
            return (C)copy;
        }

        @Override
        public Serializable disassemble(C value, SharedSessionContract session) {
            return (Serializable)this.deepCopy(value);
        }

        @Override
        public C assemble(Serializable cached, SharedSessionContract session) {
            return (C)this.deepCopy((C)((Map)((Object)cached)));
        }
    }
}

