/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

public class SVNDate
extends Date {
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final Calendar CALENDAR;
    private static final char[] DATE_SEPARATORS;
    private int myMicroSeconds;

    private SVNDate(long time, int micro) {
        super(time + (long)(micro / 1000));
        this.myMicroSeconds = micro > 0 ? Math.abs(micro) % 1000 : 1000 - Math.abs(micro) % 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format() {
        String formatted = null;
        DateFormat dateFormat = FORMAT;
        synchronized (dateFormat) {
            formatted = FORMAT.format(this);
        }
        int micros = this.myMicroSeconds;
        int m1 = micros % 10;
        int m2 = micros / 10 % 10;
        int m3 = micros / 100;
        formatted = formatted + m3;
        formatted = formatted + m2;
        formatted = formatted + m1;
        formatted = formatted + 'Z';
        return formatted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNDate parseDatestamp(String str) throws SVNException {
        String segment;
        if (str == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_DATE);
            SVNErrorManager.error(err);
        }
        int index = 0;
        int startIndex = 0;
        int[] result = new int[7];
        int microseconds = 0;
        int timeZoneInd = -1;
        for (int charIndex = 0; index < DATE_SEPARATORS.length && charIndex < str.length(); ++charIndex) {
            if (str.charAt(charIndex) == '-') {
                if (index > 1) {
                    timeZoneInd = charIndex;
                }
            } else if (str.charAt(charIndex) == '+') {
                timeZoneInd = charIndex;
            }
            if (str.charAt(charIndex) != DATE_SEPARATORS[index] && (index != 5 || str.charAt(charIndex) != DATE_SEPARATORS[index + 1])) continue;
            if (index == 5 && str.charAt(charIndex) == DATE_SEPARATORS[index + 1]) {
                ++index;
            }
            if ((segment = str.substring(startIndex, charIndex)).length() == 0) {
                result[index] = 0;
            } else if (index + 1 < DATE_SEPARATORS.length) {
                result[index] = Integer.parseInt(segment);
            } else {
                result[index] = Integer.parseInt(segment.substring(0, Math.min(3, segment.length())));
                if (segment.length() > 3) {
                    microseconds = Integer.parseInt(segment.substring(3));
                }
            }
            startIndex = charIndex + 1;
            ++index;
        }
        if (index < DATE_SEPARATORS.length) {
            segment = str.substring(startIndex);
            result[index] = segment.length() == 0 ? 0 : Integer.parseInt(segment);
        }
        int year = result[0];
        int month = result[1];
        int date = result[2];
        int hour = result[3];
        int min = result[4];
        int sec = result[5];
        int ms = result[6];
        String timeZoneId = null;
        if (timeZoneInd != -1 && timeZoneInd < str.length() - 1 && str.indexOf(90) == -1 && str.indexOf(122) == -1) {
            timeZoneId = "GMT" + str.substring(timeZoneInd);
        }
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.clear();
            TimeZone oldTimeZone = null;
            if (timeZoneId != null) {
                oldTimeZone = CALENDAR.getTimeZone();
                CALENDAR.setTimeZone(TimeZone.getTimeZone(timeZoneId));
            } else if (str.indexOf(90) == -1 && str.indexOf(122) == -1) {
                oldTimeZone = CALENDAR.getTimeZone();
                CALENDAR.setTimeZone(TimeZone.getDefault());
            }
            CALENDAR.set(year, month - 1, date, hour, min, sec);
            CALENDAR.set(14, ms);
            SVNDate resultDate = new SVNDate(CALENDAR.getTimeInMillis(), microseconds);
            if (oldTimeZone != null) {
                CALENDAR.setTimeZone(oldTimeZone);
            }
            return resultDate;
        }
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myMicroSeconds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SVNDate) {
            SVNDate date = (SVNDate)obj;
            return this.getTime() == date.getTime() && this.myMicroSeconds == date.myMicroSeconds;
        }
        return super.equals(obj);
    }

    public boolean before(Date when) {
        if (super.equals(when) && when instanceof SVNDate) {
            return this.myMicroSeconds < ((SVNDate)when).myMicroSeconds;
        }
        return super.before(when);
    }

    public boolean after(Date when) {
        if (super.equals(when) && when instanceof SVNDate) {
            return this.myMicroSeconds > ((SVNDate)when).myMicroSeconds;
        }
        return super.after(when);
    }

    public int compareTo(Date anotherDate) {
        int result = super.compareTo(anotherDate);
        if (result == 0 && anotherDate instanceof SVNDate) {
            SVNDate date = (SVNDate)anotherDate;
            return this.myMicroSeconds < date.myMicroSeconds ? -1 : (this.myMicroSeconds == date.myMicroSeconds ? 0 : 1);
        }
        return result;
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("GMT"), new Locale("en", "US"));
        DATE_SEPARATORS = new char[]{'-', '-', 'T', ':', ':', '.', 'Z'};
    }
}

