/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequence;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class DefaultSVNMerger
implements ISVNMerger {
    private byte[] myStart;
    private byte[] mySeparator;
    private byte[] myEnd;

    public DefaultSVNMerger(byte[] start, byte[] sep, byte[] end) {
        this.myStart = start;
        this.mySeparator = sep;
        this.myEnd = end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType mergeText(File baseFile, File localFile, File latestFile, boolean dryRun, SVNDiffOptions options, OutputStream result) throws SVNException {
        FSMergerBySequence merger = new FSMergerBySequence(this.myStart, this.mySeparator, this.myEnd);
        int mergeResult = 0;
        RandomAccessFile localIS = null;
        RandomAccessFile latestIS = null;
        RandomAccessFile baseIS = null;
        try {
            localIS = new RandomAccessFile(localFile, "r");
            latestIS = new RandomAccessFile(latestFile, "r");
            baseIS = new RandomAccessFile(baseFile, "r");
            QSequenceLineRAFileData baseData = new QSequenceLineRAFileData(baseIS);
            QSequenceLineRAFileData localData = new QSequenceLineRAFileData(localIS);
            QSequenceLineRAFileData latestData = new QSequenceLineRAFileData(latestIS);
            mergeResult = merger.merge(baseData, localData, latestData, options, result);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            if (localIS != null) {
                try {
                    localIS.close();
                }
                catch (IOException e) {}
            }
            if (baseIS != null) {
                try {
                    baseIS.close();
                }
                catch (IOException e) {}
            }
            if (latestIS != null) {
                try {
                    latestIS.close();
                }
                catch (IOException e) {}
            }
        }
        SVNStatusType status = SVNStatusType.UNCHANGED;
        if (mergeResult == 2) {
            status = SVNStatusType.CONFLICTED;
        } else if (mergeResult == 4) {
            status = SVNStatusType.MERGED;
        }
        return status;
    }

    public SVNStatusType mergeBinary(File baseFile, File localFile, File latestFile, boolean dryRun, OutputStream out) throws SVNException {
        return SVNStatusType.CONFLICTED;
    }
}

