/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

public class SVNExternalInfo {
    private String myPath;
    private File myFile;
    private SVNURL myOldExternalURL;
    private long myOldExternalRevision;
    private SVNURL myNewExternalURL;
    private long myNewExternalRevision;
    private String myOwnerPath;

    public SVNExternalInfo(String dirPath, File file, String path, SVNURL oldURL, long oldRev) {
        this.myFile = file;
        this.myPath = path;
        this.myOwnerPath = dirPath;
        this.myOldExternalURL = oldURL;
        this.myOldExternalRevision = oldRev;
    }

    public String getOwnerPath() {
        return this.myOwnerPath;
    }

    public void setNewExternal(SVNURL newURL, long newRev) {
        this.myNewExternalRevision = newRev;
        this.myNewExternalURL = newURL;
    }

    public void setOldExternal(SVNURL oldURL, long oldRev) {
        this.myOldExternalRevision = oldRev;
        this.myOldExternalURL = oldURL;
    }

    public String getPath() {
        return this.myPath;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isModified() {
        return !this.isEquals();
    }

    private boolean isEquals() {
        if (this.myOldExternalURL == this.myNewExternalURL) {
            return this.myOldExternalRevision == this.myNewExternalRevision;
        }
        if (this.myOldExternalURL == null || this.myNewExternalURL == null) {
            return true;
        }
        if (this.myOldExternalURL.equals(this.myNewExternalURL)) {
            return this.myOldExternalRevision == this.myNewExternalRevision;
        }
        return false;
    }

    public long getNewRevision() {
        return this.myNewExternalRevision;
    }

    public SVNURL getNewURL() {
        return this.myNewExternalURL;
    }

    public SVNURL getOldURL() {
        return this.myOldExternalURL;
    }

    public long getOldRevision() {
        return this.myOldExternalRevision;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.myPath + " : ");
        sb.append(this.myNewExternalURL);
        if (this.myNewExternalRevision >= 0L) {
            sb.append("(" + this.myNewExternalRevision + ")");
        }
        if (this.isModified()) {
            sb.append(" [ ");
            sb.append(this.myOldExternalURL);
            if (this.myOldExternalRevision >= 0L) {
                sb.append("(" + this.myOldExternalRevision + ")");
            }
            sb.append(" ]");
        }
        return sb.toString();
    }

    public static void checkPath(String path) throws SVNException {
        File file = new File(path);
        if (file.isAbsolute()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid property 'svn:externals': target involves '.' or '..' or is absolute path");
            SVNErrorManager.error(err);
        }
        path = path.replace(File.separatorChar, '/');
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!"".equals(token) && !".".equals(token) && !"..".equals(token)) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid property 'svn:externals': target involves '.' or '..' or is absolute path");
            SVNErrorManager.error(err);
        }
    }
}

