/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;

public class SVNLogImpl
extends SVNLog {
    private File myFile;
    private File myTmpFile;

    public SVNLogImpl(File logFile, File tmpFile, SVNAdminArea adminArea) {
        super(adminArea);
        this.myFile = logFile;
        this.myTmpFile = tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws SVNException {
        if (this.myTmpFile == null || this.myCache == null) {
            return;
        }
        OutputStreamWriter os = null;
        try {
            os = new OutputStreamWriter(SVNFileUtil.openFileForWriting(this.myTmpFile), "UTF-8");
            for (Map command : this.myCache) {
                String name = (String)command.remove("");
                os.write("<");
                os.write(name);
                for (String attr : command.keySet()) {
                    String value = (String)command.get(attr);
                    if (value == null) {
                        value = "";
                    }
                    value = SVNEncodingUtil.xmlEncodeAttr(value);
                    os.write("\n   ");
                    os.write(attr);
                    os.write("=\"");
                    os.write(value);
                    os.write("\"");
                }
                os.write("/>\n");
            }
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write log file ''{0}'': {1}", new Object[]{this.myFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                this.myCache = null;
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
            this.myCache = null;
        }
        SVNFileUtil.closeFile(os);
        this.myCache = null;
        SVNFileUtil.rename(this.myTmpFile, this.myFile);
        SVNFileUtil.setReadonly(this.myFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection readCommands() throws SVNException {
        if (!this.myFile.exists()) {
            return null;
        }
        BufferedReader reader = null;
        ArrayList commands = new ArrayList();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.myFile), "UTF-8"));
            HashMap<String, String> attrs = new HashMap<String, String>();
            String name = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("<")) {
                    name = line.substring(1);
                    continue;
                }
                int index = line.indexOf(61);
                if (index > 0) {
                    String attrName = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (value.endsWith("/>")) {
                        value = value.substring(0, value.length() - "/>".length());
                    }
                    if (value.startsWith("\"")) {
                        value = value.substring(1);
                    }
                    if (value.endsWith("\"")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    if ("".equals(value = SVNEncodingUtil.xmlDecode(value)) && !"name".equals(attrName)) {
                        value = null;
                    }
                    attrs.put(attrName, value);
                }
                if (!line.endsWith("/>") || name == null) continue;
                attrs.put("", name);
                commands.add(attrs);
                attrs = new HashMap();
                name = null;
            }
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read log file ''{0}'': {1}", new Object[]{this.myFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(reader);
                throw throwable;
            }
            SVNFileUtil.closeFile(reader);
        }
        SVNFileUtil.closeFile(reader);
        return commands;
    }

    public String toString() {
        return "Log: " + this.myFile;
    }

    public void delete() throws SVNException {
        SVNFileUtil.deleteFile(this.myFile);
        SVNFileUtil.deleteFile(this.myTmpFile);
    }

    public boolean exists() {
        return this.myFile.exists();
    }
}

