/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Collections;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;

public class TableColumnCountWarning
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public String getName() {
        return "Check Table Column Count";
    }

    @Override
    public SeverityEnum getSeverity() {
        return SeverityEnum.MINOR;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "TableColumnLimit";
    }

    @Override
    public boolean internalEvaluate(ChangeSet object, DynamicRule dynamicRule) {
        object = ((ChangeSet)object).getChanges().iterator();
        while (object.hasNext()) {
            Integer n2;
            Change change = (Change)object.next();
            if (!(change instanceof CreateTableChange) || !this.doTableColumnCountCheck((CreateTableChange)change, n2 = (Integer)dynamicRule.getParameters().get(0).getValue())) continue;
            object = "columns";
            if (n2 == 1) {
                object = "column";
            }
            TableColumnCountWarning tableColumnCountWarning = this;
            return tableColumnCountWarning.setResultUnsuccessful(tableColumnCountWarning.generateErrorMessage(String.format("must not have more than %d %s.", n2, object)), dynamicRule);
        }
        return this.setResultSuccessful(true, dynamicRule);
    }

    private boolean doTableColumnCountCheck(CreateTableChange createTableChange, int n2) {
        return createTableChange.getColumns().size() > n2;
    }

    @Override
    public String getDescription() {
        return "Ensures that no table has more than a threshold number of columns.";
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    public List<DynamicRuleParameterEnum> getParameters() {
        return Collections.singletonList(DynamicRuleParameterEnum.MAX_COLUMNS);
    }
}

