/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license.pro;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import java.io.File;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.Location;
import liquibase.license.LocationType;
import liquibase.license.pro.Base64Source;
import liquibase.license.pro.DaticalTrueLicenseService$LicenseFileFilter;
import liquibase.license.pro.LicensingSchema;
import liquibase.logging.Logger;
import liquibase.pro.packaged.mI;
import liquibase.pro.packaged.mO;
import liquibase.pro.packaged.mQ;
import liquibase.pro.packaged.mU;
import liquibase.pro.packaged.mZ;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;

public class DaticalTrueLicenseService
implements LicenseService {
    private static final String INVALID_LICENSE_KEY_WARN = "WARNING!  You have specified an invalid license key.  Liquibase Pro features will remain disabled!";
    private static final String EXPIRED_LICENSE_KEY_WARN = "WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!";
    private static final String RENEW_MSG = "To renew Liquibase Pro please contact sales@liquibase.com or go to https://www.liquibase.org/download";
    private static final String LIQUIBASE_PRO_MSG = "Liquibase Pro %s by Datical licensed to %s until %s";
    private static final String LIQUIBASE_COMMUNITY_MSG = "Liquibase Community %s by Datical";
    private Map<String, mQ> managers = new HashMap<String, mQ>();
    private static boolean hasLoggedLicenseFailure = false;
    private String buildVersion;
    private boolean licenseInstalled = false;
    private String knownInvalidLicense;
    private boolean knownExpiredLicense = false;

    public DaticalTrueLicenseService() {
        this.addManager("Liquibase Pro");
        this.buildVersion = LiquibaseUtil.getBuildVersion();
    }

    private void addManager(String string) {
        mQ mQ2 = LicensingSchema.manager(string);
        this.managers.put(string, mQ2);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean licenseIsValid(String string) {
        if (string.equals(this.knownInvalidLicense)) {
            return false;
        }
        if (!this.licenseIsInstalled()) {
            return false;
        }
        Object object = Scope.getCurrentScope().getLog(this.getClass());
        try {
            mQ mQ2 = this.managers.get(string);
            if (mQ2 == null) {
                object.severe("Could not create LicenseConsumerManager");
                return false;
            }
            mQ2.i();
            return true;
        }
        catch (mU mU2) {
            if (!hasLoggedLicenseFailure) {
                hasLoggedLicenseFailure = true;
                object = String.format("License with subject '%s' is not valid. %s", string, mU2.getMessage());
                Scope.getCurrentScope().getLog(this.getClass()).severe((String)object);
                this.knownInvalidLicense = string;
            }
            return false;
        }
    }

    @Override
    public String getLicenseInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.daysTilExpiration();
        if (!this.licenseIsInstalled()) {
            stringBuilder.append(String.format(LIQUIBASE_COMMUNITY_MSG, this.buildVersion));
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder("\n\nLiquibase Community detected and ignored the following environment variables:\n");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("LIQUIBASE_HOME");
            hashSet.add("LIQUIBASE_PRO_LICENSE_KEY");
            for (String string : System.getenv().keySet()) {
                if (!string.toUpperCase().startsWith("LIQUIBASE_") || hashSet.contains(string.toUpperCase())) continue;
                stringBuilder2.append("- ").append(string).append("\n");
                bl2 = true;
            }
            stringBuilder2.append("To configure Liquibase with environment variables requires a Liquibase Pro license. Get a free trial at https://www.liquibase.com/protrial. Options include the liquibase.pro.licenseKey in the defaults file, adding a flag in the CLI, and more. Learn more at https://docs.liquibase.com.");
            if (bl2) {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        } else if (!this.licenseIsValid("Liquibase Pro")) {
            stringBuilder.append(EXPIRED_LICENSE_KEY_WARN).append(StreamUtil.getLineSeparator()).append(RENEW_MSG).append(StreamUtil.getLineSeparator());
        } else {
            for (String string : this.managers.keySet()) {
                Object object = this.managers.get(string);
                try {
                    mI mI2 = object.h();
                    string = DaticalTrueLicenseService.getValByAttributeTypeFromIssuerDN(mI2.getHolder().getName(), "CN");
                    Date date = mI2.getNotAfter();
                    object = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                    if (this.licenseIsAboutToExpire() && n2 > 0) {
                        stringBuilder.append(String.format(LIQUIBASE_PRO_MSG, this.buildVersion, string, ((DateFormat)object).format(date))).append(StreamUtil.getLineSeparator()).append(String.format("WARNING!  Your license will expire in %d days!", n2)).append(StreamUtil.getLineSeparator()).append(RENEW_MSG);
                        continue;
                    }
                    stringBuilder.append(String.format(LIQUIBASE_PRO_MSG, this.buildVersion, string, ((DateFormat)object).format(date)));
                }
                catch (mU mU2) {}
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean licenseIsInstalled() {
        ConfiguredValue<String> configuredValue;
        if (!this.licenseInstalled) {
            configuredValue = LiquibaseProConfiguration.LICENSE_PRO_LICENSE_KEY.getCurrentConfiguredValue();
            if (!configuredValue.found()) {
                return false;
            }
            this.installLicense(new Location(configuredValue.getProvidedValue().describe(), LocationType.BASE64_STRING, (String)configuredValue.getValue()));
        }
        configuredValue = Scope.getCurrentScope().getLog(this.getClass());
        boolean bl2 = false;
        for (String string : this.managers.keySet()) {
            try {
                if (this.knownExpiredLicense) {
                    return false;
                }
                this.managers.get(string).i();
                bl2 = true;
            }
            catch (mZ mZ2) {
                mZ mZ3 = mZ2;
                if (mZ2.getMessage().contains("License validity period has expired")) {
                    this.knownExpiredLicense = true;
                }
                configuredValue.severe(mZ3.getMessage());
                bl2 = true;
            }
            catch (mU mU2) {
                if (hasLoggedLicenseFailure) continue;
                hasLoggedLicenseFailure = true;
                configuredValue.severe(String.format("License with subject '%s' is not valid. %s", string, mU2.getMessage()));
            }
        }
        return bl2;
    }

    @Override
    public void disable() {
        this.licenseInstalled = false;
    }

    @Override
    public LicenseInstallResult installLicense(Location ... locationArray) {
        this.licenseInstalled = true;
        LicenseInstallResult licenseInstallResult = new LicenseInstallResult(0);
        for (Location location : locationArray) {
            if (location.type == LocationType.BASE64_STRING) {
                licenseInstallResult.add(this.installFromBase64String(location));
                continue;
            }
            Object object = location.getPath();
            if (object != null) {
                if (((File)(object = new File((String)object))).exists() && ((File)object).isDirectory()) {
                    licenseInstallResult.add(this.installFromDirectory(location, (File)object));
                    continue;
                }
                if (!((File)object).exists()) continue;
                licenseInstallResult.add(this.installFromFile(location, (File)object));
                continue;
            }
            licenseInstallResult.add(new LicenseInstallResult(0, location + " does not specify a location for a license file."));
        }
        return licenseInstallResult;
    }

    @Override
    public boolean licenseIsAboutToExpire() {
        boolean bl2 = false;
        for (String object : this.managers.keySet()) {
            mQ bl3 = this.managers.get(object);
            try {
                mI mI2 = bl3.h();
                Date date = DaticalTrueLicenseService.addDays(new Date(), 30);
                boolean bl4 = mI2.getNotAfter().before(date);
                bl2 = bl2 || bl4;
            }
            catch (mU mU2) {}
        }
        return bl2;
    }

    @Override
    public int daysTilExpiration() {
        int n2 = Integer.MAX_VALUE;
        for (String object : this.managers.keySet()) {
            mQ n3 = this.managers.get(object);
            try {
                int n4 = DaticalTrueLicenseService.daysDifference(n3.h().getNotAfter());
                if (n4 >= n2) continue;
                n2 = n4;
            }
            catch (mU mU2) {}
        }
        return n2;
    }

    private LicenseInstallResult installFromBase64String(Location location) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        for (String string : this.managers.keySet()) {
            try {
                this.managers.get(string).a(new Base64Source(location.getPath()));
                if (this.knownInvalidLicense != null) continue;
                logger.info("Successfully installed license from " + location + ".\n");
            }
            catch (mZ mZ2) {
                n2 = 1;
                if (mZ2.getMessage().contains("License validity period has expired")) {
                    stringBuilder.append("WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!\n");
                    stringBuilder.append(RENEW_MSG);
                    logger.severe(mZ2.getMessage());
                    break;
                }
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + mZ2.getMessage() + "\n");
                break;
            }
            catch (Exception exception) {
                n2 = 1;
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception.getMessage() + "\n");
                break;
            }
        }
        return new LicenseInstallResult(n2, stringBuilder.toString());
    }

    private LicenseInstallResult installFromFile(Location location, File file) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (String mZ2 : this.managers.keySet()) {
            try {
                mQ object = this.managers.get(mZ2);
                mO mO2 = (mO)object.e();
                object.a(mO2.a(file));
                logger.info("Successfully installed license file '" + file + "' from " + location + ".\n");
            }
            catch (mZ exception) {
                n2 = 1;
                if (exception.getMessage().contains("License validity period has expired")) {
                    stringBuilder.append("WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!\n");
                    stringBuilder.append(RENEW_MSG);
                    logger.severe(exception.getMessage());
                    break;
                }
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception.getMessage() + "\n");
                break;
            }
            catch (Exception exception) {
                n2 = 1;
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception.getMessage() + "\n");
                break;
            }
        }
        return new LicenseInstallResult(n2, stringBuilder.toString());
    }

    private LicenseInstallResult installFromDirectory(Location location, File file) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = new DaticalTrueLicenseService$LicenseFileFilter(this);
        if ((fileArray = file.listFiles((FilenameFilter)fileArray)) != null && fileArray.length == 0) {
            logger.severe("There are no '.lic' files in '" + file + "' " + location.toDisplayString());
        }
        block3: for (File file2 : fileArray) {
            for (String mZ2 : this.managers.keySet()) {
                mQ exception = this.managers.get(mZ2);
                mO mO2 = (mO)exception.e();
                try {
                    exception.a(mO2.a(file2));
                    logger.info("Successfully installed license file '" + file + "' from " + location + ".\n");
                }
                catch (mZ mZ3) {
                    n2 = 1;
                    if (mZ3.getMessage().contains("License validity period has expired")) {
                        arrayList.add("WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!\n");
                        arrayList.add(RENEW_MSG);
                        logger.severe(mZ3.getMessage());
                        continue block3;
                    }
                    arrayList.add(INVALID_LICENSE_KEY_WARN);
                    logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + mZ3.getMessage() + "\n");
                }
                catch (Exception exception2) {
                    n2 = 1;
                    arrayList.add(INVALID_LICENSE_KEY_WARN);
                    logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception2.getMessage() + "\n");
                    continue block3;
                }
            }
        }
        return new LicenseInstallResult(n2, arrayList);
    }

    private static Date addDays(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n2);
        return calendar.getTime();
    }

    private static int daysDifference(Date comparable) {
        LocalDate localDate = LocalDate.now();
        comparable = LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(comparable.getTime()));
        return (int)ChronoUnit.DAYS.between(localDate, (Temporal)((Object)comparable));
    }

    private static String getValByAttributeTypeFromIssuerDN(String stringArray, String string) {
        for (String string2 : stringArray.split(",")) {
            String[] stringArray2;
            if (!string2.contains(string) || (stringArray2 = string2.trim().split("="))[1] == null) continue;
            return stringArray2[1].trim();
        }
        return "";
    }
}

