/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.pro.packaged.bb;

public class mf
extends DateFormat {
    protected static final String PATTERN_PLAIN_STR = "\\d\\d\\d\\d[-]\\d\\d[-]\\d\\d";
    protected static final Pattern PATTERN_PLAIN;
    protected static final Pattern PATTERN_ISO8601;
    public static final String DATE_FORMAT_STR_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final String DATE_FORMAT_STR_PLAIN = "yyyy-MM-dd";
    protected static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String[] ALL_FORMATS;
    protected static final TimeZone DEFAULT_TIMEZONE;
    protected static final Locale DEFAULT_LOCALE;
    protected static final DateFormat DATE_FORMAT_RFC1123;
    protected static final DateFormat DATE_FORMAT_ISO8601;
    public static final mf instance;
    protected static final Calendar CALENDAR;
    protected transient TimeZone _timezone;
    protected final Locale _locale;
    protected Boolean _lenient;
    private transient Calendar _calendar;
    private transient DateFormat _formatRFC1123;
    private boolean _tzSerializedWithColon = false;

    public mf() {
        this._locale = DEFAULT_LOCALE;
    }

    @Deprecated
    public mf(TimeZone timeZone, Locale locale) {
        this._timezone = timeZone;
        this._locale = locale;
    }

    protected mf(TimeZone timeZone, Locale locale, Boolean bl2) {
        this(timeZone, locale, bl2, false);
    }

    protected mf(TimeZone timeZone, Locale locale, Boolean bl2, boolean bl3) {
        this._timezone = timeZone;
        this._locale = locale;
        this._lenient = bl2;
        this._tzSerializedWithColon = bl3;
    }

    public static TimeZone getDefaultTimeZone() {
        return DEFAULT_TIMEZONE;
    }

    public mf withTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        if (timeZone == this._timezone || timeZone.equals(this._timezone)) {
            return this;
        }
        return new mf(timeZone, this._locale, this._lenient, this._tzSerializedWithColon);
    }

    public mf withLocale(Locale locale) {
        if (locale.equals(this._locale)) {
            return this;
        }
        return new mf(this._timezone, locale, this._lenient, this._tzSerializedWithColon);
    }

    public mf withLenient(Boolean bl2) {
        if (mf._equals(bl2, this._lenient)) {
            return this;
        }
        return new mf(this._timezone, this._locale, bl2, this._tzSerializedWithColon);
    }

    public mf withColonInTimeZone(boolean bl2) {
        if (this._tzSerializedWithColon == bl2) {
            return this;
        }
        return new mf(this._timezone, this._locale, this._lenient, bl2);
    }

    @Override
    public mf clone() {
        return new mf(this._timezone, this._locale, this._lenient, this._tzSerializedWithColon);
    }

    @Deprecated
    public static DateFormat getISO8601Format(TimeZone timeZone, Locale locale) {
        return mf._cloneFormat(DATE_FORMAT_ISO8601, DATE_FORMAT_STR_ISO8601, timeZone, locale, null);
    }

    @Deprecated
    public static DateFormat getRFC1123Format(TimeZone timeZone, Locale locale) {
        return mf._cloneFormat(DATE_FORMAT_RFC1123, DATE_FORMAT_STR_RFC1123, timeZone, locale, null);
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timezone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (!timeZone.equals(this._timezone)) {
            this._clearFormats();
            this._timezone = timeZone;
        }
    }

    @Override
    public void setLenient(boolean bl2) {
        Boolean bl3 = bl2;
        if (!mf._equals(bl3, this._lenient)) {
            this._lenient = bl3;
            this._clearFormats();
        }
    }

    @Override
    public boolean isLenient() {
        return this._lenient == null || this._lenient != false;
    }

    public boolean isColonIncludedInTimeZone() {
        return this._tzSerializedWithColon;
    }

    @Override
    public Date parse(String string) {
        ParsePosition parsePosition;
        Comparable<Date> comparable = this._parseDate(string = string.trim(), parsePosition = new ParsePosition(0));
        if (comparable != null) {
            return comparable;
        }
        comparable = new StringBuilder();
        String[] stringArray = ALL_FORMATS;
        int n2 = ALL_FORMATS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (((StringBuilder)comparable).length() > 0) {
                ((StringBuilder)comparable).append("\", \"");
            } else {
                ((StringBuilder)comparable).append('\"');
            }
            ((StringBuilder)comparable).append(string2);
        }
        ((StringBuilder)comparable).append('\"');
        throw new ParseException(String.format("Cannot parse date \"%s\": not compatible with any of standard forms (%s)", string, ((StringBuilder)comparable).toString()), parsePosition.getErrorIndex());
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        try {
            return this._parseDate(string, parsePosition);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    protected Date _parseDate(String string, ParsePosition parsePosition) {
        char c2;
        if (this.looksLikeISO8601(string)) {
            return this.parseAsISO8601(string, parsePosition);
        }
        int n2 = string.length();
        while (--n2 >= 0 && ((c2 = string.charAt(n2)) >= '0' && c2 <= '9' || n2 <= 0 && c2 == '-')) {
        }
        if (n2 < 0 && (string.charAt(0) == '-' || bb.inLongRange(string, false))) {
            return this._parseDateFromLong(string, parsePosition);
        }
        return this.parseAsRFC1123(string, parsePosition);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition object) {
        object = this._timezone;
        if (object == null) {
            object = DEFAULT_TIMEZONE;
        }
        this._format((TimeZone)object, this._locale, date, stringBuffer);
        return stringBuffer;
    }

    protected void _format(TimeZone timeZone, Locale cloneable, Date date, StringBuffer stringBuffer) {
        cloneable = this._getCalendar(timeZone);
        ((Calendar)cloneable).setTime(date);
        int n2 = ((Calendar)cloneable).get(1);
        if (((Calendar)cloneable).get(0) == 0) {
            this._formatBCEYear(stringBuffer, n2);
        } else {
            if (n2 > 9999) {
                stringBuffer.append('+');
            }
            mf.pad4(stringBuffer, n2);
        }
        stringBuffer.append('-');
        mf.pad2(stringBuffer, ((Calendar)cloneable).get(2) + 1);
        stringBuffer.append('-');
        mf.pad2(stringBuffer, ((Calendar)cloneable).get(5));
        stringBuffer.append('T');
        mf.pad2(stringBuffer, ((Calendar)cloneable).get(11));
        stringBuffer.append(':');
        mf.pad2(stringBuffer, ((Calendar)cloneable).get(12));
        stringBuffer.append(':');
        mf.pad2(stringBuffer, ((Calendar)cloneable).get(13));
        stringBuffer.append('.');
        mf.pad3(stringBuffer, ((Calendar)cloneable).get(14));
        int n3 = timeZone.getOffset(((Calendar)cloneable).getTimeInMillis());
        if (n3 != 0) {
            int n4 = Math.abs(n3 / 60000 / 60);
            n2 = Math.abs(n3 / 60000 % 60);
            stringBuffer.append(n3 < 0 ? (char)'-' : '+');
            mf.pad2(stringBuffer, n4);
            if (this._tzSerializedWithColon) {
                stringBuffer.append(':');
            }
            mf.pad2(stringBuffer, n2);
            return;
        }
        if (this._tzSerializedWithColon) {
            stringBuffer.append("+00:00");
            return;
        }
        stringBuffer.append("+0000");
    }

    protected void _formatBCEYear(StringBuffer stringBuffer, int n2) {
        if (n2 == 1) {
            stringBuffer.append("+0000");
            return;
        }
        stringBuffer.append('-');
        mf.pad4(stringBuffer, --n2);
    }

    private static void pad2(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 10;
        if (n3 == 0) {
            stringBuffer.append('0');
        } else {
            stringBuffer.append((char)(n3 + 48));
            n2 -= n3 * 10;
        }
        stringBuffer.append((char)(n2 + 48));
    }

    private static void pad3(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 100;
        if (n3 == 0) {
            stringBuffer.append('0');
        } else {
            stringBuffer.append((char)(n3 + 48));
            n2 -= n3 * 100;
        }
        mf.pad2(stringBuffer, n2);
    }

    private static void pad4(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 100;
        if (n3 == 0) {
            stringBuffer.append('0').append('0');
        } else {
            if (n3 > 99) {
                stringBuffer.append(n3);
            } else {
                mf.pad2(stringBuffer, n3);
            }
            n2 -= n3 * 100;
        }
        mf.pad2(stringBuffer, n2);
    }

    public String toString() {
        return String.format("DateFormat %s: (timezone: %s, locale: %s, lenient: %s)", this.getClass().getName(), this._timezone, this._locale, this._lenient);
    }

    public String toPattern() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("[one of: 'yyyy-MM-dd'T'HH:mm:ss.SSSZ', 'EEE, dd MMM yyyy HH:mm:ss zzz' (");
        stringBuilder.append(Boolean.FALSE.equals(this._lenient) ? "strict" : "lenient").append(")]");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    protected boolean looksLikeISO8601(String string) {
        return string.length() >= 7 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(3)) && string.charAt(4) == '-' && Character.isDigit(string.charAt(5));
    }

    private Date _parseDateFromLong(String string, ParsePosition parsePosition) {
        long l2;
        try {
            l2 = bb.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(String.format("Timestamp value %s out of 64-bit value range", string), parsePosition.getErrorIndex());
        }
        return new Date(l2);
    }

    protected Date parseAsISO8601(String string, ParsePosition parsePosition) {
        try {
            return this._parseAsISO8601(string, parsePosition);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(String.format("Cannot parse date \"%s\", problem: %s", string, illegalArgumentException.getMessage()), parsePosition.getErrorIndex());
        }
    }

    protected Date _parseAsISO8601(String string, ParsePosition parsePosition) {
        String string2;
        int n2 = string.length();
        Cloneable cloneable = DEFAULT_TIMEZONE;
        if (this._timezone != null && 'Z' != string.charAt(n2 - 1)) {
            cloneable = this._timezone;
        }
        cloneable = this._getCalendar((TimeZone)cloneable);
        ((Calendar)cloneable).clear();
        if (n2 <= 10) {
            if (PATTERN_PLAIN.matcher(string).matches()) {
                int n3 = mf._parse4D(string, 0);
                int n4 = mf._parse2D(string, 5) - 1;
                int n5 = mf._parse2D(string, 8);
                ((Calendar)cloneable).set(n3, n4, n5, 0, 0, 0);
                ((Calendar)cloneable).set(14, 0);
                return ((Calendar)cloneable).getTime();
            }
            string2 = DATE_FORMAT_STR_PLAIN;
        } else {
            Matcher matcher = PATTERN_ISO8601.matcher(string);
            if (matcher.matches()) {
                int n6;
                int n7 = matcher.start(2);
                int n8 = matcher.end(2);
                int n9 = n8 - n7;
                if (n9 > 1) {
                    n6 = mf._parse2D(string, n7 + 1) * 3600;
                    if (n9 >= 5) {
                        n6 += mf._parse2D(string, n8 - 2) * 60;
                    }
                    n6 = string.charAt(n7) == '-' ? (n6 *= -1000) : (n6 *= 1000);
                    ((Calendar)cloneable).set(15, n6);
                    ((Calendar)cloneable).set(16, 0);
                }
                n6 = mf._parse4D(string, 0);
                n7 = mf._parse2D(string, 5) - 1;
                n8 = mf._parse2D(string, 8);
                n9 = mf._parse2D(string, 11);
                int n10 = mf._parse2D(string, 14);
                n2 = n2 > 16 && string.charAt(16) == ':' ? mf._parse2D(string, 17) : 0;
                ((Calendar)cloneable).set(n6, n7, n8, n9, n10, n2);
                n7 = matcher.start(1) + 1;
                n8 = matcher.end(1);
                if (n7 >= n8) {
                    ((Calendar)cloneable).set(14, 0);
                } else {
                    n2 = 0;
                    switch (n8 -= n7) {
                        default: {
                            if (n8 > 9) {
                                throw new ParseException(String.format("Cannot parse date \"%s\": invalid fractional seconds '%s'; can use at most 9 digits", string, matcher.group(1).substring(1)), n7);
                            }
                        }
                        case 3: {
                            n2 = 0 + (string.charAt(n7 + 2) - 48);
                        }
                        case 2: {
                            n2 += 10 * (string.charAt(n7 + 1) - 48);
                        }
                        case 1: {
                            n2 += 100 * (string.charAt(n7) - 48);
                        }
                        case 0: 
                    }
                    ((Calendar)cloneable).set(14, n2);
                }
                return ((Calendar)cloneable).getTime();
            }
            string2 = DATE_FORMAT_STR_ISO8601;
        }
        throw new ParseException(String.format("Cannot parse date \"%s\": while it seems to fit format '%s', parsing fails (leniency? %s)", string, string2, this._lenient), 0);
    }

    private static int _parse4D(String string, int n2) {
        return 1000 * (string.charAt(n2) - 48) + 100 * (string.charAt(n2 + 1) - 48) + 10 * (string.charAt(n2 + 2) - 48) + (string.charAt(n2 + 3) - 48);
    }

    private static int _parse2D(String string, int n2) {
        return 10 * (string.charAt(n2) - 48) + (string.charAt(n2 + 1) - 48);
    }

    protected Date parseAsRFC1123(String string, ParsePosition parsePosition) {
        if (this._formatRFC1123 == null) {
            this._formatRFC1123 = mf._cloneFormat(DATE_FORMAT_RFC1123, DATE_FORMAT_STR_RFC1123, this._timezone, this._locale, this._lenient);
        }
        return this._formatRFC1123.parse(string, parsePosition);
    }

    private static final DateFormat _cloneFormat(DateFormat dateFormat, String string, TimeZone timeZone, Locale locale, Boolean bl2) {
        if (!locale.equals(DEFAULT_LOCALE)) {
            dateFormat = new SimpleDateFormat(string, locale);
            dateFormat.setTimeZone(timeZone == null ? DEFAULT_TIMEZONE : timeZone);
        } else {
            dateFormat = (DateFormat)dateFormat.clone();
            if (timeZone != null) {
                dateFormat.setTimeZone(timeZone);
            }
        }
        if (bl2 != null) {
            dateFormat.setLenient(bl2);
        }
        return dateFormat;
    }

    protected void _clearFormats() {
        this._formatRFC1123 = null;
    }

    protected Calendar _getCalendar(TimeZone timeZone) {
        Calendar calendar = this._calendar;
        if (calendar == null) {
            this._calendar = calendar = (Calendar)CALENDAR.clone();
        }
        if (!calendar.getTimeZone().equals(timeZone)) {
            calendar.setTimeZone(timeZone);
        }
        calendar.setLenient(this.isLenient());
        return calendar;
    }

    protected static <T> boolean _equals(T t2, T t3) {
        if (t2 == t3) {
            return true;
        }
        return t2 != null && t2.equals(t3);
    }

    static {
        Pattern pattern;
        PATTERN_PLAIN = Pattern.compile(PATTERN_PLAIN_STR);
        try {
            pattern = Pattern.compile("\\d\\d\\d\\d[-]\\d\\d[-]\\d\\d[T]\\d\\d[:]\\d\\d(?:[:]\\d\\d)?(\\.\\d+)?(Z|[+-]\\d\\d(?:[:]?\\d\\d)?)?");
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        PATTERN_ISO8601 = pattern;
        ALL_FORMATS = new String[]{DATE_FORMAT_STR_ISO8601, "yyyy-MM-dd'T'HH:mm:ss.SSS", DATE_FORMAT_STR_RFC1123, DATE_FORMAT_STR_PLAIN};
        DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
        DEFAULT_LOCALE = Locale.US;
        DATE_FORMAT_RFC1123 = new SimpleDateFormat(DATE_FORMAT_STR_RFC1123, DEFAULT_LOCALE);
        DATE_FORMAT_RFC1123.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_ISO8601 = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601, DEFAULT_LOCALE);
        DATE_FORMAT_ISO8601.setTimeZone(DEFAULT_TIMEZONE);
        instance = new mf();
        CALENDAR = new GregorianCalendar(DEFAULT_TIMEZONE, DEFAULT_LOCALE);
    }
}

