/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.job.SimpleStepHandler;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowHolder;
import org.springframework.batch.core.job.flow.JobFlowExecutor;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.step.StepHolder;
import org.springframework.batch.core.step.StepLocator;

public class FlowJob
extends AbstractJob {
    protected Flow flow;
    private Map<String, Step> stepMap = new ConcurrentHashMap<String, Step>();
    private volatile boolean initialized = false;

    public FlowJob() {
    }

    public FlowJob(String name) {
        super(name);
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    @Override
    public Step getStep(String stepName) {
        if (!this.initialized) {
            this.init();
        }
        return this.stepMap.get(stepName);
    }

    private void init() {
        this.findSteps(this.flow, this.stepMap);
        this.initialized = true;
    }

    private void findSteps(Flow flow, Map<String, Step> map) {
        for (State state : flow.getStates()) {
            if (state instanceof StepLocator) {
                StepLocator locator = (StepLocator)((Object)state);
                for (String name : locator.getStepNames()) {
                    map.put(name, locator.getStep(name));
                }
                continue;
            }
            if (state instanceof StepHolder) {
                Step step = ((StepHolder)((Object)state)).getStep();
                String name = step.getName();
                this.stepMap.put(name, step);
                continue;
            }
            if (!(state instanceof FlowHolder)) continue;
            for (Flow subflow : ((FlowHolder)((Object)state)).getFlows()) {
                this.findSteps(subflow, map);
            }
        }
    }

    @Override
    public Collection<String> getStepNames() {
        if (!this.initialized) {
            this.init();
        }
        return this.stepMap.keySet();
    }

    @Override
    protected void doExecute(JobExecution execution) throws JobExecutionException {
        try {
            JobFlowExecutor executor = new JobFlowExecutor(this.getJobRepository(), new SimpleStepHandler(this.getJobRepository()), execution);
            executor.updateJobExecutionStatus(this.flow.start(executor).getStatus());
        }
        catch (FlowExecutionException e) {
            if (e.getCause() instanceof JobExecutionException) {
                throw (JobExecutionException)e.getCause();
            }
            throw new JobExecutionException("Flow execution ended unexpectedly", e);
        }
    }
}

