/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.i18n;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.AbstractMessageSource;
import org.vaadin.spring.i18n.MessageProvider;

public class CompositeMessageSource
extends AbstractMessageSource
implements MessageSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeMessageSource.class);
    private final Collection<MessageProvider> messageProviders;
    private final Map<Locale, Map<String, MessageFormat>> messageFormatCache = new ConcurrentHashMap<Locale, Map<String, MessageFormat>>();

    public CompositeMessageSource(ApplicationContext applicationContext) {
        LOGGER.info("Looking up MessageProviders");
        this.messageProviders = applicationContext.getBeansOfType(MessageProvider.class).values();
        if (LOGGER.isDebugEnabled()) {
            for (MessageProvider messageProvider : this.messageProviders) {
                LOGGER.debug("Found MessageProvider [{}]", (Object)messageProvider);
            }
        }
        LOGGER.info("Found {} MessageProvider(s)", (Object)this.messageProviders.size());
    }

    protected MessageFormat resolveCode(String s, Locale locale) {
        MessageFormat messageFormat = this.queryCache(s, locale);
        if (messageFormat == null && (messageFormat = this.queryMessageProviders(s, locale)) != null) {
            this.cache(s, locale, messageFormat);
        }
        return messageFormat;
    }

    private MessageFormat queryCache(String s, Locale locale) {
        Map<String, MessageFormat> cache = this.getMessageFormatCache(locale);
        return cache.get(s);
    }

    private void cache(String s, Locale locale, MessageFormat messageFormat) {
        Map<String, MessageFormat> cache = this.getMessageFormatCache(locale);
        cache.put(s, messageFormat);
    }

    private MessageFormat queryMessageProviders(String s, Locale locale) {
        LOGGER.debug("Querying message providers for code [{}] for locale [{}]", (Object)s, (Object)locale);
        for (MessageProvider messageProvider : this.messageProviders) {
            MessageFormat messageFormat = messageProvider.resolveCode(s, locale);
            if (messageFormat == null) continue;
            LOGGER.debug("Code [{}] for locale [{}] found in provider [{}]", new Object[]{s, locale, messageProvider});
            return messageFormat;
        }
        LOGGER.debug("Code [{}] for locale [{}] not found", (Object)s, (Object)locale);
        return null;
    }

    private Map<String, MessageFormat> getMessageFormatCache(Locale locale) {
        Map<String, MessageFormat> cache = this.messageFormatCache.get(locale);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, MessageFormat>();
            this.messageFormatCache.put(locale, cache);
        }
        return cache;
    }
}

