/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.spring.i18n.MessageProvider;

public class ResourceBundleMessageProvider
implements MessageProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleMessageProvider.class);
    private final String baseName;
    private final String encoding;

    public ResourceBundleMessageProvider(String baseName) {
        this(baseName, "UTF-8");
    }

    public ResourceBundleMessageProvider(String baseName, String encoding) {
        this.baseName = baseName;
        this.encoding = encoding;
    }

    @Override
    public MessageFormat resolveCode(String s, Locale locale) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        String message = this.getString(resourceBundle, s);
        return this.getMessageFormat(message, locale);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.baseName, locale, new MessageControl());
        }
        catch (MissingResourceException ex) {
            LOGGER.warn("No message bundle with basename [{}] found for locale [{}]", (Object)this.baseName, (Object)locale);
            return null;
        }
    }

    private String getString(ResourceBundle bundle, String s) {
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.getString(s);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private MessageFormat getMessageFormat(String message, Locale locale) {
        if (message == null) {
            return null;
        }
        return new MessageFormat(message, locale);
    }

    private class MessageControl
    extends ResourceBundle.Control {
        private MessageControl() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if ("java.properties".equals(format)) {
                String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
                InputStream stream = loader.getResourceAsStream(resourceName);
                if (stream == null) {
                    return null;
                }
                Reader reader = null;
                try {
                    reader = new InputStreamReader(stream, ResourceBundleMessageProvider.this.encoding);
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(reader);
                    return propertyResourceBundle;
                }
                catch (UnsupportedEncodingException ex) {
                    stream.close();
                    throw ex;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    }
}

