/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.vaadin.spring.annotation.EnableVaadin;
import org.vaadin.spring.annotation.VaadinUI;
import org.vaadin.spring.boot.annotation.EnableVaadinServlet;
import org.vaadin.spring.boot.config.StaticContentVaadinServletConfiguration;

@Configuration
@ConditionalOnClass(value={VaadinUI.class})
public class VaadinAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(VaadinAutoConfiguration.class);

    @Configuration
    @EnableVaadinServlet
    @ConditionalOnMissingClass(name={"org.vaadin.spring.touchkit.TouchKitUI"})
    static class EnableVaadinServletConfiguration
    implements InitializingBean {
        EnableVaadinServletConfiguration() {
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }
    }

    @Configuration
    @EnableVaadin
    @Import(value={StaticContentVaadinServletConfiguration.class})
    static class EnableVaadinConfiguration
    implements InitializingBean {
        EnableVaadinConfiguration() {
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }
    }
}

