/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot.config;

import com.vaadin.annotations.VaadinServletConfiguration;
import java.lang.reflect.Method;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

abstract class AbstractServletConfiguration
implements InitializingBean {
    public static final String DEFAULT_SERVLET_URL_MAPPING = "/*";
    @Autowired
    Environment environment;
    @Autowired
    ApplicationContext applicationContext;

    AbstractServletConfiguration() {
    }

    protected abstract String getServletConfigurationParameterPrefix();

    protected abstract Class<? extends HttpServlet> getServletClass();

    protected abstract Logger getLogger();

    public void afterPropertiesSet() throws Exception {
        this.getLogger().debug("{} initialized", (Object)this.getClass().getName());
    }

    private HttpServlet newServletInstance() {
        try {
            return this.getServletClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new servlet instance", e);
        }
    }

    protected abstract String getUrlMapping();

    protected HttpServlet createServlet() {
        HttpServlet servlet;
        try {
            servlet = (HttpServlet)this.applicationContext.getBean(this.getServletClass());
            this.getLogger().info("Using servlet instance [{}] found in the application context", (Object)servlet);
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.getLogger().info("Servlet was not found in the application context, using default");
            servlet = this.newServletInstance();
        }
        return servlet;
    }

    protected ServletRegistrationBean createServletRegistrationBean() {
        this.getLogger().info("Registering servlet of type [{}]", (Object)this.getServletClass().getCanonicalName());
        String urlMapping = this.getUrlMapping();
        this.getLogger().info("Servlet will be mapped to URL [{}]", (Object)urlMapping);
        HttpServlet servlet = this.createServlet();
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, new String[]{urlMapping});
        this.addInitParameters(registrationBean);
        return registrationBean;
    }

    private void addInitParameters(ServletRegistrationBean servletRegistrationBean) {
        Method[] methods;
        this.getLogger().info("Looking for servlet init parameters");
        int count = 0;
        for (Method method : methods = VaadinServletConfiguration.class.getDeclaredMethods()) {
            VaadinServletConfiguration.InitParameterName name = method.getAnnotation(VaadinServletConfiguration.InitParameterName.class);
            String propertyValue = this.environment.getProperty(this.getServletConfigurationParameterPrefix() + name.value());
            if (propertyValue == null) continue;
            this.getLogger().info("Found servlet init parameter [{}] = [{}]", (Object)name.value(), (Object)propertyValue);
            servletRegistrationBean.addInitParameter(name.value(), propertyValue);
            ++count;
        }
        String propertyValue = this.environment.getProperty(this.getServletConfigurationParameterPrefix() + "Resources");
        if (propertyValue != null) {
            this.getLogger().info("Found servlet init parameter [{}] = [{}]", (Object)"Resources", (Object)propertyValue);
            servletRegistrationBean.addInitParameter("Resources", propertyValue);
            ++count;
        }
        if (count == 0) {
            this.getLogger().info("Found no servlet init parameters");
        }
    }
}

