/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot.config;

import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vaadin.spring.boot.config.AbstractServletConfiguration;
import org.vaadin.spring.boot.config.StaticContentServlet;

@Configuration
public class StaticContentVaadinServletConfiguration
extends AbstractServletConfiguration {
    private static Logger logger = LoggerFactory.getLogger(StaticContentVaadinServletConfiguration.class);
    public static final String SERVLET_CONFIGURATION_PARAMETER_PREFIX = "vaadin.static.servlet.params.";

    @Override
    protected String getServletConfigurationParameterPrefix() {
        return SERVLET_CONFIGURATION_PARAMETER_PREFIX;
    }

    @Override
    protected Class<? extends HttpServlet> getServletClass() {
        return StaticContentServlet.class;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getUrlMapping() {
        return "/VAADIN/*";
    }

    @Bean
    ServletRegistrationBean staticContentVaadinServletRegistration() {
        return this.createServletRegistrationBean();
    }

    @Override
    protected ServletRegistrationBean createServletRegistrationBean() {
        String productionModeKey = "productionMode";
        ServletRegistrationBean bean = super.createServletRegistrationBean();
        Map initParameters = bean.getInitParameters();
        if (!initParameters.containsKey(productionModeKey)) {
            initParameters.put(productionModeKey, "true");
        }
        bean.setInitParameters(initParameters);
        return bean;
    }
}

