/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot.config;

import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vaadin.spring.boot.config.AbstractServletConfiguration;
import org.vaadin.spring.touchkit.servlet.SpringAwareTouchKitServlet;

@Configuration
public class TouchKitServletConfiguration
extends AbstractServletConfiguration {
    private static Logger logger = LoggerFactory.getLogger(TouchKitServletConfiguration.class);
    public static final String SERVLET_CONFIGURATION_PARAMETER_PREFIX = "touchKit.servlet.params.";
    public static final String SERVLET_URL_MAPPING_PARAMETER_NAME = "touchKit.servlet.urlMapping";

    @Override
    protected String getServletConfigurationParameterPrefix() {
        return SERVLET_CONFIGURATION_PARAMETER_PREFIX;
    }

    @Override
    protected Class<? extends HttpServlet> getServletClass() {
        return SpringAwareTouchKitServlet.class;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getUrlMapping() {
        return this.environment.getProperty(SERVLET_URL_MAPPING_PARAMETER_NAME, "/*");
    }

    @Bean
    ServletRegistrationBean touchKitServletRegistration() {
        return this.createServletRegistrationBean();
    }
}

