/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot.config;

import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vaadin.spring.boot.config.AbstractServletConfiguration;
import org.vaadin.spring.servlet.SpringAwareVaadinServlet;

@Configuration
public class VaadinServletConfiguration
extends AbstractServletConfiguration {
    private static Logger logger = LoggerFactory.getLogger(VaadinServletConfiguration.class);
    public static final String SERVLET_CONFIGURATION_PARAMETER_PREFIX = "vaadin.servlet.params.";
    public static final String SERVLET_URL_MAPPING_PARAMETER_NAME = "vaadin.servlet.urlMapping";

    @Override
    protected String getServletConfigurationParameterPrefix() {
        return SERVLET_CONFIGURATION_PARAMETER_PREFIX;
    }

    @Override
    protected Class<? extends HttpServlet> getServletClass() {
        return SpringAwareVaadinServlet.class;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getUrlMapping() {
        return this.environment.getProperty(SERVLET_URL_MAPPING_PARAMETER_NAME, "/*");
    }

    @Bean
    ServletRegistrationBean vaadinServletRegistration() {
        return this.createServletRegistrationBean();
    }
}

