/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class ServerShutdownHandler
implements OperationStepHandler {
    protected static final SimpleAttributeDefinition RESTART = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("restart", ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).build();
    protected static final SimpleAttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.INT).setDefaultValue(new ModelNode(0))).setAllowNull(true)).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("shutdown", ServerDescriptions.getResourceDescriptionResolver(new String[0])).setParameters(new AttributeDefinition[]{RESTART, TIMEOUT}).setRuntimeOnly().build();
    private final ControlledProcessState processState;

    public ServerShutdownHandler(ControlledProcessState processState) {
        this.processState = processState;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean restart = RESTART.resolveModelAttribute(context, operation).asBoolean();
        final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.acquireControllerLock();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                AuthorizationResult authorizationResult = context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
                    throw ControllerLogger.ACCESS_LOGGER.unauthorized(operation.get("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address")), authorizationResult.getExplanation());
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            final ShutdownAction shutdown = new ShutdownAction(ServerShutdownHandler.getOperationName(operation), restart);
                            ServiceRegistry registry = context.getServiceRegistry(false);
                            ServiceController suspendControllerServiceController = registry.getRequiredService(SuspendController.SERVICE_NAME);
                            final SuspendController suspendController = (SuspendController)suspendControllerServiceController.getValue();
                            OperationListener listener = new OperationListener(){

                                @Override
                                public void suspendStarted() {
                                }

                                @Override
                                public void complete() {
                                    suspendController.removeListener(this);
                                    shutdown.shutdown();
                                }

                                @Override
                                public void cancelled() {
                                    suspendController.removeListener(this);
                                    shutdown.cancel();
                                }

                                @Override
                                public void timeout() {
                                    suspendController.removeListener(this);
                                    shutdown.shutdown();
                                }
                            };
                            suspendController.addListener(listener);
                            suspendController.suspend(timeout > 0 ? (long)(timeout * 1000) : (long)timeout);
                            if (timeout == 0) {
                                shutdown.shutdown();
                            }
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private static String getOperationName(ModelNode op) {
        return op.hasDefined("operation") ? op.get("operation").asString() : "shutdown";
    }

    private final class ShutdownAction
    extends AtomicBoolean {
        private final String op;
        private final boolean restart;

        private ShutdownAction(String op, boolean restart) {
            this.op = op;
            this.restart = restart;
        }

        void cancel() {
            this.compareAndSet(false, true);
        }

        void shutdown() {
            if (this.compareAndSet(false, true)) {
                ServerShutdownHandler.this.processState.setStopping();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int exitCode = ShutdownAction.this.restart ? 10 : 0;
                        SystemExiter.logAndExit(new SystemExiter.ExitLogger(){

                            @Override
                            public void logExit() {
                                ServerLogger.ROOT_LOGGER.shuttingDownInResponseToManagementRequest(ShutdownAction.this.op);
                            }
                        }, exitCode);
                    }
                });
                thread.setName("Management Triggered Shutdown");
                thread.start();
            }
        }
    }
}

