/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.base.Optional;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDirLocator {
    final MavenProject mavenProject;
    final List<MavenProject> reactorProjects;

    public GitDirLocator(MavenProject mavenProject, List<MavenProject> reactorProjects) {
        this.mavenProject = mavenProject;
        this.reactorProjects = reactorProjects;
    }

    @Nullable
    public File lookupGitDirectory(@NotNull File manuallyConfiguredDir) {
        if (manuallyConfiguredDir.exists()) {
            if (manuallyConfiguredDir.isDirectory()) {
                return manuallyConfiguredDir;
            }
            File gitDirLinkPath = this.processGitDirFile(manuallyConfiguredDir);
            if (GitDirLocator.isExistingDirectory(gitDirLinkPath)) {
                return gitDirLinkPath;
            }
        }
        return this.findProjectGitDirectory();
    }

    @Nullable
    private File findProjectGitDirectory() {
        MavenProject currentProject = this.mavenProject;
        while (currentProject != null) {
            File dir = GitDirLocator.getProjectGitDir(currentProject);
            if (GitDirLocator.isExistingDirectory(dir)) {
                return dir;
            }
            File gitDirLinkPath = this.processGitDirFile(dir);
            if (GitDirLocator.isExistingDirectory(gitDirLinkPath)) {
                return gitDirLinkPath;
            }
            if (currentProject.getParent() == null && currentProject.getParentArtifact() != null) {
                Optional<MavenProject> maybeFoundParentProject = this.getReactorParentProject(currentProject);
                if (!maybeFoundParentProject.isPresent()) continue;
                currentProject = (MavenProject)maybeFoundParentProject.get();
                continue;
            }
            currentProject = currentProject.getParent();
        }
        return null;
    }

    private Optional<MavenProject> getReactorParentProject(@NotNull MavenProject project) {
        Artifact parentArtifact = project.getParentArtifact();
        if (parentArtifact != null) {
            for (MavenProject reactorProject : this.reactorProjects) {
                if (!reactorProject.getArtifactId().equals(parentArtifact.getArtifactId())) continue;
                return Optional.of((Object)reactorProject);
            }
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File processGitDirFile(@NotNull File file) {
        try {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                String[] parts = line.split(": ");
                if (parts.length != 2 || !parts[0].equals("gitdir")) {
                    File file3 = null;
                    return file3;
                }
                File file2 = new File(file.getParentFile(), parts[1]);
                return file2;
            }
            catch (FileNotFoundException e) {
                File file4 = null;
                return file4;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e2) {
            return null;
        }
    }

    @NotNull
    private static File getProjectGitDir(@NotNull MavenProject mavenProject) {
        return new File(mavenProject.getBasedir(), ".git");
    }

    private static boolean isExistingDirectory(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }
}

