/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.vaadin.flow.plugin.common.AnnotationValuesExtractor;
import com.vaadin.flow.plugin.common.FlowPluginFileUtils;
import com.vaadin.flow.plugin.common.FrontendDataProvider;
import com.vaadin.flow.plugin.common.FrontendToolsManager;
import com.vaadin.flow.plugin.common.RunnerManager;
import com.vaadin.flow.plugin.maven.Fragment;
import com.vaadin.flow.plugin.production.TranspilationStep;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

@Mojo(name="package-for-production", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class PackageForProductionMojo
extends AbstractMojo {
    @Parameter(name="transpileEs6SourceDirectory", defaultValue="${project.build.directory}/frontend/", required=true)
    private File transpileEs6SourceDirectory;
    @Parameter(name="transpileWorkingDirectory", defaultValue="${project.build.directory}/", required=true)
    private File transpileWorkingDirectory;
    @Parameter(name="transpileOutputDirectory")
    private File transpileOutputDirectory;
    @Parameter(name="es6OutputDirectoryName", defaultValue="frontend-es6", required=true)
    private String es6OutputDirectoryName;
    @Parameter(name="es5OutputDirectoryName", defaultValue="frontend-es5", required=true)
    private String es5OutputDirectoryName;
    @Parameter(property="skipEs5", defaultValue="false", required=true)
    private boolean skipEs5;
    @Parameter
    private List<Fragment> fragments;
    @Parameter(property="bundle", defaultValue="true", required=true)
    private boolean bundle;
    @Parameter(property="minify", defaultValue="true", required=true)
    private boolean minify;
    @Parameter(property="hash", defaultValue="true", required=true)
    private boolean hash;
    @Parameter(property="bundleConfiguration", defaultValue="${project.basedir}/bundle-configuration.json")
    private File bundleConfiguration;
    @Parameter(name="nodePath")
    private File nodePath;
    @Parameter(name="nodeVersion", defaultValue="v8.11.1")
    private String nodeVersion;
    @Parameter(name="yarnPath")
    private File yarnPath;
    @Parameter(name="yarnVersion", defaultValue="v1.6.0")
    private String yarnVersion;
    @Parameter(name="yarnNetworkConcurrency", defaultValue="-1")
    private int yarnNetworkConcurrency;
    @Parameter(property="npmRegistryURL")
    private String npmRegistryURL;
    @Parameter(property="autodetectTools", defaultValue="false")
    private boolean autodetectTools;
    @Parameter(property="ignoreMavenProxies", defaultValue="true", required=true)
    private boolean ignoreMavenProxies;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() {
        if (this.transpileOutputDirectory == null) {
            this.transpileOutputDirectory = "jar".equals(this.project.getPackaging()) && this.project.getArtifactMap().containsKey("com.vaadin:vaadin-spring-boot-starter") ? new File(this.project.getBuild().getOutputDirectory(), "META-INF/resources") : new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName());
        }
        FrontendDataProvider frontendDataProvider = new FrontendDataProvider(this.bundle, this.minify, this.hash, this.transpileEs6SourceDirectory, new AnnotationValuesExtractor(this.getProjectClassPathUrls()), this.bundleConfiguration, this.getFragmentsData(this.fragments));
        FrontendToolsManager frontendToolsManager = new FrontendToolsManager(this.transpileWorkingDirectory, this.es5OutputDirectoryName, this.es6OutputDirectoryName, frontendDataProvider, this.getRunnerManager());
        new TranspilationStep(frontendToolsManager, this.yarnNetworkConcurrency).transpileFiles(this.transpileEs6SourceDirectory, this.transpileOutputDirectory, this.skipEs5);
    }

    private RunnerManager getRunnerManager() {
        return new RunnerManager.Builder(this.transpileWorkingDirectory, this.getProxyConfig()).versionsToDownload(this.nodeVersion, this.yarnVersion).localInstallations(this.nodePath, this.yarnPath).autodetectTools(this.autodetectTools).npmRegistryUrl(this.npmRegistryURL).build();
    }

    private Map<String, Set<String>> getFragmentsData(List<Fragment> mavenFragments) {
        return Optional.ofNullable(mavenFragments).orElse(Collections.emptyList()).stream().peek(this::verifyFragment).collect(Collectors.toMap(Fragment::getName, Fragment::getFiles));
    }

    private void verifyFragment(Fragment fragment) {
        if (fragment.getName() == null || fragment.getFiles() == null || fragment.getFiles().isEmpty()) {
            throw new IllegalArgumentException(String.format("Each fragment definition should have a name and list of files to include defined. Got incorrect definition: '%s'", fragment));
        }
    }

    private URL[] getProjectClassPathUrls() {
        List runtimeClasspathElements;
        try {
            runtimeClasspathElements = this.project.getRuntimeClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException(String.format("Failed to retrieve runtime classpath elements from project '%s'", this.project), e);
        }
        return (URL[])runtimeClasspathElements.stream().map(File::new).map(FlowPluginFileUtils::convertToUrl).toArray(URL[]::new);
    }

    private ProxyConfig getProxyConfig() {
        if (this.ignoreMavenProxies) {
            return new ProxyConfig(Collections.emptyList());
        }
        return new ProxyConfig(this.getMavenProxies().stream().filter(Proxy::isActive).map(proxy -> this.decrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxy))).map(SettingsDecryptionResult::getProxy).map(this::createProxy).collect(Collectors.toList()));
    }

    private List<Proxy> getMavenProxies() {
        if (this.session == null || this.session.getSettings() == null || this.session.getSettings().getProxies() == null || this.session.getSettings().getProxies().isEmpty()) {
            return Collections.emptyList();
        }
        return this.session.getSettings().getProxies();
    }

    private ProxyConfig.Proxy createProxy(Proxy proxy) {
        return new ProxyConfig.Proxy(proxy.getId(), proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword(), proxy.getNonProxyHosts());
    }
}

