/* Generated By:JavaCC: Do not edit this line. Parser.java */
package com.vaadin.sass.internal.parser;

import java.io.*;
import java.net.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.LexicalUnit;

import org.w3c.flute.parser.selectors.SelectorFactoryImpl;
import org.w3c.flute.parser.selectors.ConditionFactoryImpl;

import org.w3c.flute.util.Encoding;

import com.vaadin.sass.internal.handler.*;

import com.vaadin.sass.internal.tree.*;

import com.vaadin.sass.internal.selector.*;

/**
 * A CSS2 parser
 *
 * @author Philippe Le H�garet
 * @version $Revision: 1.15 $
 */
public class Parser implements org.w3c.css.sac.Parser, ParserConstants {

    // replaces all \t, \n, etc with this StringBuffer.
    static final StringBuilder SPACE = new StringBuilder(" ");

    // the document handler for the parser
    protected SCSSDocumentHandlerImpl documentHandler;
    // the error handler for the parser
    protected ErrorHandler errorHandler;
    // the input source for the parser
    protected InputSource source;

    protected ConditionFactory conditionFactory;
    protected SelectorFactory selectorFactory;

    // temporary place holder for pseudo-element ...
    private PseudoElementSelector pseudoElt;

    /**
     * Creates a new Parser
     */
    public Parser() {
        this((CharStream) null);
    }

    /**
     * @@TODO
     * @exception CSSException Not yet implemented
     */
    public void setLocale(Locale locale) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    public InputSource getInputSource(){
        return source;
    }

    /**
     * Set the document handler for this parser
     */
    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = (SCSSDocumentHandlerImpl) handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = selectorFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory = conditionFactory;
    }

    /**
     * Set the error handler for this parser
     */
    public void setErrorHandler(ErrorHandler error) {
        this.errorHandler = error;
    }

    /**
     * Main parse methods
     *
     * @param source the source of the style sheet.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleSheet(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));
        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }

        parserUnit();
    }

    /**
     * Convenient method for URIs.
     *
     * @param systemId the fully resolved URI of the style sheet.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleSheet(String systemId)
            throws CSSException, IOException {
        parseStyleSheet(new InputSource(systemId));
    }

    /**
     * This method parses only one rule (style rule or at-rule, except @charset).
     *
     * @param source the source of the rule.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    // TODO required by original parser but not used by Vaadin?
    public void parseRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseRule();
    }

    /**
     * This method parses a style declaration (including the surrounding curly
     * braces).
     *
     * @param source the source of the style declaration.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleDeclaration(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseDeclarationBlock();
    }

    /**
     * This methods returns "http://www.w3.org/TR/REC-CSS2".
     * @return the string "http://www.w3.org/TR/REC-CSS2".
     */
    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    /**
     * Parse methods used by DOM Level 2 implementation.
     */
    public void parseImportRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseImportRule();
    }

    public void parseMediaRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseMediaRule();
    }

    public SelectorList parseSelectors(InputSource source)
        throws CSSException, IOException {
        // We don't use the org.w3c.css.sac.Selector interface (not easily extended to
        // SCSS syntax), so don't even try wrapping com.vaadin.sass.selector.Selectors 
        // into org.w3c.css.sac.Selector. Why do we implement org.w3c.css.sac.Parser at
        // all?
        return null;
    }

    public List<Selector> parseSCSSSelectors( InputSource source )
        throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));
        return _parseSelectors();
    }

    public LexicalUnit parsePropertyValue(InputSource source)
            throws CSSException, IOException {
        // We don't use the org.w3c.css.sac.Selector interface (not easily extended to
        // SCSS syntax), so don't even try wrapping com.vaadin.sass.selector.Selectors 
        // into org.w3c.css.sac.Selector. Why do we implement org.w3c.css.sac.Parser at
        // all?
        return null;
    }

    public boolean parsePriority(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        return prio();
    }

    /**
     * Convert the source into a Reader. Used only by DOM Level 2 parser methods.
     */
    private Reader getReader(InputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        } else if (source.getByteStream() != null) {
            // My DOM level 2 implementation doesn't use this case.
            if (source.getEncoding() == null) {
                // unknown encoding, use ASCII as default.
                return new InputStreamReader(source.getByteStream(), "ASCII");
            } else {
                return new InputStreamReader(source.getByteStream(),
                                             source.getEncoding());
            }
        } else {
            // systemId
            // @@TODO
            throw new CSSException("not yet implemented");
        }
    }

    /**
     * Convert the source into a CharStream with encoding informations.
     * The encoding can be found in the InputSource or in the CSS document.
     * Since this method marks the reader and make a reset after looking for
     * the charset declaration, you'll find the charset declaration into the
     * stream.  
     */
    private CharStream getCharStreamWithLurk(InputSource source)
            throws CSSException, IOException {
        if (source.getCharacterStream() != null) {
            // all encoding are supposed to be resolved by the user
            // return the reader
            return new Generic_CharStream(source.getCharacterStream(), 1, 1);
        } else if (source.getByteStream() == null) {
            // @@CONTINUE ME. see also getReader() with systemId
            try {
                source.setByteStream(new URL(source.getURI()).openStream());
            } catch (Exception e) {
                try {
                    source.setByteStream(new FileInputStream(source.getURI()));
                } catch (IOException ex) {
                    throw new CSSException("invalid url ?");
                }
            }
        }
        //use UTF-8 as the default encoding.
        String encoding = source.getEncoding();
        InputStream input = source.getByteStream();
        if (!input.markSupported()) {
            // If mark is not supported, wrap it in a stream which supports mark
            input = new BufferedInputStream(input);
            source.setByteStream(input);
        }
        // Mark either the original stream or the wrapped stream
        input.mark(100);
        if(encoding == null){
            encoding = "ASCII";

            char c = ' ';

            c = (char) input.read();

            if (c == '@') {
                // hum, is it a charset ?
                int size   = 100;
                byte[] buf = new byte[size];
                input.read(buf, 0, 7);
                String keyword = new String(buf, 0, 7);
                if (keyword.equals("charset")) {
                    // Yes, this is the charset declaration !

                    // here I don't use the right declaration : white space are ' '.
                    while ((c = (char) input.read()) == ' ') {
                        // find the first quote
                    }
                    char endChar = c;
                    int i = 0;

                    if ((endChar != '"') && (endChar != '\u005c'')) {
                        // hum this is not a quote.
                        throw new CSSException("invalid charset declaration");
                    }

                    while ((c = (char) input.read()) != endChar) {
                        buf[i++] = (byte) c;
                        if (i == size) {
                            byte[] old = buf;
                            buf = new byte[size + 100];
                            System.arraycopy(old, 0, buf, 0, size);
                            size += 100;
                        }
                    }
                    while ((c = (char) input.read()) == ' ') {
                        // find the next relevant character
                    }
                    if (c != ';') {
                        // no semi colon at the end ?
                        throw new CSSException("invalid charset declaration: "
                                           + "missing semi colon");
                    }
                    encoding = new String(buf, 0, i);
                    if (source.getEncoding() != null) {
                        // compare the two encoding informations.
                        // For example, I don't accept to have ASCII and after UTF-8.
                        // Is it really good ? That is the question.
                        if (!encoding.equals(source.getEncoding())) {
                            throw new CSSException("invalid encoding information.");
                        }
                    }
                } // else no charset declaration available
            }
        }
        // ok set the real encoding of this source.
        source.setEncoding(encoding);
        // set the real reader of this source.
        source.setCharacterStream(new InputStreamReader(source.getByteStream(),
                                             Encoding.getJavaEncoding(encoding)));
        // reset the stream (leave the charset declaration in the stream).
        input.reset();

        return new Generic_CharStream(source.getCharacterStream(), 1, 1);
    }

    private LocatorImpl currentLocator;
    private Locator getLocator() {
        if (currentLocator == null) {
            currentLocator = new LocatorImpl(this);
            return currentLocator;
        }
        return currentLocator.reInit(this);
    }
    private LocatorImpl getLocator(Token save) {
        if (currentLocator == null) {
            currentLocator = new LocatorImpl(this, save);
            return currentLocator;
        }
        return currentLocator.reInit(this, save);
    }

    private void reportError(Locator l, Exception e) {
        if (errorHandler != null) {
            if (e instanceof ParseException) {
                // construct a clean error message.
                ParseException pe = (ParseException) e;
                if (pe.specialConstructor) {
                    StringBuffer errorM = new StringBuffer();
                    if (pe.currentToken != null) {
                        errorM.append("encountered \u005c"")
                            .append(pe.currentToken.next);
                    }
                    errorM.append('"');
                    if (pe.expectedTokenSequences.length != 0) {
                        errorM.append(". Was expecting one of: ");
                        for (int i = 0; i < pe.expectedTokenSequences.length; i++) {
                            for (int j = 0; j < pe.expectedTokenSequences[i].length; j++) {
                                int kind = pe.expectedTokenSequences[i][j];
                                if (kind != S) {
                                    errorM.append(pe.tokenImage[kind]);
                                    errorM.append(' ');
                                }
                            }
                        }
                    }
                    errorHandler.error(new CSSParseException(errorM.toString(),
                                                             l, e));
                } else {
                    errorHandler.error(new CSSParseException(e.getMessage(),
                                                             l, e));
                }
            } else if (e == null) {
                errorHandler.error(new CSSParseException("error", l, null));
            } else {
                errorHandler.error(new CSSParseException(e.getMessage(), l, e));
            }
        }
    }

    private void reportWarningSkipText(Locator l, String text) {
        if (errorHandler != null && text  != null) {
            errorHandler.warning(new CSSParseException("Skipping: " + text, l));
        }
    }

/*
 * The grammar of CSS2
 */

/**
 * The main entry for the parser.
 *
 * @exception ParseException exception during the parse
 */
  final public void parserUnit() throws ParseException {
    try {
          documentHandler.startDocument(source);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHARSET_SYM:
        charset();
        break;
      default:
        jj_la1[0] = jj_gen;
        ;
      }
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_1;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          comments();
          break;
        case CDO:
        case CDC:
        case ATKEYWORD:
          ignoreStatement();
          break;
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      topLevelDeclaration();
      jj_consume_token(0);
    } finally {
        documentHandler.endDocument(source);
    }
  }

  final public void charset() throws ParseException {
  Token n;
    try {
      jj_consume_token(CHARSET_SYM);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_2;
        }
        jj_consume_token(S);
      }
      n = jj_consume_token(STRING);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_3;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[5] = jj_gen;
        acceptMissingSemicolon(EOF);
      }
    } catch (ParseException e) {
        reportError(getLocator(e.currentToken.next), e);
    skipStatement();
    // reportWarningSkipText(getLocator(), skipStatement());

    } catch (Exception e) {
        reportError(getLocator(), e);
    skipStatement();
    // reportWarningSkipText(getLocator(), skipStatement());

    }
  }

  final public void topLevelDeclaration() throws ParseException {
 String ret;
 Locator l;
    label_4:
    while (true) {
      ;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT_SYM:
        importDeclaration();
        break;
      case DEBUG_SYM:
      case WARN_SYM:
        debuggingDirective();
        break;
      case MIXIN_SYM:
        mixinDirective();
        break;
      case FUNCTION_SYM:
        functionDirective();
        break;
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
        controlDirective();
        break;
      case INCLUDE_SYM:
        includeDirective();
        break;
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case IDENT:
      case HASH:
        styleRule();
        break;
      case MEDIA_SYM:
        media();
        break;
      case PAGE_SYM:
        page();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      case KEY_FRAME_SYM:
        keyframes();
        break;
      case VARIABLE:
        variable();
        break;
      default:
        jj_la1[6] = jj_gen;
          l = getLocator();
        ret = skipStatement();
          if ((ret == null) || (ret.length() == 0)) {
              {if (true) return;}
          }
          if (ret.charAt(0) == '@') {
              documentHandler.unrecognizedRule(ret);
          } else {
              reportWarningSkipText(l, ret);
          }
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CDO:
        case CDC:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_5;
        }
        ignoreStatement();
        label_6:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[8] = jj_gen;
            break label_6;
          }
          jj_consume_token(S);
        }
      }
    }
  }

  final public void ignoreStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CDO:
      jj_consume_token(CDO);
      break;
    case CDC:
      jj_consume_token(CDC);
      break;
    case ATKEYWORD:
      atRuleDeclaration();
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * The import statement
 *
 * @exception ParseException exception during the parse
 */
  final public void importDeclaration() throws ParseException {
 Token n;
 String uri;
 MediaListImpl ml = new MediaListImpl();
 boolean isURL = false;
    try {
      jj_consume_token(IMPORT_SYM);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_7;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        n = jj_consume_token(STRING);
                               uri = convertStringIndex(n.image, 1,
                                                        n.image.length() -1);
        break;
      case URL:
        n = jj_consume_token(URL);
               isURL=true;
               uri = n.image.substring(4, n.image.length()-1).trim();
               if ((uri.charAt(0) == '"')
                   || (uri.charAt(0) == '\u005c'')) {
                   uri = uri.substring(1, uri.length()-1);
               }
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[12] = jj_gen;
          break label_8;
        }
        jj_consume_token(S);
      }
      mediaStatement(ml);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[13] = jj_gen;
        acceptMissingSemicolon(RBRACE, EOF);
      }
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[14] = jj_gen;
          break label_9;
        }
        jj_consume_token(S);
      }
               if (ml.getLength() == 0) {
                   // see section 6.3 of the CSS2 recommandation.
                   ml.addItem("all");
               }
               documentHandler.importStyle(uri, ml, isURL);
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void keyframes() throws ParseException {
    Token n;
    ArrayList<SassListItem> items = new ArrayList<SassListItem>();
    Interpolation i;
    boolean start = false;
    String keyframeName = null;
    try {
      n = jj_consume_token(KEY_FRAME_SYM);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
                              keyframeName = n.image;
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
        case OR:
        case NOT:
        case TO:
        case THROUGH:
        case EACH_IN:
        case FROM:
        case IDENT:
          n = ident();
                items.add(new StringItem(n.image));
          break;
        case START_INTERPOLATION:
          i = interpolation();
                                                                              items.add(i);
          break;
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
        case OR:
        case NOT:
        case START_INTERPOLATION:
        case TO:
        case THROUGH:
        case EACH_IN:
        case FROM:
        case IDENT:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_11;
        }
      }
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_12;
        }
        jj_consume_token(S);
      }
      start = true;
      StringInterpolationSequence animationName = new StringInterpolationSequence(items);
      documentHandler.startKeyFrames(keyframeName, animationName);
      jj_consume_token(LBRACE);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_13;
        }
        jj_consume_token(S);
      }
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TO:
        case FROM:
        case CONTENT_SYM:
        case PERCENTAGE:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_14;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TO:
        case FROM:
        case PERCENTAGE:
          keyframeSelector();
          break;
        case CONTENT_SYM:
          contentDirective();
          break;
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
    } finally {
     if (start) {
         documentHandler.endKeyFrames();
     }
    }
  }

  final public void keyframeSelector() throws ParseException {
    Token n;
    String selector = "";
    boolean start = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        n = jj_consume_token(FROM);
        break;
      case TO:
        n = jj_consume_token(TO);
        break;
      case PERCENTAGE:
        n = jj_consume_token(PERCENTAGE);
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                   selector += n.image;
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_16;
        }
        jj_consume_token(S);
      }
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[26] = jj_gen;
            break label_18;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          n = jj_consume_token(FROM);
          break;
        case TO:
          n = jj_consume_token(TO);
          break;
        case PERCENTAGE:
          n = jj_consume_token(PERCENTAGE);
          break;
        default:
          jj_la1[27] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                                    selector += (", " + n.image);
        label_19:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[28] = jj_gen;
            break label_19;
          }
          jj_consume_token(S);
        }
      }
      jj_consume_token(LBRACE);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[29] = jj_gen;
          break label_20;
        }
        jj_consume_token(S);
      }
          start = true;
          documentHandler.startKeyframeSelector(selector);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case MOD:
        case PARENT:
        case DOT:
        case AND:
        case OR:
        case NOT:
        case COLON:
        case START_INTERPOLATION:
        case THROUGH:
        case EACH_IN:
        case INCLUDE_SYM:
        case DEBUG_SYM:
        case WARN_SYM:
        case FOR_SYM:
        case EACH_SYM:
        case WHILE_SYM:
        case IF_SYM:
        case EXTEND_SYM:
        case CONTENT_SYM:
        case MICROSOFT_RULE:
        case IDENT:
        case VARIABLE:
        case HASH:
        case MEDIA_SYM:
        case KEY_FRAME_SYM:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[30] = jj_gen;
          break label_21;
        }
        ifContentStatement();
      }
      jj_consume_token(RBRACE);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_22;
        }
        jj_consume_token(S);
      }
    } catch (ThrowedParseException e) {
        if (errorHandler != null) {
            LocatorImpl li = new LocatorImpl(this,
                                             e.e.currentToken.next.beginLine,
                                             e.e.currentToken.next.beginColumn-1);
            reportError(li, e.e);
        }
    } catch (ParseException e) {
        reportError(getLocator(), e);
        skipStatement();
        // reportWarningSkipText(getLocator(), skipStatement());

    } catch (TokenMgrError e) {
        reportWarningSkipText(getLocator(), skipStatement());
    } finally {
        if (start) {
            documentHandler.endKeyframeSelector();
        }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
/* see http://www.w3.org/TR/css3-mediaqueries/ */
  final public void media() throws ParseException {
    boolean start = false;
    String ret;
    MediaListImpl ml = new MediaListImpl();
    try {
      jj_consume_token(MEDIA_SYM);
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_23;
        }
        jj_consume_token(S);
      }
      mediaStatement(ml);
     start = true; documentHandler.startMedia(ml);
      jj_consume_token(LBRACE);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_24;
        }
        jj_consume_token(S);
      }
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CDO:
        case DASHMATCH:
        case INCLUDES:
        case PLUS:
        case MINUS:
        case COMMA:
        case SEMICOLON:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case MOD:
        case PARENT:
        case DOT:
        case AND:
        case OR:
        case NOT:
        case COLON:
        case START_INTERPOLATION:
        case NONASCII:
        case THROUGH:
        case EACH_IN:
        case DEBUG_SYM:
        case WARN_SYM:
        case CONTENT_SYM:
        case LBRACE:
        case STRING:
        case NUMBER:
        case URL:
        case IDENT:
        case PERCENTAGE:
        case HASH:
        case IMPORT_SYM:
        case MEDIA_SYM:
        case CHARSET_SYM:
        case PAGE_SYM:
        case FONT_FACE_SYM:
        case ATKEYWORD:
        case IMPORTANT_SYM:
        case UNICODERANGE:
        case NOT_FUNCTION:
        case FUNCTION:
        case UNKNOWN:
          ;
          break;
        default:
          jj_la1[34] = jj_gen;
          break label_25;
        }
        mediaDirective();
      }
      jj_consume_token(RBRACE);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_26;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } finally {
     if (start) {
     documentHandler.endMedia(ml);
     }
    }
  }

  final public void mediaDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEBUG_SYM:
    case WARN_SYM:
      debuggingDirective();
      break;
    default:
      jj_la1[36] = jj_gen;
      if (jj_2_1(2)) {
        styleRule();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CDO:
        case DASHMATCH:
        case INCLUDES:
        case MINUS:
        case COMMA:
        case SEMICOLON:
        case NONASCII:
        case LBRACE:
        case STRING:
        case NUMBER:
        case URL:
        case PERCENTAGE:
        case IMPORT_SYM:
        case MEDIA_SYM:
        case CHARSET_SYM:
        case PAGE_SYM:
        case FONT_FACE_SYM:
        case ATKEYWORD:
        case IMPORTANT_SYM:
        case UNICODERANGE:
        case NOT_FUNCTION:
        case FUNCTION:
        case UNKNOWN:
          skipUnknownRule();
          break;
        case CONTENT_SYM:
          contentDirective();
          break;
        default:
          jj_la1[37] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void mediaStatement(MediaListImpl ml) throws ParseException {
  Token t;
      t = getToken(1);
      // loop over comma separated parts, add each to ml
      while ((t.kind != LBRACE) && (t.kind != EOF) && (t.kind != SEMICOLON)) {
        StringBuffer s = new StringBuffer();
        s.append(getToken(0).image);
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF) && (t.kind != SEMICOLON)) {
              s.append(t.image);
              getNextToken();
          t = getToken(1);
        }
        if (t.kind == COMMA) {
          // skip the comma and the token before it that is still the active token
          getNextToken();
          getNextToken();
          t = getToken(1);
        }
        String str = s.toString().trim();
        if (str.length() > 0) {
          ml.addItem(str);
        }
      }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String medium() throws ParseException {
 Token n;
    n = ident();
                {if (true) return convertIdent(n.image);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void page() throws ParseException {
 boolean start = false;
 Token n = null;
 String page = null;
 String pseudo = null;
    try {
      jj_consume_token(PAGE_SYM);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_27;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
      case OR:
      case NOT:
      case TO:
      case THROUGH:
      case EACH_IN:
      case FROM:
      case IDENT:
        n = ident();
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[39] = jj_gen;
            break label_28;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        pseudo = pseudo_page();
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
          if (n != null) {
              page = convertIdent(n.image);
          }
      jj_consume_token(LBRACE);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[42] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
          start = true;
          documentHandler.startPage(page, pseudo);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[43] = jj_gen;
        ;
      }
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_30;
        }
        jj_consume_token(SEMICOLON);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[45] = jj_gen;
            break label_31;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
        case AND:
        case OR:
        case NOT:
        case START_INTERPOLATION:
        case THROUGH:
        case EACH_IN:
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[46] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[47] = jj_gen;
          break label_32;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     if (errorHandler != null) {
         LocatorImpl li = new LocatorImpl(this,
                                          e.currentToken.next.beginLine,
                                          e.currentToken.next.beginColumn-1);
         reportError(li, e);
         skipStatement();
         // reportWarningSkipText(li, skipStatement());
     } else {
         skipStatement();
     }
    } finally {
     if (start) {
         documentHandler.endPage(page, pseudo);
     }
    }
  }

  final public String pseudo_page() throws ParseException {
  Token n;
    jj_consume_token(COLON);
    n = ident();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_33;
      }
      jj_consume_token(S);
    }
                             {if (true) return convertIdent(n.image);}
    throw new Error("Missing return statement in function");
  }

  final public void fontFace() throws ParseException {
    boolean start = false;
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[49] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[50] = jj_gen;
          break label_35;
        }
        jj_consume_token(S);
      }
        start = true; documentHandler.startFontFace();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case IDENT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
        case AND:
        case OR:
        case NOT:
        case START_INTERPOLATION:
        case THROUGH:
        case EACH_IN:
        case IDENT:
          declaration();
          break;
        case FOR_SYM:
        case EACH_SYM:
        case WHILE_SYM:
        case IF_SYM:
          controlDirective();
          break;
        default:
          jj_la1[51] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[53] = jj_gen;
          break label_36;
        }
        jj_consume_token(SEMICOLON);
        label_37:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[54] = jj_gen;
            break label_37;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
        case AND:
        case OR:
        case NOT:
        case START_INTERPOLATION:
        case THROUGH:
        case EACH_IN:
        case FOR_SYM:
        case EACH_SYM:
        case WHILE_SYM:
        case IF_SYM:
        case IDENT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case MINUS:
          case AND:
          case OR:
          case NOT:
          case START_INTERPOLATION:
          case THROUGH:
          case EACH_IN:
          case IDENT:
            declaration();
            break;
          case FOR_SYM:
          case EACH_SYM:
          case WHILE_SYM:
          case IF_SYM:
            controlDirective();
            break;
          default:
            jj_la1[55] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[56] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[57] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } finally {
     if (start) {
         documentHandler.endFontFace();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void atRuleDeclaration() throws ParseException {
 Token n;
 String ret;
    n = jj_consume_token(ATKEYWORD);
        ret=skipStatement();
        if ((ret != null) && (ret.charAt(0) == '@')) {
            documentHandler.unrecognizedRule(ret);
        } else {
            reportWarningSkipText(getLocator(), ret);
        }
  }

  final public void skipUnknownRule() throws ParseException {
  Token n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATKEYWORD:
      n = jj_consume_token(ATKEYWORD);
      break;
    case CDO:
      n = jj_consume_token(CDO);
      break;
    case CHARSET_SYM:
      n = jj_consume_token(CHARSET_SYM);
      break;
    case COMMA:
      n = jj_consume_token(COMMA);
      break;
    case DASHMATCH:
      n = jj_consume_token(DASHMATCH);
      break;
    case FONT_FACE_SYM:
      n = jj_consume_token(FONT_FACE_SYM);
      break;
    case FUNCTION:
      n = jj_consume_token(FUNCTION);
      break;
    case NOT_FUNCTION:
      n = jj_consume_token(NOT_FUNCTION);
      break;
    case IMPORTANT_SYM:
      n = jj_consume_token(IMPORTANT_SYM);
      break;
    case IMPORT_SYM:
      n = jj_consume_token(IMPORT_SYM);
      break;
    case INCLUDES:
      n = jj_consume_token(INCLUDES);
      break;
    case LBRACE:
      n = jj_consume_token(LBRACE);
      break;
    case MEDIA_SYM:
      n = jj_consume_token(MEDIA_SYM);
      break;
    case NONASCII:
      n = jj_consume_token(NONASCII);
      break;
    case NUMBER:
      n = jj_consume_token(NUMBER);
      break;
    case PAGE_SYM:
      n = jj_consume_token(PAGE_SYM);
      break;
    case PERCENTAGE:
      n = jj_consume_token(PERCENTAGE);
      break;
    case STRING:
      n = jj_consume_token(STRING);
      break;
    case UNICODERANGE:
      n = jj_consume_token(UNICODERANGE);
      break;
    case URL:
      n = jj_consume_token(URL);
      break;
    case SEMICOLON:
      n = jj_consume_token(SEMICOLON);
      break;
    case MINUS:
      n = jj_consume_token(MINUS);
      break;
    case UNKNOWN:
      n = jj_consume_token(UNKNOWN);
      break;
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     String ret;
     Locator loc = getLocator();
     ret=skipStatement();
     if ((ret != null) && (n.image.charAt(0) == '@')) {
         documentHandler.unrecognizedRule(ret);
     } else {
     reportWarningSkipText(loc, ret);
     }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public Combinator combinator() throws ParseException {
Combinator connector = Combinator.DESCENDANT;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case PRECEDES:
    case SIBLING:
      connector = combinatorChar();
      break;
    case S:
      jj_consume_token(S);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
        connector = combinatorChar();
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                               {if (true) return connector;}
    throw new Error("Missing return statement in function");
  }

/**to refactor combinator and reuse in selector().*/
  final public Combinator combinatorChar() throws ParseException {
 Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      t = jj_consume_token(PLUS);
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_39;
        }
        jj_consume_token(S);
      }
                         {if (true) return Combinator.SIBLING;}
      break;
    case PRECEDES:
      t = jj_consume_token(PRECEDES);
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[62] = jj_gen;
          break label_40;
        }
        jj_consume_token(S);
      }
                               {if (true) return Combinator.CHILD;}
      break;
    case SIBLING:
      t = jj_consume_token(SIBLING);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[63] = jj_gen;
          break label_41;
        }
        jj_consume_token(S);
      }
                              {if (true) return Combinator.GENERAL_SIBLING;}
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void microsoftExtension() throws ParseException {
  ArrayList<SassListItem> items = new ArrayList<SassListItem>();
  boolean lastIsSpace = true;
  Interpolation i;
  Token n;
  String name = "";
  String s;
    // This is not really taking the syntax of filter rules into account
      n = jj_consume_token(MICROSOFT_RULE);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[65] = jj_gen;
        break label_42;
      }
      jj_consume_token(S);
    }
                                    name = n.image;
    jj_consume_token(COLON);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
      case OR:
      case NOT:
      case TO:
      case THROUGH:
      case EACH_IN:
      case FROM:
      case IDENT:
        n = ident();
                    items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case NUMBER:
        n = jj_consume_token(NUMBER);
                        items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case STRING:
        n = jj_consume_token(STRING);
                        items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case COMMA:
        n = jj_consume_token(COMMA);
                       items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case START_INTERPOLATION:
        i = interpolation();
                             items.add(i); lastIsSpace = false;
        break;
      case COLON:
        n = jj_consume_token(COLON);
                       items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case NOT_FUNCTION:
        n = jj_consume_token(NOT_FUNCTION);
                              items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case FUNCTION:
        n = jj_consume_token(FUNCTION);
                          items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case RPARAN:
        n = jj_consume_token(RPARAN);
                        items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case EQ:
        n = jj_consume_token(EQ);
                    items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case DOT:
        n = jj_consume_token(DOT);
                     items.add(new StringItem(n.image)); lastIsSpace = false;
        break;
      case S:
        n = jj_consume_token(S);
                   if(!lastIsSpace) { items.add(new StringItem(n.image)); } lastIsSpace = true;
        break;
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case EQ:
      case COMMA:
      case DOT:
      case RPARAN:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case TO:
      case THROUGH:
      case EACH_IN:
      case FROM:
      case STRING:
      case NUMBER:
      case IDENT:
      case NOT_FUNCTION:
      case FUNCTION:
        ;
        break;
      default:
        jj_la1[67] = jj_gen;
        break label_43;
      }
    }
    jj_consume_token(SEMICOLON);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[68] = jj_gen;
        break label_44;
      }
      jj_consume_token(S);
    }
        StringInterpolationSequence value = new StringInterpolationSequence(items);
        documentHandler.microsoftDirective(name, value);
  }

  final public StringInterpolationSequence property() throws ParseException {
    StringInterpolationSequence sis;
    sis = ident_interpolation_seq();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_45;
      }
      jj_consume_token(S);
    }
                                               {if (true) return sis;}
    throw new Error("Missing return statement in function");
  }

  final public String identString() throws ParseException {
    Token t;
    t = propertyIdent();
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[70] = jj_gen;
        break label_46;
      }
      jj_consume_token(S);
    }
                                 {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public Token propertyIdent() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case IDENT:
      t = jj_consume_token(IDENT);
      break;
    case AND:
      t = jj_consume_token(AND);
      break;
    case OR:
      t = jj_consume_token(OR);
      break;
    case NOT:
      t = jj_consume_token(NOT);
      break;
    case EACH_IN:
      t = jj_consume_token(EACH_IN);
      break;
    case THROUGH:
      t = jj_consume_token(THROUGH);
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public String variableName() throws ParseException {
 Token n;
    n = jj_consume_token(VARIABLE);
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[72] = jj_gen;
        break label_47;
      }
      jj_consume_token(S);
    }
                         {if (true) return convertIdent(n.image.substring(1));}
    throw new Error("Missing return statement in function");
  }

  final public String functionName() throws ParseException {
 Token n;
    n = jj_consume_token(FUNCTION);
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[73] = jj_gen;
        break label_48;
      }
      jj_consume_token(S);
    }
                           {if (true) return convertIdent(n.image.substring(0, n.image.length()-1));}
    throw new Error("Missing return statement in function");
  }

  final public String functionNameWithWhitespace() throws ParseException {
 Token n;
    n = jj_consume_token(FUNCTION_WITH_WS);
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[74] = jj_gen;
        break label_49;
      }
      jj_consume_token(S);
    }
                                   {if (true) return convertIdent(n.image.substring(0, n.image.length()-1).trim());}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void styleRule() throws ParseException {
    boolean start = false;
    List<Selector> l = null;
    Token save;
    Locator loc;
    try {
      l = selectorList();
                        save = token;
      jj_consume_token(LBRACE);
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[75] = jj_gen;
          break label_50;
        }
        jj_consume_token(S);
      }
         start = true;
         documentHandler.startSelector(l);
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case MOD:
        case PARENT:
        case DOT:
        case AND:
        case OR:
        case NOT:
        case COLON:
        case START_INTERPOLATION:
        case THROUGH:
        case EACH_IN:
        case INCLUDE_SYM:
        case DEBUG_SYM:
        case WARN_SYM:
        case FOR_SYM:
        case EACH_SYM:
        case WHILE_SYM:
        case IF_SYM:
        case EXTEND_SYM:
        case CONTENT_SYM:
        case MICROSOFT_RULE:
        case IDENT:
        case VARIABLE:
        case HASH:
        case IMPORT_SYM:
        case MEDIA_SYM:
        case KEY_FRAME_SYM:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[76] = jj_gen;
          break label_51;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case MOD:
        case PARENT:
        case DOT:
        case AND:
        case OR:
        case NOT:
        case COLON:
        case START_INTERPOLATION:
        case THROUGH:
        case EACH_IN:
        case INCLUDE_SYM:
        case DEBUG_SYM:
        case WARN_SYM:
        case FOR_SYM:
        case EACH_SYM:
        case WHILE_SYM:
        case IF_SYM:
        case EXTEND_SYM:
        case CONTENT_SYM:
        case MICROSOFT_RULE:
        case IDENT:
        case VARIABLE:
        case HASH:
        case MEDIA_SYM:
        case KEY_FRAME_SYM:
        case ATKEYWORD:
          ifContentStatement();
          break;
        case IMPORT_SYM:
          importDeclaration();
          break;
        default:
          jj_la1[77] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_52:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[78] = jj_gen;
          break label_52;
        }
        jj_consume_token(S);
      }
    } catch (ThrowedParseException e) {
     if (errorHandler != null) {
         LocatorImpl li = new LocatorImpl(this,
                                          e.e.currentToken.next.beginLine,
                                          e.e.currentToken.next.beginColumn-1);
         reportError(li, e.e);
     }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } catch (TokenMgrError e) {
     reportWarningSkipText(getLocator(), skipStatement());
    } finally {
     if (start) {
         documentHandler.endSelector();
     }
    }
  }

  final public List<Selector> selectorList() throws ParseException {
    List<Selector> selectors = new  ArrayList<Selector>();
    Selector selector;
    selector = selector();
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[79] = jj_gen;
        break label_53;
      }
      jj_consume_token(COMMA);
      label_54:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[80] = jj_gen;
          break label_54;
        }
        jj_consume_token(S);
      }
                                        selectors.add(selector);
      selector = selector();
    }
    selectors.add(selector);
    {if (true) return selectors;}
    throw new Error("Missing return statement in function");
  }

  final public Selector selector() throws ParseException {
  Selector selector;
  SimpleSelectorSequence seq;
  Combinator comb = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case PRECEDES:
    case SIBLING:
      comb = combinatorChar();
      break;
    default:
      jj_la1[81] = jj_gen;
      ;
    }
    seq = simple_selector_sequence();
                                                            selector = (comb==null) ? new Selector(seq) : new Selector(comb,seq);
    label_55:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_55;
      }
      comb = combinator();
      seq = simple_selector_sequence();
                                                                   selector = selector.createNested(comb,seq);
    }
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[82] = jj_gen;
        break label_56;
      }
      jj_consume_token(S);
    }
    {if (true) return selector;}
    throw new Error("Missing return statement in function");
  }

  final public SimpleSelectorSequence simple_selector_sequence() throws ParseException {
  SimpleSelector simple = null;
  ArrayList<SimpleSelector> list = new ArrayList<SimpleSelector>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
    case MOD:
    case DOT:
    case COLON:
    case HASH:
      label_57:
      while (true) {
        simple = simple_nontype_selector();
                                       list.add(simple);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
        case MOD:
        case DOT:
        case COLON:
        case HASH:
          ;
          break;
        default:
          jj_la1[83] = jj_gen;
          break label_57;
        }
      }
      break;
    case MINUS:
    case ANY:
    case PARENT:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case THROUGH:
    case EACH_IN:
    case IDENT:
      simple = type_selector();
                              list.add(simple);
      label_58:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
        case MOD:
        case DOT:
        case COLON:
        case HASH:
          ;
          break;
        default:
          jj_la1[84] = jj_gen;
          break label_58;
        }
        simple = simple_nontype_selector();
                                                                                      list.add(simple);
      }
      break;
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return new SimpleSelectorSequence(list);}
    throw new Error("Missing return statement in function");
  }

  final public SimpleSelector simple_nontype_selector() throws ParseException {
  SimpleSelector s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      s = class_selector();
      break;
    case MOD:
      s = placeholder_selector();
      break;
    case HASH:
      s = id_selector();
      break;
    case COLON:
      s = pseudo_selector();
      break;
    case LBRACKET:
      s = attribute_selector();
      break;
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public StringInterpolationSequence ident_interpolation_seq() throws ParseException {
  Token t;
  List<SassListItem> items = new ArrayList<SassListItem>();
  Interpolation interp;
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case AND:
      case OR:
      case NOT:
      case THROUGH:
      case EACH_IN:
      case IDENT:
        t = propertyIdent();
                      items.add(new StringItem(t.image));
        break;
      case START_INTERPOLATION:
        interp = interpolation();
                                                                                     items.add(interp);
        break;
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case IDENT:
        ;
        break;
      default:
        jj_la1[88] = jj_gen;
        break label_59;
      }
    }
    {if (true) return new StringInterpolationSequence(items);}
    throw new Error("Missing return statement in function");
  }

  final public SimpleSelector class_selector() throws ParseException {
  StringInterpolationSequence s;
    jj_consume_token(DOT);
    s = ident_interpolation_seq();
                                    {if (true) return new ClassSelector(s);}
    throw new Error("Missing return statement in function");
  }

  final public SimpleSelector placeholder_selector() throws ParseException {
  StringInterpolationSequence s;
    jj_consume_token(MOD);
    s = ident_interpolation_seq();
                                    {if (true) return new PlaceholderSelector(s);}
    throw new Error("Missing return statement in function");
  }

  final public TypeSelector type_selector() throws ParseException {
  StringInterpolationSequence s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case THROUGH:
    case EACH_IN:
    case IDENT:
      s = ident_interpolation_seq();
                                {if (true) return new TypeSelector(s);}
      break;
    case ANY:
      jj_consume_token(ANY);
          {if (true) return UniversalSelector.it;}
      break;
    case PARENT:
      jj_consume_token(PARENT);
          {if (true) return ParentSelector.it;}
      break;
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public AttributeSelector attribute_selector() throws ParseException {
    int cases = 0;
    StringInterpolationSequence att = null;
    Token val = null;
    StringInterpolationSequence attValue = null;
    AttributeSelector.MatchRelation matchRelation = null;
    jj_consume_token(LBRACKET);
    label_60:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[90] = jj_gen;
        break label_60;
      }
      jj_consume_token(S);
    }
    att = ident_interpolation_seq();
    label_61:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[91] = jj_gen;
        break label_61;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DASHMATCH:
    case PREFIXMATCH:
    case SUFFIXMATCH:
    case SUBSTRINGMATCH:
    case INCLUDES:
    case EQ:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
                          matchRelation = AttributeSelector.MatchRelation.EQUALS;
        break;
      case INCLUDES:
        jj_consume_token(INCLUDES);
                      matchRelation = AttributeSelector.MatchRelation.INCLUDES;
        break;
      case DASHMATCH:
        jj_consume_token(DASHMATCH);
                      matchRelation = AttributeSelector.MatchRelation.DASHMATCH;
        break;
      case PREFIXMATCH:
        jj_consume_token(PREFIXMATCH);
                        matchRelation = AttributeSelector.MatchRelation.PREFIXMATCH;
        break;
      case SUFFIXMATCH:
        jj_consume_token(SUFFIXMATCH);
                        matchRelation = AttributeSelector.MatchRelation.SUFFIXMATCH;
        break;
      case SUBSTRINGMATCH:
        jj_consume_token(SUBSTRINGMATCH);
                           matchRelation = AttributeSelector.MatchRelation.SUBSTRINGMATCH;
        break;
      default:
        jj_la1[92] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_62:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[93] = jj_gen;
          break label_62;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case IDENT:
        attValue = ident_interpolation_seq();
        break;
      case STRING:
        val = jj_consume_token(STRING);
                       attValue = new StringInterpolationSequence(val.image);
        break;
      default:
        jj_la1[94] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[95] = jj_gen;
          break label_63;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
      {if (true) return new AttributeSelector(att,matchRelation,attValue);}
    throw new Error("Missing return statement in function");
  }

  final public SimpleSelector pseudo_selector() throws ParseException {
    Token n;
    StringInterpolationSequence id;
    String s;
    Token t;
    String arg = null;
    Selector sel;
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      id = ident_interpolation_seq();
              {if (true) return new PseudoElementSelector(id);}
      break;
    case MINUS:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case THROUGH:
    case EACH_IN:
    case IDENT:
      id = ident_interpolation_seq();
              {if (true) return new PseudoClassSelector(id);}
      break;
    case NOT_FUNCTION:
      t = jj_consume_token(NOT_FUNCTION);
      sel = selector();
      jj_consume_token(RPARAN);
              s = t.image;
              s = s.substring(0, s.length() - 1);
              id = new StringInterpolationSequence(s);
              {if (true) return new PseudoClassSelector(id, sel.toString());}
      break;
    case FUNCTION:
      s = functionName();
      arg = pseudo_params();
      jj_consume_token(RPARAN);
              {if (true) return new PseudoClassSelector(new StringInterpolationSequence(s),arg);}
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String pseudo_params() throws ParseException {
  String params = "";
  Token t;
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case NUMBER:
      case IDENT:
      case DIMEN:
        ;
        break;
      default:
        jj_la1[98] = jj_gen;
        break label_64;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case DIMEN:
        t = jj_consume_token(DIMEN);
        break;
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      case IDENT:
        t = jj_consume_token(IDENT);
        break;
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                                                  params = params + t.image;
      label_65:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[100] = jj_gen;
          break label_65;
        }
        t = jj_consume_token(S);
                    params = params + t.image;
      }
    }
        {if (true) return params;}
    throw new Error("Missing return statement in function");
  }

  final public IdSelector id_selector() throws ParseException {
  ArrayList<SassListItem> items = new ArrayList<SassListItem>();
  ArrayList<SassListItem> iis;
  Token t;
    t = jj_consume_token(HASH);
               items.add(new StringItem(t.image.substring(1)));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case TO:
    case THROUGH:
    case EACH_IN:
    case FROM:
    case MICROSOFT_RULE:
    case IDENT:
      iis = identInterpolationString();
                                       items.addAll(iis);
      break;
    default:
      jj_la1[101] = jj_gen;
      ;
    }
    {if (true) return new IdSelector(new StringInterpolationSequence(items));}
    throw new Error("Missing return statement in function");
  }

  final public void variable() throws ParseException {
    String name;
    SassList l = null;
    boolean guarded = false;
    String raw;
    try {
      name = variableName();
      jj_consume_token(COLON);
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[102] = jj_gen;
          break label_66;
        }
        jj_consume_token(S);
      }
      l = expressionList();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GUARDED_SYM:
        guarded = guarded();
        break;
      default:
        jj_la1[103] = jj_gen;
        ;
      }
      semicolonTerminator();
            documentHandler.variable(name, l.flatten(), guarded);
    } catch (JumpException e) {
        skipAfterExpression();
    } catch (NumberFormatException e) {
        if (errorHandler != null) {
            errorHandler.error(new CSSParseException("Invalid number "
                               + e.getMessage(), getLocator(), e));
        }
        reportWarningSkipText(getLocator(), skipAfterExpression());
    } catch (ParseException e) {
        if (errorHandler != null) {
            if (e.currentToken != null) {
                LocatorImpl li = new LocatorImpl(this,
                              e.currentToken.next.beginLine,
                              e.currentToken.next.beginColumn-1);
                reportError(li, e);
            } else {
                reportError(getLocator(), e);
            }
            skipAfterExpression();
        } else {
        skipAfterExpression();
        }
    }
  }

  final public SassList expressionList() throws ParseException {
    // Nonempty parenthesized lists are not supported yet.
    List<SassListItem> primaryList = new ArrayList<SassListItem>();
    int line = token.beginLine;
    int column = token.beginColumn;
    SassList subList;
    subList = expressionSubList();
                                   primaryList.add(subList);
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[104] = jj_gen;
        break label_67;
      }
      jj_consume_token(COMMA);
      label_68:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[105] = jj_gen;
          break label_68;
        }
        jj_consume_token(S);
      }
      subList = expressionSubList();
                                                    primaryList.add(subList);
    }
        SassList result = new SassList(SassList.Separator.COMMA, primaryList);
        result.setSourcePosition(line, column);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public SassList expressionSubList() throws ParseException {
    // Nonempty parenthesized lists are not supported yet.
    SassListItem item;
    List<SassListItem> list = new ArrayList<SassListItem>();
    int line = token.beginLine;
    int column = token.beginColumn;
    if (jj_2_4(3)) {
      jj_consume_token(LPARAN);
      label_69:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[106] = jj_gen;
          break label_69;
        }
        jj_consume_token(S);
      }
      jj_consume_token(RPARAN);
      label_70:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[107] = jj_gen;
          break label_70;
        }
        jj_consume_token(S);
      }
        {if (true) return new SassList(SassList.Separator.SPACE);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case DOT:
      case LPARAN:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case TO:
      case THROUGH:
      case EACH_IN:
      case FROM:
      case MICROSOFT_RULE:
      case STRING:
      case NUMBER:
      case URL:
      case IDENT:
      case VARIABLE:
      case PERCENTAGE:
      case PT:
      case MM:
      case CM:
      case PC:
      case IN:
      case PX:
      case EMS:
      case LEM:
      case REM:
      case EXS:
      case DEG:
      case RAD:
      case GRAD:
      case MS:
      case SECOND:
      case HZ:
      case KHZ:
      case DIMEN:
      case HASH:
      case UNICODERANGE:
      case NOT_FUNCTION:
      case FUNCTION:
        label_71:
        while (true) {
          item = expr();
                                   list.add(item);
          if (jj_2_3(2)) {
            ;
          } else {
            break label_71;
          }
        }
        SassList result = new SassList(SassList.Separator.SPACE, list);
        result.setSourcePosition(line, column);
        {if (true) return result;}
        break;
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void controlDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF_SYM:
      ifDirective();
      break;
    case EACH_SYM:
      eachDirective();
      break;
    case FOR_SYM:
      forDirective();
      break;
    case WHILE_SYM:
      whileDirective();
      break;
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ifContentStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONTENT_SYM:
      contentDirective();
      break;
    case INCLUDE_SYM:
      includeDirective();
      break;
    case MEDIA_SYM:
      media();
      break;
    case EXTEND_SYM:
      extendDirective();
      break;
    case PLUS:
    case MINUS:
    case PRECEDES:
    case SIBLING:
    case LBRACKET:
    case ANY:
    case MOD:
    case PARENT:
    case DOT:
    case AND:
    case OR:
    case NOT:
    case COLON:
    case START_INTERPOLATION:
    case THROUGH:
    case EACH_IN:
    case DEBUG_SYM:
    case WARN_SYM:
    case IDENT:
    case HASH:
      styleRuleOrDeclarationOrNestedProperties();
      break;
    case KEY_FRAME_SYM:
      keyframes();
      break;
    case VARIABLE:
      variable();
      break;
    case FOR_SYM:
    case EACH_SYM:
    case WHILE_SYM:
    case IF_SYM:
      controlDirective();
      break;
    case ATKEYWORD:
      atRuleDeclaration();
      break;
    case MICROSOFT_RULE:
      microsoftExtension();
      break;
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ifDirective() throws ParseException {
  SassList list;
  SassListItem evaluator = null;
    jj_consume_token(IF_SYM);
    label_72:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[111] = jj_gen;
        break label_72;
      }
      jj_consume_token(S);
    }
    list = expressionSubList();
                                 evaluator = list.flatten();
    jj_consume_token(LBRACE);
    label_73:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[112] = jj_gen;
        break label_73;
      }
      jj_consume_token(S);
    }
    documentHandler.startIfElseDirective();
    documentHandler.ifDirective(evaluator);
    label_74:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[113] = jj_gen;
        break label_74;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      default:
        jj_la1[114] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_75:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[115] = jj_gen;
        break label_75;
      }
      jj_consume_token(S);
    }
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE_SYM:
      case ELSEIF_SYM:
        ;
        break;
      default:
        jj_la1[116] = jj_gen;
        break label_76;
      }
      elseDirective();
    }
    documentHandler.endIfElseDirective();
  }

  final public void elseDirective() throws ParseException {
  SassList list;
  SassListItem evaluator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSEIF_SYM:
      jj_consume_token(ELSEIF_SYM);
      label_77:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[117] = jj_gen;
          break label_77;
        }
        jj_consume_token(S);
      }
      list = expressionSubList();
                                                     evaluator = list.flatten();
      break;
    case ELSE_SYM:
      jj_consume_token(ELSE_SYM);
      label_78:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[118] = jj_gen;
          break label_78;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IF:
        jj_consume_token(IF);
        label_79:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[119] = jj_gen;
            break label_79;
          }
          jj_consume_token(S);
        }
        list = expressionSubList();
                                                   evaluator = list.flatten();
        break;
      default:
        jj_la1[120] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_80:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_80;
      }
      jj_consume_token(S);
    }
    if(evaluator != null){ documentHandler.ifDirective(evaluator); }
    else{ documentHandler.elseDirective(); }
    label_81:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[123] = jj_gen;
        break label_81;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      default:
        jj_la1[124] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_82:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[125] = jj_gen;
        break label_82;
      }
      jj_consume_token(S);
    }
  }

  final public void eachDirective() throws ParseException {
    Token var;
    SassList list = null;
    jj_consume_token(EACH_SYM);
    label_83:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[126] = jj_gen;
        break label_83;
      }
      jj_consume_token(S);
    }
    var = jj_consume_token(VARIABLE);
    label_84:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[127] = jj_gen;
        break label_84;
      }
      jj_consume_token(S);
    }
    jj_consume_token(EACH_IN);
    label_85:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[128] = jj_gen;
        break label_85;
      }
      jj_consume_token(S);
    }
    list = expressionList();
                              documentHandler.startEachDirective(var.image, list.flatten());
    jj_consume_token(LBRACE);
    label_86:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[129] = jj_gen;
        break label_86;
      }
      jj_consume_token(S);
    }
    label_87:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[130] = jj_gen;
        break label_87;
      }
      ifContentStatement();
    }
    jj_consume_token(RBRACE);
    label_88:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[131] = jj_gen;
        break label_88;
      }
      jj_consume_token(S);
    }
      documentHandler.endEachDirective();
  }

  final public void mixinDirective() throws ParseException {
    String name;
    ArrayList<Variable> args = null;
    boolean hasVariableArgs = false;
    jj_consume_token(MIXIN_SYM);
    label_89:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[132] = jj_gen;
        break label_89;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case AND:
    case OR:
    case NOT:
    case THROUGH:
    case EACH_IN:
    case IDENT:
      name = identString();
      break;
    case FUNCTION_WITH_WS:
      name = functionNameWithWhitespace();
      args = arglist();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
                       hasVariableArgs = true;
        label_90:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[133] = jj_gen;
            break label_90;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      jj_consume_token(RPARAN);
      label_91:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[135] = jj_gen;
          break label_91;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_92:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[137] = jj_gen;
        break label_92;
      }
      jj_consume_token(S);
    }
     documentHandler.startMixinDirective(name, args, hasVariableArgs);
    label_93:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case PAGE_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[138] = jj_gen;
        break label_93;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      case PAGE_SYM:
        page();
        break;
      default:
        jj_la1[139] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_94:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[140] = jj_gen;
        break label_94;
      }
      jj_consume_token(S);
    }
     documentHandler.endMixinDirective();
  }

  final public void functionDirective() throws ParseException {
    String name;
    ArrayList<Variable> args = null;
    boolean hasVariableArgs = false;
    jj_consume_token(FUNCTION_SYM);
    label_95:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[141] = jj_gen;
        break label_95;
      }
      jj_consume_token(S);
    }
    name = functionNameWithWhitespace();
    args = arglist();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELLIPSIS:
      jj_consume_token(ELLIPSIS);
                                                                        hasVariableArgs = true;
      label_96:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[142] = jj_gen;
          break label_96;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[143] = jj_gen;
      ;
    }
    jj_consume_token(RPARAN);
    label_97:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[144] = jj_gen;
        break label_97;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LBRACE);
    label_98:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[145] = jj_gen;
        break label_98;
      }
      jj_consume_token(S);
    }
     documentHandler.startFunctionDirective(name, args, hasVariableArgs);
    label_99:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[146] = jj_gen;
        break label_99;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_100:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[147] = jj_gen;
        break label_100;
      }
      jj_consume_token(S);
    }
     documentHandler.endFunctionDirective();
  }

  final public void functionBlockStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARIABLE:
      variable();
      break;
    case FOR_SYM:
    case EACH_SYM:
    case WHILE_SYM:
    case IF_SYM:
      functionControlDirective();
      break;
    case RETURN_SYM:
      returnDirective();
      break;
    case DEBUG_SYM:
    case WARN_SYM:
      debuggingDirective();
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void functionControlDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF_SYM:
      functionIfDirective();
      break;
    case EACH_SYM:
      functionEachDirective();
      break;
    case FOR_SYM:
      functionForDirective();
      break;
    case WHILE_SYM:
      functionWhileDirective();
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void functionIfDirective() throws ParseException {
  SassList list;
  SassListItem condition;
    jj_consume_token(IF_SYM);
    label_101:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[150] = jj_gen;
        break label_101;
      }
      jj_consume_token(S);
    }
    list = expressionSubList();
                                condition = list.flatten();
    jj_consume_token(LBRACE);
    label_102:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[151] = jj_gen;
        break label_102;
      }
      jj_consume_token(S);
    }
    documentHandler.startIfElseDirective();
    documentHandler.ifDirective(condition);
    label_103:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[152] = jj_gen;
        break label_103;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_104:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[153] = jj_gen;
        break label_104;
      }
      jj_consume_token(S);
    }
    label_105:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE_SYM:
      case ELSEIF_SYM:
        ;
        break;
      default:
        jj_la1[154] = jj_gen;
        break label_105;
      }
      functionElseDirective();
    }
    documentHandler.endIfElseDirective();
  }

  final public void functionElseDirective() throws ParseException {
  SassList list;
  SassListItem condition = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSEIF_SYM:
      jj_consume_token(ELSEIF_SYM);
      label_106:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[155] = jj_gen;
          break label_106;
        }
        jj_consume_token(S);
      }
      list = expressionSubList();
                                                     condition = list.flatten();
      break;
    case ELSE_SYM:
      jj_consume_token(ELSE_SYM);
      label_107:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[156] = jj_gen;
          break label_107;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IF:
        jj_consume_token(IF);
        label_108:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[157] = jj_gen;
            break label_108;
          }
          jj_consume_token(S);
        }
        list = expressionSubList();
                                                  condition = list.flatten();
        break;
      default:
        jj_la1[158] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[159] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_109:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[160] = jj_gen;
        break label_109;
      }
      jj_consume_token(S);
    }
    if(condition != null){ documentHandler.ifDirective(condition); }
    else{ documentHandler.elseDirective(); }
    label_110:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[161] = jj_gen;
        break label_110;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_111:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[162] = jj_gen;
        break label_111;
      }
      jj_consume_token(S);
    }
  }

  final public void functionEachDirective() throws ParseException {
    Token var;
    SassList list = null;
    jj_consume_token(EACH_SYM);
    label_112:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[163] = jj_gen;
        break label_112;
      }
      jj_consume_token(S);
    }
    var = jj_consume_token(VARIABLE);
    label_113:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[164] = jj_gen;
        break label_113;
      }
      jj_consume_token(S);
    }
    jj_consume_token(EACH_IN);
    label_114:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[165] = jj_gen;
        break label_114;
      }
      jj_consume_token(S);
    }
    list = expressionList();
                              documentHandler.startEachDirective(var.image, list.flatten());
    jj_consume_token(LBRACE);
    label_115:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[166] = jj_gen;
        break label_115;
      }
      jj_consume_token(S);
    }
    label_116:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[167] = jj_gen;
        break label_116;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_117:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[168] = jj_gen;
        break label_117;
      }
      jj_consume_token(S);
    }
      documentHandler.endEachDirective();
  }

  final public void functionForDirective() throws ParseException {
  String var;
  SassListItem from;
  SassListItem to;
    jj_consume_token(FOR_SYM);
    label_118:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[169] = jj_gen;
        break label_118;
      }
      jj_consume_token(S);
    }
    var = variableName();
    jj_consume_token(FROM);
    label_119:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[170] = jj_gen;
        break label_119;
      }
      jj_consume_token(S);
    }
    from = numericExpr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TO:
      jj_consume_token(TO);
      label_120:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[171] = jj_gen;
          break label_120;
        }
        jj_consume_token(S);
      }
      to = numericExpr();
        documentHandler.startForDirective(var, from, to, true);
      break;
    case THROUGH:
      jj_consume_token(THROUGH);
      label_121:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[172] = jj_gen;
          break label_121;
        }
        jj_consume_token(S);
      }
      to = numericExpr();
        documentHandler.startForDirective(var, from, to, false);
      break;
    default:
      jj_la1[173] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_122:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[174] = jj_gen;
        break label_122;
      }
      jj_consume_token(S);
    }
    label_123:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[175] = jj_gen;
        break label_123;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_124:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[176] = jj_gen;
        break label_124;
      }
      jj_consume_token(S);
    }
    documentHandler.endForDirective();
  }

  final public void functionWhileDirective() throws ParseException {
  SassList list;
  SassListItem evaluator;
    jj_consume_token(WHILE_SYM);
    label_125:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[177] = jj_gen;
        break label_125;
      }
      jj_consume_token(S);
    }
    list = expressionSubList();
                                 evaluator = list.flatten();
    jj_consume_token(LBRACE);
    label_126:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[178] = jj_gen;
        break label_126;
      }
      jj_consume_token(S);
    }
    documentHandler.startWhileDirective(evaluator);
    label_127:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[179] = jj_gen;
        break label_127;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_128:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[180] = jj_gen;
        break label_128;
      }
      jj_consume_token(S);
    }
    documentHandler.endWhileDirective();
  }

  final public ArrayList<Variable> arglist() throws ParseException {
    ArrayList<Variable> args = new ArrayList<Variable>();
    Variable arg;
    boolean hasOptionalArguments = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARIABLE:
      arg = mixinArg();
      label_129:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[181] = jj_gen;
          break label_129;
        }
        jj_consume_token(COMMA);
        label_130:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[182] = jj_gen;
            break label_130;
          }
          jj_consume_token(S);
        }
                             hasOptionalArguments = checkMixinForOptionalArguments(arg,
                                              hasOptionalArguments); args.add(arg);
        arg = mixinArg();
      }
          hasOptionalArguments = checkMixinForOptionalArguments(arg, hasOptionalArguments); args.add(arg);
      break;
    default:
      jj_la1[183] = jj_gen;
      ;
    }
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

// This method is used for checking whether the argument list of a mixin is legal. No required
// arguments should come after an optional argument. An argument is optional if it has a
// default value.
  boolean checkMixinForOptionalArguments(Variable arg, boolean hasOptionalArguments) throws ParseException {
    boolean argumentHasDefaultValue = (arg.getExpr() != null);
    if(argumentHasDefaultValue){
        return true;
    }
    else if(hasOptionalArguments){
        throw new ParseException("Sass Error: Required argument $"+ arg.getName() +" must come "
                                  +  "before any optional arguments.");
    }
    else{
        return false;
    }
  }

  final public Variable mixinArg() throws ParseException {
    String name;
    SassList l = null;
    name = variableName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      label_131:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[184] = jj_gen;
          break label_131;
        }
        jj_consume_token(S);
      }
                                             l = expressionSubList();
      break;
    default:
      jj_la1[185] = jj_gen;
      ;
    }
        SassListItem argItem = (l == null ? null : l.flatten());
        Variable arg = new Variable(name, argItem);
        {if (true) return arg;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<Variable> argValuelist() throws ParseException {
    ArrayList<Variable> args = new ArrayList<Variable>();
    Variable current;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case DOT:
    case LPARAN:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case TO:
    case THROUGH:
    case EACH_IN:
    case FROM:
    case MICROSOFT_RULE:
    case STRING:
    case NUMBER:
    case URL:
    case IDENT:
    case VARIABLE:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case HASH:
    case UNICODERANGE:
    case NOT_FUNCTION:
    case FUNCTION:
      current = argValueListItem();
                                   args.add(current);
      label_132:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[186] = jj_gen;
          break label_132;
        }
        jj_consume_token(COMMA);
        label_133:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[187] = jj_gen;
            break label_133;
          }
          jj_consume_token(S);
        }
        current = argValueListItem();
                                                     args.add(current);
      }
      break;
    default:
      jj_la1[188] = jj_gen;
      ;
    }
     {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public Variable argValueListItem() throws ParseException {
    LexicalUnitImpl unit;
    String name = null;
    SassList value = null;
    if (jj_2_5(3)) {
      name = variableName();
      jj_consume_token(COLON);
      label_134:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[189] = jj_gen;
          break label_134;
        }
        jj_consume_token(S);
      }
      value = expressionSubList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case DOT:
      case LPARAN:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case TO:
      case THROUGH:
      case EACH_IN:
      case FROM:
      case MICROSOFT_RULE:
      case STRING:
      case NUMBER:
      case URL:
      case IDENT:
      case VARIABLE:
      case PERCENTAGE:
      case PT:
      case MM:
      case CM:
      case PC:
      case IN:
      case PX:
      case EMS:
      case LEM:
      case REM:
      case EXS:
      case DEG:
      case RAD:
      case GRAD:
      case MS:
      case SECOND:
      case HZ:
      case KHZ:
      case DIMEN:
      case HASH:
      case UNICODERANGE:
      case NOT_FUNCTION:
      case FUNCTION:
        value = expressionSubList();
        break;
      default:
        jj_la1[190] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        SassListItem flattenedValue = value.flatten();
        {if (true) return new Variable(name, flattenedValue);}
    throw new Error("Missing return statement in function");
  }

  final public void returnDirective() throws ParseException {
    SassList expr;
    jj_consume_token(RETURN_SYM);
    label_135:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[191] = jj_gen;
        break label_135;
      }
      jj_consume_token(S);
    }
    expr = expressionList();
    semicolonTerminator();
      documentHandler.returnDirective(expr.flatten());
  }

  final public void includeDirective() throws ParseException {
    String name;
    ArrayList<Variable> args=null;
    boolean hasVariableArgs = false;
    jj_consume_token(INCLUDE_SYM);
    label_136:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[192] = jj_gen;
        break label_136;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case AND:
    case OR:
    case NOT:
    case THROUGH:
    case EACH_IN:
    case IDENT:
      name = identString();
      break;
    case VARIABLE:
      name = variableName();
                                                   name = "$"+name;
      break;
    case FUNCTION_WITH_WS:
      name = functionNameWithWhitespace();
      args = argValuelist();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
                                                                                 hasVariableArgs = true;
        label_137:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[193] = jj_gen;
            break label_137;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[194] = jj_gen;
        ;
      }
      jj_consume_token(RPARAN);
      label_138:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[195] = jj_gen;
          break label_138;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     documentHandler.startInclude(name, args, hasVariableArgs);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      includeDirectiveBlockContents();
      break;
    default:
      jj_la1[197] = jj_gen;
      semicolonTerminator();
    }
     documentHandler.endInclude();
  }

  final public void semicolonTerminator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      label_139:
      while (true) {
        jj_consume_token(SEMICOLON);
        label_140:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[198] = jj_gen;
            break label_140;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[199] = jj_gen;
          break label_139;
        }
      }
      break;
    default:
      jj_la1[200] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
  }

  void acceptMissingSemicolon(Integer... acceptedTerminators) throws ParseException, ParseException {
    Token next = getToken(1);
    ArrayList<Integer> terminators = new ArrayList<Integer>(Arrays.asList(acceptedTerminators));
    if (!terminators.contains(next.kind)){
        String message = "encountered \u005c"" + next.image + "\u005c". Was expecting one of \u005c";\u005c"";
        for(int term : acceptedTerminators){
            message += ", " + tokenImage[term];
        }
        ParseException e = new ParseException(message);
        throw e;
    }
  }

  final public void includeDirectiveBlockContents() throws ParseException {
    jj_consume_token(LBRACE);
    label_141:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[201] = jj_gen;
        break label_141;
      }
      jj_consume_token(S);
    }
    label_142:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case TO:
      case THROUGH:
      case EACH_IN:
      case FROM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case IDENT:
      case PERCENTAGE:
      case HASH:
        ;
        break;
      default:
        jj_la1[202] = jj_gen;
        break label_142;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case DEBUG_SYM:
      case WARN_SYM:
      case IDENT:
      case HASH:
        styleRuleOrDeclarationOrNestedProperties();
        break;
      case TO:
      case FROM:
      case PERCENTAGE:
        keyframeSelector();
        break;
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
        controlDirective();
        break;
      default:
        jj_la1[203] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_143:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[204] = jj_gen;
        break label_143;
      }
      jj_consume_token(S);
    }
  }

  final public Interpolation interpolation() throws ParseException {
    Token n;
    int line, column;
    SassListItem expression;
    n = jj_consume_token(START_INTERPOLATION);
                                 line = n.beginLine; column = n.beginColumn;
    expression = expr();
    jj_consume_token(RBRACE);
        {if (true) return new Interpolation(expression, line, column);}
    throw new Error("Missing return statement in function");
  }

  final public void debuggingDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEBUG_SYM:
      debugDirective();
      break;
    case WARN_SYM:
      warnDirective();
      break;
    default:
      jj_la1[205] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void debugDirective() throws ParseException {
    jj_consume_token(DEBUG_SYM);
        // could use StringInterpolationSequence but that would require a new parser state 
        String content = skipStatementUntil(new int[] {SEMICOLON,RBRACE,EOF});
        documentHandler.debugDirective(content);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      label_144:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[206] = jj_gen;
          break label_144;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[207] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
  }

  final public void warnDirective() throws ParseException {
    jj_consume_token(WARN_SYM);
        // could use StringInterpolationSequence but that would require a new parser state 
        String content = skipStatementUntil(new int[] {SEMICOLON,RBRACE,EOF});
        documentHandler.warnDirective(content);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      label_145:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[208] = jj_gen;
          break label_145;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[209] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
  }

  final public void forDirective() throws ParseException {
  String var;
  SassListItem from;
  SassListItem to;
    jj_consume_token(FOR_SYM);
    label_146:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[210] = jj_gen;
        break label_146;
      }
      jj_consume_token(S);
    }
    var = variableName();
    jj_consume_token(FROM);
    label_147:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[211] = jj_gen;
        break label_147;
      }
      jj_consume_token(S);
    }
    from = numericExpr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TO:
      jj_consume_token(TO);
      label_148:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[212] = jj_gen;
          break label_148;
        }
        jj_consume_token(S);
      }
      to = numericExpr();
        documentHandler.startForDirective(var, from, to, true);
      break;
    case THROUGH:
      jj_consume_token(THROUGH);
      label_149:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[213] = jj_gen;
          break label_149;
        }
        jj_consume_token(S);
      }
      to = numericExpr();
        documentHandler.startForDirective(var, from, to, false);
      break;
    default:
      jj_la1[214] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_150:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[215] = jj_gen;
        break label_150;
      }
      jj_consume_token(S);
    }
    label_151:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[216] = jj_gen;
        break label_151;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      default:
        jj_la1[217] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_152:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[218] = jj_gen;
        break label_152;
      }
      jj_consume_token(S);
    }
    documentHandler.endForDirective();
  }

  final public void whileDirective() throws ParseException {
  SassList list;
  SassListItem evaluator;
    jj_consume_token(WHILE_SYM);
    label_153:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[219] = jj_gen;
        break label_153;
      }
      jj_consume_token(S);
    }
    list = expressionSubList();
                                 evaluator = list.flatten();
    jj_consume_token(LBRACE);
    label_154:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[220] = jj_gen;
        break label_154;
      }
      jj_consume_token(S);
    }
    documentHandler.startWhileDirective(evaluator);
    label_155:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[221] = jj_gen;
        break label_155;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case MOD:
      case PARENT:
      case DOT:
      case AND:
      case OR:
      case NOT:
      case COLON:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case FOR_SYM:
      case EACH_SYM:
      case WHILE_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case MICROSOFT_RULE:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      default:
        jj_la1[222] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_156:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[223] = jj_gen;
        break label_156;
      }
      jj_consume_token(S);
    }
    documentHandler.endWhileDirective();
  }

  final public void extendDirective() throws ParseException {
    boolean optional = false;
    List<Selector> list;
    jj_consume_token(EXTEND_SYM);
    label_157:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[224] = jj_gen;
        break label_157;
      }
      jj_consume_token(S);
    }
    list = selectorList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 126:
      jj_consume_token(126);
                  optional=true;
      break;
    default:
      jj_la1[225] = jj_gen;
      ;
    }
     documentHandler.extendDirective(list,optional);
    semicolonTerminator();
  }

  final public void contentDirective() throws ParseException {
    jj_consume_token(CONTENT_SYM);
    label_158:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[226] = jj_gen;
        break label_158;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      label_159:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[227] = jj_gen;
          break label_159;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[228] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
     documentHandler.contentDirective();
  }

  Node importDirective() throws ParseException {
    return null;
  }

  Node charsetDirective() throws ParseException {
    return null;
  }

  Node mozDocumentDirective() throws ParseException {
    return null;
  }

  Node supportsDirective() throws ParseException {
    return null;
  }

  final public void nestedProperties() throws ParseException {
 StringInterpolationSequence name;
LexicalUnit exp;
    name = property();
    jj_consume_token(COLON);
    label_160:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[229] = jj_gen;
        break label_160;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LBRACE);
    label_161:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[230] = jj_gen;
        break label_161;
      }
      jj_consume_token(S);
    }
      documentHandler.startNestedProperties(name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case THROUGH:
    case EACH_IN:
    case IDENT:
      declaration();
      break;
    default:
      jj_la1[231] = jj_gen;
      ;
    }
    label_162:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[232] = jj_gen;
        break label_162;
      }
      jj_consume_token(SEMICOLON);
      label_163:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[233] = jj_gen;
          break label_163;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[234] = jj_gen;
        ;
      }
    }
    jj_consume_token(RBRACE);
      documentHandler.endNestedProperties(name);
    label_164:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[235] = jj_gen;
        break label_164;
      }
      jj_consume_token(S);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void styleRuleOrDeclarationOrNestedProperties() throws ParseException {
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEBUG_SYM:
      case WARN_SYM:
        debuggingDirective();
        break;
      default:
        jj_la1[236] = jj_gen;
        if (jj_2_6(2147483647)) {
          styleRule();
        } else if (jj_2_7(3)) {
          declarationOrNestedProperties();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PLUS:
          case MINUS:
          case PRECEDES:
          case SIBLING:
          case LBRACKET:
          case ANY:
          case MOD:
          case PARENT:
          case DOT:
          case AND:
          case OR:
          case NOT:
          case COLON:
          case START_INTERPOLATION:
          case THROUGH:
          case EACH_IN:
          case IDENT:
          case HASH:
            styleRule();
            break;
          default:
            jj_la1[237] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } catch (JumpException e) {
     skipAfterExpression();
     // reportWarningSkipText(getLocator(), skipAfterExpression());

    } catch (ParseException e) {
     if (errorHandler != null) {
         if (e.currentToken != null) {
             LocatorImpl li = new LocatorImpl(this,
                                              e.currentToken.next.beginLine,
                                              e.currentToken.next.beginColumn-1);
             reportError(li, e);
         } else {
             reportError(getLocator(), e);
         }
         skipAfterExpression();
         /*
         LocatorImpl loc = (LocatorImpl) getLocator();
         loc.column--;
         reportWarningSkipText(loc, skipAfterExpression());
         */
     } else {
         skipAfterExpression();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void declarationOrNestedProperties() throws ParseException {
  boolean important = false;
  String s = "";
  StringInterpolationSequence name;
  SassListItem exp;
  String comment = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
        jj_consume_token(ANY);
               s = "*";
        break;
      default:
        jj_la1[238] = jj_gen;
        ;
      }
      name = property();
      jj_consume_token(COLON);
      label_165:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[239] = jj_gen;
          break label_165;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case DOT:
      case LPARAN:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case TO:
      case THROUGH:
      case EACH_IN:
      case FROM:
      case MICROSOFT_RULE:
      case STRING:
      case NUMBER:
      case URL:
      case IDENT:
      case VARIABLE:
      case PERCENTAGE:
      case PT:
      case MM:
      case CM:
      case PC:
      case IN:
      case PX:
      case EMS:
      case LEM:
      case REM:
      case EXS:
      case DEG:
      case RAD:
      case GRAD:
      case MS:
      case SECOND:
      case HZ:
      case KHZ:
      case DIMEN:
      case HASH:
      case UNICODERANGE:
      case NOT_FUNCTION:
      case FUNCTION:
        exp = expressionList();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IMPORTANT_SYM:
          important = prio();
          break;
        default:
          jj_la1[240] = jj_gen;
          ;
        }
         if(!"".equals(s)){
             StringInterpolationSequence temp = new StringInterpolationSequence(s);
             name = temp.append(name);
         }
         exp = ((SassList) exp).flatten();
         Token next = getToken(1);
         if(next.kind == SEMICOLON || next.kind == RBRACE){
             while(next.kind == SEMICOLON){
                 skipStatement();
                 next = getToken(1);
             }
             //only add special token kept for sprites '/**'
             if(token.specialToken!=null && token.specialToken!=null && token.specialToken.image.startsWith("/**")){
                 documentHandler.property(name, exp, important, token.specialToken.image);
             }else{
                 documentHandler.property(name, exp, important, null);
             }
         }
        break;
      case LBRACE:
        jj_consume_token(LBRACE);
        label_166:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[241] = jj_gen;
            break label_166;
          }
          jj_consume_token(S);
        }
         documentHandler.startNestedProperties(name);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
        case AND:
        case OR:
        case NOT:
        case START_INTERPOLATION:
        case THROUGH:
        case EACH_IN:
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[242] = jj_gen;
          ;
        }
        label_167:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[243] = jj_gen;
            break label_167;
          }
          jj_consume_token(SEMICOLON);
          label_168:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S:
              ;
              break;
            default:
              jj_la1[244] = jj_gen;
              break label_168;
            }
            jj_consume_token(S);
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case MINUS:
          case AND:
          case OR:
          case NOT:
          case START_INTERPOLATION:
          case THROUGH:
          case EACH_IN:
          case IDENT:
            declaration();
            break;
          default:
            jj_la1[245] = jj_gen;
            ;
          }
        }
        jj_consume_token(RBRACE);
        label_169:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[246] = jj_gen;
            break label_169;
          }
          jj_consume_token(S);
        }
         documentHandler.endNestedProperties(name);
        break;
      default:
        jj_la1[247] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (JumpException e) {
     skipAfterExpression();
     // reportWarningSkipText(getLocator(), skipAfterExpression());

    } catch (NumberFormatException e) {
     if (errorHandler != null) {
         errorHandler.error(new CSSParseException("Invalid number "
                                                  + e.getMessage(),
                                                  getLocator(),
                                                  e));
     }
     reportWarningSkipText(getLocator(), skipAfterExpression());
    } catch (ParseException e) {
     if (errorHandler != null) {
         if (e.currentToken != null) {
             LocatorImpl li = new LocatorImpl(this,
                                              e.currentToken.next.beginLine,
                                              e.currentToken.next.beginColumn-1);
             reportError(li, e);
         } else {
             reportError(getLocator(), e);
         }
         skipAfterExpression();
         /*
         LocatorImpl loc = (LocatorImpl) getLocator();
         loc.column--;
         reportWarningSkipText(loc, skipAfterExpression());
         */
     } else {
         skipAfterExpression();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void declaration() throws ParseException {
  boolean important = false;
  StringInterpolationSequence name;
  SassListItem exp;
    try {
      name = property();
      jj_consume_token(COLON);
      label_170:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[248] = jj_gen;
          break label_170;
        }
        jj_consume_token(S);
      }
      exp = expressionList();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORTANT_SYM:
        important = prio();
        break;
      default:
        jj_la1[249] = jj_gen;
        ;
      }
        exp = ((SassList) exp).flatten();
        documentHandler.property(name, exp, important);
    } catch (JumpException e) {
     skipAfterExpression();
     // reportWarningSkipText(getLocator(), skipAfterExpression());

    } catch (NumberFormatException e) {
     if (errorHandler != null) {
         errorHandler.error(new CSSParseException("Invalid number "
                                                  + e.getMessage(),
                                                  getLocator(),
                                                  e));
     }
     reportWarningSkipText(getLocator(), skipAfterExpression());
    } catch (ParseException e) {
     if (errorHandler != null) {
         if (e.currentToken != null) {
             LocatorImpl li = new LocatorImpl(this,
                                              e.currentToken.next.beginLine,
                                              e.currentToken.next.beginColumn-1);
             reportError(li, e);
         } else {
             reportError(getLocator(), e);
         }
         skipAfterExpression();
         /*
	 LocatorImpl loc = (LocatorImpl) getLocator();
	 loc.column--;
	 reportWarningSkipText(loc, skipAfterExpression());
	 */
     } else {
         skipAfterExpression();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_171:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[250] = jj_gen;
        break label_171;
      }
      jj_consume_token(S);
    }
                             {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

  final public boolean guarded() throws ParseException {
    jj_consume_token(GUARDED_SYM);
    label_172:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[251] = jj_gen;
        break label_172;
      }
      jj_consume_token(S);
    }
                          {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public List<SassListItem> operator() throws ParseException {
    LexicalUnitImpl unit;
    List<SassListItem> list;
    boolean spaceAfter = false;
    Token n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case DIV:
    case ANY:
    case MOD:
      /* (comments copied from basic_arithmetics.scss)
          *supports:
          * 1. standard arithmetic operations (+, -, *, /, %)
          * 2. / is treated as css operator, unless one of its operands is variable or there is another binary arithmetic operator
          *limits:
          * 1. cannot mix arithmetic and css operations, e.g. "margin: 1px + 3px 2px" will fail
          * 2. space between add and minus operator and their following operand is mandatory. e.g. "1 + 2" is valid, "1+2" is not
          * 3. parenthesis is not supported now.
          */
      
          list = nonCommaOperator();
                               {if (true) return list;}
      break;
    case COMMA:
      n = jj_consume_token(COMMA);
           unit = LexicalUnitImpl.createComma(n.beginLine, n.beginColumn);
      label_173:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[252] = jj_gen;
          break label_173;
        }
        jj_consume_token(S);
             spaceAfter = true;
      }
          {if (true) return createList(unit, spaceAfter);}
      break;
    default:
      jj_la1[253] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  List<SassListItem> createList(SassListItem item, boolean spaceAfter) throws ParseException {
   if (spaceAfter){
      ArrayList<SassListItem> result = new ArrayList<SassListItem>();
      result.add(item);
      result.add(LexicalUnitImpl.createSpace(item.getLineNumber(), item.getColumnNumber()));
      return result;
   } else {
      return Collections.<SassListItem>singletonList(item);
   }
  }

  final public SassListItem expr() throws ParseException {
    Token n;
    List<SassListItem> list = new ArrayList<SassListItem>();
    List<SassListItem> items;
    addExpressionTerm(list);
    label_174:
    while (true) {
      if (jj_2_8(2)) {
        ;
      } else {
        break label_174;
      }
      items = arithmeticOrBooleanOperator();
                                                         list.addAll(items);
      addExpressionTerm(list);
    }
        {if (true) return SassExpression.createExpression(list);}
    throw new Error("Missing return statement in function");
  }

  final public void addExpressionTerm(List<SassListItem> items) throws ParseException {
    char op = ' ';
    SassListItem term;
    List<SassListItem> terms;
    if (jj_2_9(2)) {
      terms = term();
                                   items.addAll(terms);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case LPARAN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
          op = unaryOperator();
          break;
        default:
          jj_la1[254] = jj_gen;
          ;
        }
        term = parenthesizedExpression(op);
                                              items.add(term);
        break;
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public SassListItem parenthesizedExpression(char op) throws ParseException {
    SassList list;
    jj_consume_token(LPARAN);
    label_175:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[256] = jj_gen;
        break label_175;
      }
      jj_consume_token(S);
    }
    list = expressionList();
    jj_consume_token(RPARAN);
    label_176:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[257] = jj_gen;
        break label_176;
      }
      jj_consume_token(S);
    }
       SassListItem result = list.flatten();
       if(op == '-'){
           result = SassExpression.createExpression(
              LexicalUnitImpl.createNumber(token.beginLine, token.beginColumn, -1),
              LexicalUnitImpl.createMultiply(token.beginLine, token.beginColumn),
              result);
       }
       {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public List<SassListItem> arithmeticOrBooleanOperator() throws ParseException {
    List<SassListItem> result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case DIV:
    case ANY:
    case MOD:
      result = nonCommaOperator();
      break;
    case PRECEDES:
    case SUCCEEDS:
    case COMPARE:
    case NOT_EQ:
    case GTE:
    case LTE:
    case AND:
    case OR:
      result = booleanOperator();
      break;
    default:
      jj_la1[258] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public List<SassListItem> booleanOperator() throws ParseException {
  Token n = null;
  boolean spaceAfter = false;
  LexicalUnitImpl operator;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMPARE:
      n = jj_consume_token(COMPARE);
                       operator = LexicalUnitImpl.createEquals(n.beginLine, n.beginColumn);
      break;
    case SUCCEEDS:
      n = jj_consume_token(SUCCEEDS);
                        operator = LexicalUnitImpl.createLessThan(n.beginLine, n.beginColumn);
      break;
    case GTE:
      n = jj_consume_token(GTE);
                   operator = LexicalUnitImpl.createGreaterThanOrEqualTo(n.beginLine, n.beginColumn);
      break;
    case PRECEDES:
      n = jj_consume_token(PRECEDES);
                        operator = LexicalUnitImpl.createGreaterThan(n.beginLine, n.beginColumn);
      break;
    case LTE:
      n = jj_consume_token(LTE);
                   operator = LexicalUnitImpl.createLessThanOrEqualTo(n.beginLine, n.beginColumn);
      break;
    case NOT_EQ:
      n = jj_consume_token(NOT_EQ);
                      operator = LexicalUnitImpl.createNotEqual(n.beginLine, n.beginColumn);
      break;
    case AND:
      n = jj_consume_token(AND);
                   operator = LexicalUnitImpl.createAnd(n.beginLine, n.beginColumn);
      break;
    case OR:
      n = jj_consume_token(OR);
                  operator = LexicalUnitImpl.createOr(n.beginLine, n.beginColumn);
      break;
    default:
      jj_la1[259] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_177:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[260] = jj_gen;
        break label_177;
      }
      jj_consume_token(S);
            spaceAfter = true;
    }
    {if (true) return createList(operator, spaceAfter);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public List<SassListItem> nonCommaOperator() throws ParseException {
    Token n;
    LexicalUnitImpl unit;
    boolean spaceAfter = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIV:
      n = jj_consume_token(DIV);
      label_178:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[261] = jj_gen;
          break label_178;
        }
        jj_consume_token(S);
                   spaceAfter = true;
      }
           unit = LexicalUnitImpl.createSlash(n.beginLine, n.beginColumn);
      break;
    case ANY:
      n = jj_consume_token(ANY);
      label_179:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[262] = jj_gen;
          break label_179;
        }
        jj_consume_token(S);
                    spaceAfter = true;
      }
           unit =  LexicalUnitImpl.createMultiply(n.beginLine, n.beginColumn);
      break;
    case MOD:
      n = jj_consume_token(MOD);
      label_180:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[263] = jj_gen;
          break label_180;
        }
        jj_consume_token(S);
                    spaceAfter = true;
      }
           unit = LexicalUnitImpl.createModulo(n.beginLine, n.beginColumn);
      break;
    case PLUS:
      n = jj_consume_token(PLUS);
      label_181:
      while (true) {
        jj_consume_token(S);
                    spaceAfter = true;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[264] = jj_gen;
          break label_181;
        }
      }
           unit = LexicalUnitImpl.createAdd(n.beginLine, n.beginColumn);
      break;
    case MINUS:
      n = jj_consume_token(MINUS);
      label_182:
      while (true) {
        jj_consume_token(S);
                    spaceAfter = true;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[265] = jj_gen;
          break label_182;
        }
      }
           unit = LexicalUnitImpl.createMinus(n.beginLine, n.beginColumn);
      break;
    default:
      jj_la1[266] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return createList(unit, spaceAfter);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public SassListItem numericExpr() throws ParseException {
    List<SassListItem> current;
    List<SassListItem> res = new ArrayList<SassListItem>();
    current = numericTerm();
                           res.addAll(current);
    label_183:
    while (true) {
      if (jj_2_10(2)) {
        ;
      } else {
        break label_183;
      }
      current = nonCommaOperator();
                                                res.addAll(current);
      current = numericTerm();
                                                                                               res.addAll(current);
    }
    {if (true) return SassExpression.createExpression(res);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
        {if (true) return '-';}
      break;
    case PLUS:
      jj_consume_token(PLUS);
        {if (true) return '+';}
      break;
    default:
      jj_la1[267] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public List<SassListItem> term() throws ParseException {
  List<SassListItem> res;
  char op = ' ';
    if (jj_2_11(2)) {
      op = unaryOperator();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case DOT:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case TO:
    case THROUGH:
    case EACH_IN:
    case FROM:
    case MICROSOFT_RULE:
    case STRING:
    case NUMBER:
    case URL:
    case IDENT:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case HASH:
    case UNICODERANGE:
    case NOT_FUNCTION:
    case FUNCTION:
      res = nonVariableTerm(op);
      break;
    case VARIABLE:
      res = variableTerm(op);
      break;
    default:
      jj_la1[268] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public List<SassListItem> numericTerm() throws ParseException {
  SassListItem current;
  List<SassListItem> res;
  Token n = null;
  char op = ' ';
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      op = unaryOperator();
      break;
    default:
      jj_la1[269] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
      res = numberTerm(op);
      break;
    case NOT_FUNCTION:
    case FUNCTION:
      current = function(op);
                                res = createList(current, false);
      label_184:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[270] = jj_gen;
          break label_184;
        }
        jj_consume_token(S);
      }
      break;
    case VARIABLE:
      res = variableTerm(op);
      break;
    case LPARAN:
      current = parenthesizedNumericExpr(op);
                                              res = createList(current, false);
      break;
    default:
      jj_la1[271] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
              {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public SassListItem parenthesizedNumericExpr(char op) throws ParseException {
    SassListItem result;
    jj_consume_token(LPARAN);
    label_185:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[272] = jj_gen;
        break label_185;
      }
      jj_consume_token(S);
    }
    result = numericExpr();
    jj_consume_token(RPARAN);
    label_186:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[273] = jj_gen;
        break label_186;
      }
      jj_consume_token(S);
    }
       if(op == '-'){
           result = SassExpression.createExpression(
              LexicalUnitImpl.createNumber(token.beginLine, token.beginColumn, -1),
              LexicalUnitImpl.createMultiply(token.beginLine, token.beginColumn),
              result);
       }
       {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public List<SassListItem> variableTerm(char op) throws ParseException {
    boolean spaceAfter = false;
    Token n;
    SassListItem result = null;
    String varName = "";
    // variableName() is not used here because we need to recognize whether there is whitespace after the name.
        n = jj_consume_token(VARIABLE);
    label_187:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[274] = jj_gen;
        break label_187;
      }
      jj_consume_token(S);
                         spaceAfter = true;
    }
        varName = convertIdent(n.image.substring(1));
        result = LexicalUnitImpl.createVariable(n.beginLine, n.beginColumn, varName);

        if (op == '-') {
            result = SassExpression.createExpression(
              LexicalUnitImpl.createNumber(n.beginLine, n.beginColumn, -1),
              LexicalUnitImpl.createMultiply(n.beginLine, n.beginColumn),
              result
              );
        }

        {if (true) return createList(result, spaceAfter);}
    throw new Error("Missing return statement in function");
  }

  final public List<SassListItem> nonVariableTerm(char op) throws ParseException {
    SassListItem current = null;
    List<SassListItem> result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
      result = numberTerm(op);
      break;
    case NOT_FUNCTION:
    case FUNCTION:
      current = function(op);
                                 result = createList(current, false);
      label_188:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[275] = jj_gen;
          break label_188;
        }
        jj_consume_token(S);
      }
      break;
    case MINUS:
    case DOT:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case TO:
    case THROUGH:
    case EACH_IN:
    case FROM:
    case MICROSOFT_RULE:
    case STRING:
    case URL:
    case IDENT:
    case HASH:
    case UNICODERANGE:
      result = stringTerm(op);
      break;
    default:
      jj_la1[276] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public List<SassListItem> numberTerm(char op) throws ParseException {
    boolean spaceAfter = false;
    Token n = null;
    LexicalUnitImpl result = null;
    String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
      n = jj_consume_token(NUMBER);
          result = LexicalUnitImpl.createNumber(n.beginLine, n.beginColumn, number(op, n, 0));
      break;
    case PERCENTAGE:
      n = jj_consume_token(PERCENTAGE);
          result = LexicalUnitImpl.createPercentage(n.beginLine, n.beginColumn, number(op, n, 1));
      break;
    case PT:
      n = jj_consume_token(PT);
          result = LexicalUnitImpl.createPT(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case CM:
      n = jj_consume_token(CM);
          result = LexicalUnitImpl.createCM(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case MM:
      n = jj_consume_token(MM);
          result = LexicalUnitImpl.createMM(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case PC:
      n = jj_consume_token(PC);
          result = LexicalUnitImpl.createPC(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case IN:
      n = jj_consume_token(IN);
          result = LexicalUnitImpl.createIN(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case PX:
      n = jj_consume_token(PX);
          result = LexicalUnitImpl.createPX(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case EMS:
      n = jj_consume_token(EMS);
          result = LexicalUnitImpl.createEMS(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case LEM:
      n = jj_consume_token(LEM);
          result = LexicalUnitImpl.createLEM(n.beginLine, n.beginColumn, number(op, n, 3));
      break;
    case REM:
      n = jj_consume_token(REM);
          result = LexicalUnitImpl.createREM(n.beginLine, n.beginColumn, number(op, n, 3));
      break;
    case EXS:
      n = jj_consume_token(EXS);
          result = LexicalUnitImpl.createEXS(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case DEG:
      n = jj_consume_token(DEG);
          result = LexicalUnitImpl.createDEG(n.beginLine, n.beginColumn, number(op, n, 3));
      break;
    case RAD:
      n = jj_consume_token(RAD);
          result = LexicalUnitImpl.createRAD(n.beginLine, n.beginColumn, number(op, n, 3));
      break;
    case GRAD:
      n = jj_consume_token(GRAD);
          result = LexicalUnitImpl.createGRAD(n.beginLine, n.beginColumn, number(op, n, 3));
      break;
    case SECOND:
      n = jj_consume_token(SECOND);
          result = LexicalUnitImpl.createS(n.beginLine, n.beginColumn, number(op, n, 1));
      break;
    case MS:
      n = jj_consume_token(MS);
          result = LexicalUnitImpl.createMS(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case HZ:
      n = jj_consume_token(HZ);
          result = LexicalUnitImpl.createHZ(n.beginLine, n.beginColumn, number(op, n, 2));
      break;
    case KHZ:
      n = jj_consume_token(KHZ);
          result = LexicalUnitImpl.createKHZ(n.beginLine, n.beginColumn, number(op, n, 3));
      break;
    case DIMEN:
      n = jj_consume_token(DIMEN);
            s = n.image;
            int i = 0;
            while (i < s.length()
                   && (Character.isDigit(s.charAt(i)) || (s.charAt(i) == '.'))) {
                i++;
            }

            result = LexicalUnitImpl.createDimen(n.beginLine, n.beginColumn,
                                                 number(op,n,s.length()-i), s.substring(i));
      break;
    default:
      jj_la1[277] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_189:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[278] = jj_gen;
        break label_189;
      }
      jj_consume_token(S);
                   spaceAfter = true;
    }
        {if (true) return createList(result, spaceAfter);}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<SassListItem> identInterpolationString() throws ParseException {
    Token n;
    String s = "";
    ArrayList<SassListItem> items = new ArrayList<SassListItem>();
    Interpolation interp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AND:
    case OR:
    case NOT:
    case TO:
    case THROUGH:
    case EACH_IN:
    case FROM:
    case MICROSOFT_RULE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        n = jj_consume_token(OR);
        break;
      case AND:
        n = jj_consume_token(AND);
        break;
      case NOT:
        n = jj_consume_token(NOT);
        break;
      case FROM:
        n = jj_consume_token(FROM);
        break;
      case THROUGH:
        n = jj_consume_token(THROUGH);
        break;
      case TO:
        n = jj_consume_token(TO);
        break;
      case EACH_IN:
        n = jj_consume_token(EACH_IN);
        break;
      case MICROSOFT_RULE:
        n = jj_consume_token(MICROSOFT_RULE);
        break;
      default:
        jj_la1[279] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                   items.add(new StringItem(convertIdent(n.image)));
      break;
    case MINUS:
    case START_INTERPOLATION:
    case IDENT:
      label_190:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          n = jj_consume_token(IDENT);
                                     items.add(new StringItem(convertIdent(n.image)));
          break;
        case START_INTERPOLATION:
          interp = interpolation();
                                      items.add(interp);
          break;
        case MINUS:
          n = jj_consume_token(MINUS);
                                                                      items.add(new StringItem(convertIdent(n.image)));
          break;
        default:
          jj_la1[280] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
        case START_INTERPOLATION:
        case IDENT:
          ;
          break;
        default:
          jj_la1[281] = jj_gen;
          break label_190;
        }
      }
      break;
    default:
      jj_la1[282] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return items;}
    throw new Error("Missing return statement in function");
  }

  final public Token ident() throws ParseException {
    Token n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      n = jj_consume_token(IDENT);
      break;
    case OR:
      n = jj_consume_token(OR);
      break;
    case AND:
      n = jj_consume_token(AND);
      break;
    case NOT:
      n = jj_consume_token(NOT);
      break;
    case FROM:
      n = jj_consume_token(FROM);
      break;
    case THROUGH:
      n = jj_consume_token(THROUGH);
      break;
    case TO:
      n = jj_consume_token(TO);
      break;
    case EACH_IN:
      n = jj_consume_token(EACH_IN);
      break;
    default:
      jj_la1[283] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final public List<SassListItem> stringTerm(char op) throws ParseException {
    boolean spaceAfter = false;
    int beginLine = getToken(1).beginLine, beginColumn = getToken(1).beginColumn;
    Token n = null;
    LexicalUnitImpl result = null;
    ArrayList<SassListItem> iis;
    String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      n = jj_consume_token(STRING);
          s = convertStringIndex(n.image, 1, n.image.length() -1);
          if (op != ' ') { s = "" + op + s; }
          result = LexicalUnitImpl.createString(n.beginLine, n.beginColumn, s);
      break;
    case MINUS:
    case DOT:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case TO:
    case THROUGH:
    case EACH_IN:
    case FROM:
    case MICROSOFT_RULE:
    case IDENT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
              s=".";
        break;
      default:
        jj_la1[284] = jj_gen;
        ;
      }
      iis = identInterpolationString();
        if(op != ' ') { s = "" + op + s; }
        if(!"".equals(s)) { iis.add(0, new StringItem(s)); }
        StringInterpolationSequence sis = new StringInterpolationSequence(iis);
            if ("inherit".equals(sis.toString())) {
                result = LexicalUnitImpl.createInherit(beginLine, beginColumn);
            } else {
                result = LexicalUnitImpl.createIdent(beginLine, beginColumn, sis);
            }

    // TODO fix this - no prev
          /* /
         Auto correction code used in the CSS Validator but must not
          be used by a conformant CSS2 parser.
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 *
	Token t = getToken(1);
	Token semicolon = new Token();
	semicolon.kind = SEMICOLON;
	semicolon.image = ";";
	if (t.kind == COLON) {
	    // @@SEEME. (generate a warning?)
	    // @@SEEME if expression is a single ident, 
	       generate an error ?
	    rejectToken(semicolon);
	    
	    result = prev;
	}
	/ */

      break;
    case HASH:
      result = hexcolor();
      break;
    case URL:
      result = url();
      break;
    case UNICODERANGE:
      result = unicode();
      break;
    default:
      jj_la1[285] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_191:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[286] = jj_gen;
        break label_191;
      }
      jj_consume_token(S);
                  spaceAfter = true;
    }
        {if (true) return createList(result, spaceAfter);}
    throw new Error("Missing return statement in function");
  }

/**
 * Handle all CSS2 functions.
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl function(char operator) throws ParseException {
 Token n;
 List<Variable> items = null;
 boolean hasVariableArguments = false;
 ActualArgumentList params;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FUNCTION:
      n = jj_consume_token(FUNCTION);
      break;
    case NOT_FUNCTION:
      n = jj_consume_token(NOT_FUNCTION);
      break;
    default:
      jj_la1[287] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_192:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[288] = jj_gen;
        break label_192;
      }
      jj_consume_token(S);
    }
        String fname = convertIdent(n.image);
        if ("filename(".equals(fname)) {
            String body = skipStatementUntilSemiColon();
            String fileName = source.getURI();
            String currentDir = System.getProperty("user.dir");
            if (fileName.startsWith(currentDir.replace("\u005c\u005c", "/"))) {
                fileName = fileName.substring(currentDir.length());
            }
            {if (true) return LexicalUnitImpl.createIdent(n.beginLine, n.beginColumn, fileName);}
        } else if("expression(".equals(fname)){
            String body = skipStatementUntilSemiColon();
            {if (true) return LexicalUnitImpl.createIdent(n.beginLine, n.beginColumn, fname+body);}
        }
    items = argValuelist();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELLIPSIS:
      jj_consume_token(ELLIPSIS);
                                          hasVariableArguments = true;
      label_193:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[289] = jj_gen;
          break label_193;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[290] = jj_gen;
      ;
    }
        params = new ActualArgumentList(SassList.Separator.COMMA, items, hasVariableArguments);
    jj_consume_token(RPARAN);
        if (operator != ' ') {
        {if (true) throw new CSSParseException("invalid operator before a function.",
                    getLocator());}
        }
        String f = convertIdent(n.image);
        // f contains the opening parenthesis of the function call
        {if (true) return LexicalUnitImpl.createFunction(n.beginLine, n.beginColumn, f.substring(0, f.length() -1), params);}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl unicode() throws ParseException {
  Token n;
    n = jj_consume_token(UNICODERANGE);
     List<SassListItem> params = new ArrayList<SassListItem>();
     String s = n.image.substring(2);
     int index = s.indexOf('-');
     if (index == -1) {
         params.add(LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn, Integer.parseInt(s, 16)));
     } else {
         String s1 = s.substring(0, index);
         String s2 = s.substring(index);

         params.add(LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn, Integer.parseInt(s1, 16)));
         params.add(LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn, Integer.parseInt(s2, 16)));
     }

     {if (true) return LexicalUnitImpl.createUnicodeRange(n.beginLine, n.beginColumn, new SassList(SassList.Separator.COMMA, params));}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl url() throws ParseException {
  Token n;
    n = jj_consume_token(URL);
   String urlname = n.image.substring(4, n.image.length()-1).trim();
   {if (true) return LexicalUnitImpl.createURL(n.beginLine, n.beginColumn, urlname);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl hexcolor() throws ParseException {
 Token n;
    n = jj_consume_token(HASH);
     int r;
     LexicalUnitImpl first, params = null;
     String s = n.image.substring(1);

     if(s.length()!=3 && s.length()!=6) {
         first = null;
         {if (true) throw new CSSParseException("invalid hexadecimal notation for RGB: " + s,
                                     getLocator());}
     }
     {if (true) return LexicalUnitImpl.createIdent(n.beginLine, n.beginColumn, n.image);}
    throw new Error("Missing return statement in function");
  }

  float number(char operator, Token n, int lengthUnit) throws ParseException {
    String image  = n.image;
    float f = 0;

    if (lengthUnit != 0) {
        image = image.substring(0, image.length() - lengthUnit);
    }
    f = Float.valueOf(image).floatValue();
    return (operator == '-')? -f: f;
  }

  String skipStatementUntilSemiColon() throws ParseException {
    int[] semicolon = {SEMICOLON};
    return skipStatementUntil(semicolon);
  }

  String skipStatementUntilLeftBrace() throws ParseException {
    int[] lBrace = {LBRACE};
    return skipStatementUntil(lBrace);
  }

  String skipStatementUntilMatchingRightParan() throws ParseException {
    int[] leftTokens = {LPARAN, FUNCTION, NOT_FUNCTION}; // a FUNCTION also contains "("
    int[] rightTokens = {RPARAN};
    StringBuffer s = new StringBuffer();
    int difference = 1;
    Token tok;
    while(difference != 0){
        tok = getToken(1);
        if(tok.kind == EOF) {
            return null;
        }
        for(int sym : leftTokens){
            if(tok.kind == sym){
                difference++;
            }
        }
        for(int sym : rightTokens){
            if(tok.kind == sym){
                difference--;
            }
        }
        if(difference != 0){
            if (tok.image != null) {
                s.append(tok.image);
            }
            getNextToken();
        }
    }
    return s.toString().trim();
  }

  String skipStatementUntil(int[] symbols) throws ParseException {
    StringBuffer s = new StringBuffer();
    boolean found = false;
    Token tok;
    while(!found){
        tok = getToken(1);
        for(int sym : symbols){
            if(tok.kind == sym){
                found = true;
                break;
            }
        }
        if(tok.kind == EOF) {
            break;
        }
        if(!found){
            if (tok.image != null) {
                s.append(tok.image);
            }
            getNextToken();
        }
    }
    return found ? s.toString().trim() : null;
  }

  String skipStatement() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token tok = getToken(0);
    if (tok.image != null) {
        s.append(tok.image);
    }
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            return null;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            getNextToken();
            s.append(skip_to_matching_brace());
            getNextToken();
            tok = getToken(1);
            break;
        } else if (tok.kind == RBRACE) {
            getNextToken();
            tok = getToken(1);
            break;
        } else if (tok.kind == SEMICOLON) {
            getNextToken();
            tok = getToken(1);
            break;
        }
        getNextToken();
    }

    // skip white space
    while (true) {
        if (tok.kind != S) {
            break;
        }
        tok = getNextToken();
        tok = getToken(1);
    }

    return s.toString().trim();
  }

  String skip_to_matching_brace() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token tok;
    int nesting = 1;
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            break;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            nesting++;
        } else if (tok.kind == RBRACE) {
            nesting--;
            if (nesting == 0) {
                break;
            }
        }
        getNextToken();
    }
    return s.toString();
  }

  String convertStringIndex(String s, int start, int len) throws ParseException {
    StringBuffer buf = new StringBuffer(len);
    int index = start;

    while (index < len) {
        char c = s.charAt(index);
        if (c == '\u005c\u005c') {
            if (++index < len) {
                c = s.charAt(index);
                switch (c) {
                case '0': case '1': case '2': case '3': case '4':
                case '5': case '6': case '7': case '8': case '9':
                case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
                case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
                    buf.append('\u005c\u005c');
                    while (index < len) {
                        buf.append(s.charAt(index++));
                    }
                    break;
                case '\u005cn':
                case '\u005cf':
                    break;
                case '\u005cr':
                    if (index + 1 < len) {
                        if (s.charAt(index + 1) == '\u005cn') {
                            index ++;
                        }
                    }
                    break;
                default:
                    buf.append(c);
                }
            } else {
                throw new CSSParseException("invalid string " + s, getLocator());
            }
        } else {
            buf.append(c);
        }
        index++;
    }

    return buf.toString();
  }

  String convertIdent(String s) throws ParseException {
    return convertStringIndex(s, 0, s.length());
  }

  String convertString(String s) throws ParseException {
    return convertStringIndex(s, 0, s.length());
  }

  void comments() throws ParseException {
        /*keeps only the multiple line comments, single line comments are skipped*/
    if (token.specialToken != null && token.specialToken.image!=null && token.specialToken.image.startsWith("/*")){
        Token tmp_t = token.specialToken;
        while (tmp_t.specialToken != null) tmp_t = tmp_t.specialToken;
        while (tmp_t != null) {
            documentHandler.comment(tmp_t.image);
            tmp_t = tmp_t.next;
        }
    }
  }

  void rejectToken(Token t) throws ParseException {
    Token fakeToken = new Token();
    t.next = token;
    fakeToken.next = t;
    token = fakeToken;
  }

  String skipAfterExpression() throws ParseException {
    Token t = getToken(1);
    StringBuffer s = new StringBuffer();
    s.append(getToken(0).image);

    while ((t.kind != RBRACE) && (t.kind != SEMICOLON) && (t.kind != EOF)) {
        s.append(t.image);
        getNextToken();
        t = getToken(1);
    }

    return s.toString();
  }

/**
 * The following functions are useful for a DOM CSS implementation only and are
 * not part of the general CSS2 parser.
 */
// TODO required by original parser but not used by Vaadin?
  final public void _parseRule() throws ParseException {
 String ret = null;
    label_194:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[291] = jj_gen;
        break label_194;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPORT_SYM:
      importDeclaration();
      break;
    case DEBUG_SYM:
    case WARN_SYM:
      debuggingDirective();
      break;
    case PLUS:
    case MINUS:
    case PRECEDES:
    case SIBLING:
    case LBRACKET:
    case ANY:
    case MOD:
    case PARENT:
    case DOT:
    case AND:
    case OR:
    case NOT:
    case COLON:
    case START_INTERPOLATION:
    case THROUGH:
    case EACH_IN:
    case IDENT:
    case HASH:
      styleRule();
      break;
    case MEDIA_SYM:
      media();
      break;
    case PAGE_SYM:
      page();
      break;
    case FONT_FACE_SYM:
      fontFace();
      break;
    default:
      jj_la1[292] = jj_gen;
      ret = skipStatement();
                    if ((ret == null) || (ret.length() == 0)) {
                        {if (true) return;}
                    }
                    if (ret.charAt(0) == '@') {
                        documentHandler.unrecognizedRule(ret);
                    } else {
                        {if (true) throw new CSSParseException("unrecognize rule: " + ret,
                                                    getLocator());}
                    }
    }
  }

  final public void _parseImportRule() throws ParseException {
    label_195:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[293] = jj_gen;
        break label_195;
      }
      jj_consume_token(S);
    }
    importDeclaration();
  }

  final public void _parseMediaRule() throws ParseException {
    label_196:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[294] = jj_gen;
        break label_196;
      }
      jj_consume_token(S);
    }
    media();
  }

  final public void _parseDeclarationBlock() throws ParseException {
    label_197:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[295] = jj_gen;
        break label_197;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case AND:
    case OR:
    case NOT:
    case START_INTERPOLATION:
    case THROUGH:
    case EACH_IN:
    case IDENT:
      declaration();
      break;
    default:
      jj_la1[296] = jj_gen;
      ;
    }
    label_198:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[297] = jj_gen;
        break label_198;
      }
      jj_consume_token(SEMICOLON);
      label_199:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[298] = jj_gen;
          break label_199;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case AND:
      case OR:
      case NOT:
      case START_INTERPOLATION:
      case THROUGH:
      case EACH_IN:
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[299] = jj_gen;
        ;
      }
    }
  }

  final public List<Selector> _parseSelectors() throws ParseException {
  List<Selector> p = null;
    try {
      label_200:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[300] = jj_gen;
          break label_200;
        }
        jj_consume_token(S);
      }
      p = selectorList();
          {if (true) return p;}
    } catch (ThrowedParseException e) {
        {if (true) throw (ParseException) e.e.fillInStackTrace();}
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_3R_334() {
    if (jj_scan_token(UNICODERANGE)) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_3R_206()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_361()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_scan_token(LPARAN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_249()) return true;
    if (jj_scan_token(RPARAN)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) jj_scanpos = xsp;
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_scan_token(START_INTERPOLATION)) return true;
    if (jj_3R_204()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_210() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) return true;
    }
    return false;
  }

  private boolean jj_3R_261() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_321()) return true;
    xsp = jj_scanpos;
    if (jj_3R_322()) jj_scanpos = xsp;
    if (jj_scan_token(RPARAN)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_209()) return true;
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_210()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_8()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_3R_333()) return true;
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_3R_332()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_3R_331()) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_scan_token(HASH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_338()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_359() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_360()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_347() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_359()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_324() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) jj_scanpos = xsp;
    if (jj_3R_331()) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_3R_346()) return true;
    if (jj_3R_347()) return true;
    if (jj_scan_token(RPARAN)) return true;
    return false;
  }

  private boolean jj_3R_312() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_328()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_205()) return true;
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_335() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) return true;
    }
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_scan_token(NOT_FUNCTION)) return true;
    if (jj_3R_220()) return true;
    if (jj_scan_token(RPARAN)) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_335()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_3R_335()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_362()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_339()) {
    jj_scanpos = xsp;
    if (jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_3R_341()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_321() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_3R_319()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_337() {
    Token xsp;
    if (jj_3R_345()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_345()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_336() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_331() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) return true;
    }
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_scan_token(SUBSTRINGMATCH)) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_scan_token(SUFFIXMATCH)) return true;
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_3R_319()) return true;
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_scan_token(PREFIXMATCH)) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_scan_token(DASHMATCH)) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(INCLUDES)) return true;
    return false;
  }

  private boolean jj_3R_343() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) return true;
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_354()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_248()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_343()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3R_302() {
    if (jj_scan_token(KHZ)) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_scan_token(HZ)) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(PARENT)) return true;
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_scan_token(MS)) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_201()) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  private boolean jj_3R_246() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_scan_token(GRAD)) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_scan_token(RAD)) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_scan_token(DEG)) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_scan_token(EXS)) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_scan_token(MOD)) return true;
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(LEM)) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_scan_token(EMS)) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_scan_token(PX)) return true;
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_scan_token(PC)) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_scan_token(MM)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_scan_token(CM)) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(PT)) return true;
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_270() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) return true;
    }
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_3R_318()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    Token xsp;
    if (jj_3R_270()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_270()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_260() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) {
    jj_scanpos = xsp;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3R_301()) {
    jj_scanpos = xsp;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_320()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_3R_316()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_3R_312()) return true;
    return false;
  }

  private boolean jj_3R_306() {
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_3R_261()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_3R_314()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_253() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_266() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_3R_246()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_309()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3R_217() {
    Token xsp;
    if (jj_3R_245()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_245()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_203() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) return true;
    }
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_3R_249()) return true;
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_207()) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_scan_token(VARIABLE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_283()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) jj_scanpos = xsp;
    if (jj_3R_223()) return true;
    if (jj_scan_token(COLON)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) return true;
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_202()) return true;
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_220() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_220()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_221()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_3R_207()) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_211() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) return true;
    }
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_214() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) return true;
    }
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_212()) return true;
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_scan_token(VARIABLE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_318() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_scan_token(MINUS)) return true;
    Token xsp;
    if (jj_3R_259()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_259()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    if (jj_3R_258()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_258()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_3R_248()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_scan_token(MOD)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_257()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_scan_token(ANY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_256()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(DIV)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_255()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_212() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_scan_token(NOT_EQ)) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_scan_token(LTE)) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(PRECEDES)) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(GTE)) return true;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_scan_token(SUCCEEDS)) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_scan_token(COMPARE)) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_scan_token(SIBLING)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(PRECEDES)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_204()) return true;
    return false;
  }

  private boolean jj_3R_250() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) return true;
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_279()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_219() {
    Token xsp;
    if (jj_3_3()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_scan_token(ELLIPSIS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) return true;
    }
    return false;
  }

  private boolean jj_3R_206() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) return true;
    }
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(LPARAN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPARAN)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_209() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[301];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x302,0x302,0x2,0x2,0x100000,0x7a660000,0x300,0x2,0x300,0x2,0x0,0x2,0x100000,0x2,0x2,0x0,0x0,0x2,0x2,0x0,0x0,0x2,0x0,0x2,0x80000,0x2,0x0,0x2,0x2,0x7a660000,0x2,0x2,0x2,0x7a7e8900,0x2,0x0,0x1c8900,0x2,0x2,0x0,0x0,0x2,0x40000,0x100000,0x2,0x40000,0x2,0x2,0x2,0x2,0x40000,0x40000,0x100000,0x2,0x40000,0x40000,0x2,0x1c8900,0x620000,0x620002,0x2,0x2,0x2,0x620000,0x2,0x40090002,0x40090002,0x2,0x2,0x2,0x40000,0x2,0x2,0x2,0x2,0x7a660000,0x7a660000,0x2,0x80000,0x2,0x620000,0x2,0x52000000,0x52000000,0x7a040000,0x52000000,0x40000,0x40000,0x28040000,0x2,0x2,0x1f800,0x2,0x40000,0x2,0x1f800,0x40000,0x60000,0x60000,0x2,0x40000,0x2,0x0,0x80000,0x2,0x2,0x2,0x40060000,0x0,0x7a660000,0x2,0x2,0x7a660000,0x7a660000,0x2,0x0,0x2,0x2,0x2,0x0,0x0,0x2,0x7a660000,0x7a660000,0x2,0x2,0x2,0x2,0x2,0x7a660000,0x2,0x2,0x2,0x80000000,0x2,0x40000,0x2,0x7a660000,0x7a660000,0x2,0x2,0x2,0x80000000,0x2,0x2,0x0,0x2,0x0,0x0,0x2,0x2,0x0,0x2,0x0,0x2,0x2,0x2,0x0,0x0,0x2,0x0,0x2,0x2,0x2,0x2,0x2,0x0,0x2,0x2,0x2,0x2,0x2,0x0,0x2,0x0,0x2,0x2,0x2,0x0,0x2,0x80000,0x2,0x0,0x2,0x0,0x80000,0x2,0x40060000,0x2,0x40060000,0x2,0x2,0x2,0x80000000,0x2,0x40000,0x0,0x2,0x100000,0x100000,0x2,0x7a660000,0x7a660000,0x2,0x0,0x2,0x100000,0x2,0x100000,0x2,0x2,0x2,0x2,0x0,0x2,0x7a660000,0x7a660000,0x2,0x2,0x2,0x7a660000,0x7a660000,0x2,0x2,0x0,0x2,0x2,0x100000,0x2,0x2,0x40000,0x100000,0x2,0x40000,0x2,0x0,0x7a660000,0x8000000,0x2,0x0,0x2,0x40000,0x100000,0x2,0x40000,0x2,0x40060000,0x2,0x0,0x2,0x2,0x2,0x190e0000,0x60000,0x60000,0x2,0x2,0x19a60000,0xa00000,0x2,0x2,0x2,0x2,0x2,0x2,0x19060000,0x60000,0x40040000,0x60000,0x2,0x0,0x2,0x2,0x2,0x2,0x40040000,0x0,0x2,0x0,0x40000,0x40000,0x40000,0x0,0x40000000,0x40040000,0x2,0x0,0x2,0x2,0x80000000,0x2,0x7a660000,0x2,0x2,0x2,0x40000,0x100000,0x2,0x40000,0x2,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0xf76007c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf005c0,0xf005c0,0x0,0x0,0x900000,0x900000,0x0,0x900000,0x0,0x0,0x0,0x900000,0x0,0x0,0xf26007c0,0x0,0x0,0x0,0x30600fc0,0x0,0x30000000,0x800,0x0,0x0,0xf001c0,0x200,0x0,0x6005c0,0x0,0x0,0x6005c0,0x0,0x0,0x0,0x0,0xc06005c0,0xc06005c0,0x0,0x0,0xc06005c0,0xc06005c0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf007c2,0xf007c2,0x0,0x0,0x0,0x6001c0,0x0,0x0,0x0,0x0,0xf26007c0,0xf26007c0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x6007c0,0x200,0x6005c0,0x6005c0,0x6005c0,0x0,0x0,0x0,0x0,0x6005c0,0x0,0x0,0x6007c0,0x0,0x0,0x0,0xf005c0,0x0,0x0,0x0,0x0,0x0,0x0,0xf005c1,0xc0000000,0xf26007c0,0x0,0x0,0xf26007c0,0xf26007c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf26007c0,0xf26007c0,0x0,0x0,0x0,0x0,0x0,0xf26007c0,0x0,0x0,0x0,0x0,0x0,0x6001c0,0x0,0xf26007c0,0xf26007c0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x0,0xf8000000,0xc0000000,0x0,0x0,0xf8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x0,0x0,0x0,0x0,0x0,0x300000,0x0,0xf8000000,0x0,0x0,0x0,0xf8000000,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0xf005c1,0x0,0xf005c1,0x0,0x0,0x0,0x0,0x0,0x6001c0,0x0,0x0,0x0,0x0,0x0,0xf0f007c0,0xf0f007c0,0x0,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300000,0x0,0xf26007c0,0xf26007c0,0x0,0x0,0x0,0xf26007c0,0xf26007c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6005c0,0x0,0x0,0x6005c0,0x0,0x30000000,0x6007c0,0x0,0x0,0x0,0x0,0x6005c0,0x0,0x0,0x6005c0,0x0,0xf005c1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0xfc,0xfc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf005c0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0xf005c0,0x0,0x0,0xf001c0,0x400,0x400,0xf005c0,0xf001c0,0x0,0xf005c0,0x0,0x0,0x0,0x0,0x0,0x0,0x306007c0,0x0,0x0,0x0,0x6005c0,0x0,0x0,0x6005c0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0xc0003,0x0,0x0,0x0,0x0,0x21000,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x100080,0x100080,0x0,0x100000,0x0,0x0,0x0,0x100000,0x0,0x0,0xc0493,0x0,0x0,0x0,0x163280,0x0,0x0,0x123280,0x0,0x0,0x40000,0x0,0x0,0x40000,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x40003,0x40003,0x0,0x0,0x40003,0x40003,0x0,0x123200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x43000,0x43000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0xc0493,0xc0493,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x40000,0x40000,0x40000,0x0,0x0,0x0,0x0,0x41000,0x0,0x0,0x40000,0x42000,0x42000,0x0,0x40400,0x0,0x800,0x0,0x0,0x0,0x0,0xfffe3400,0x3,0xc0493,0x0,0x0,0xc0493,0xc0493,0x0,0xc,0x0,0x0,0x0,0x100,0xc,0x0,0xc0493,0xc0493,0x0,0x0,0x0,0x0,0x0,0xc0493,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0xc0493,0xc0493,0x0,0x0,0x0,0x0,0x0,0x0,0x80003,0x0,0x80003,0x3,0x0,0x0,0x80003,0x0,0xc,0x0,0x0,0x0,0x100,0xc,0x0,0x80003,0x0,0x0,0x0,0x0,0x0,0x80003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80003,0x0,0x0,0x0,0x80003,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0xfffe3400,0x0,0xfffe3400,0x0,0x0,0x0,0x0,0x0,0xc0000,0x200,0x0,0x0,0x0,0x0,0x140003,0x140003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0493,0xc0493,0x0,0x0,0x0,0xc0493,0xc0493,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x40000,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x40000,0x0,0xfffe3600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffe3400,0x0,0x0,0xfff82000,0x0,0x0,0x0,0x0,0xfff63400,0xfff02000,0x0,0x400,0x40000,0x40000,0x40400,0x40000,0x0,0x61400,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x40000,0x0,0x0,0x40000,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x400,0x4000,0x4000,0x0,0x0,0x0,0x3b80,0x4000,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6280,0x0,0x0,0x0,0x2e00df80,0x0,0x0,0x2e00df00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2e00df00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000000,0xc000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6380,0x6380,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000000,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000ff,0x0,0x6280,0x0,0x0,0x7280,0x7280,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7280,0x7280,0x0,0x0,0x0,0x0,0x0,0x6280,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x7a80,0x7a80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000ff,0x0,0xe0000ff,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7280,0x7280,0x0,0x0,0x0,0x7280,0x7280,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000ff,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000ff,0x0,0x0,0xc00007f,0x0,0x0,0x0,0x0,0xe0000ff,0x7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000080,0x0,0xc000000,0x0,0x0,0x0,0x0,0x1b80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[11];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public Parser(CharStream stream) {
    token_source = new ParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 301; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 301; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 301; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 301; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[127];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 301; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 127; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 11; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
